/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.router.jersey;

import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpHeaderValues;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.HttpServerBuilder;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.router.jersey.AbstractJerseyStreamingHttpServiceTest;
import io.servicetalk.http.router.jersey.HttpJerseyRouterBuilder;
import io.servicetalk.http.router.jersey.TestUtils;
import io.servicetalk.http.router.jersey.resources.AsynchronousResources;
import io.servicetalk.http.router.jersey.resources.SynchronousResources;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.NameBinding;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import net.javacrumbs.jsonunit.JsonMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public abstract class AbstractResourceTest
extends AbstractJerseyStreamingHttpServiceTest {
    private boolean serverNoOffloads;

    void setUp(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        Assertions.assertDoesNotThrow(() -> super.setUp(api));
        this.serverNoOffloads = serverNoOffloads;
        AbstractResourceTest.assumeSafeToDisableOffloading(serverNoOffloads, api);
    }

    static List<Arguments> data() {
        ArrayList<Arguments> params = new ArrayList<Arguments>();
        for (AbstractJerseyStreamingHttpServiceTest.RouterApi value : AbstractJerseyStreamingHttpServiceTest.RouterApi.values()) {
            params.add(Arguments.of((Object[])new Object[]{false, value}));
            params.add(Arguments.of((Object[])new Object[]{true, value}));
        }
        return params;
    }

    boolean serverNoOffloads() {
        return this.serverNoOffloads;
    }

    @Override
    void configureBuilders(HttpServerBuilder serverBuilder, HttpJerseyRouterBuilder jerseyRouterBuilder) {
        super.configureBuilders(serverBuilder, jerseyRouterBuilder);
        if (this.serverNoOffloads) {
            serverBuilder.executionStrategy(HttpExecutionStrategies.offloadNone());
        }
    }

    @Override
    protected Application application() {
        return new TestApplication();
    }

    abstract String resourcePath();

    @Override
    protected String testUri(String path) {
        return this.resourcePath() + path;
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void notFound(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AbstractResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertNoResponse(this.head("/not_a_resource"), HttpResponseStatus.NOT_FOUND));
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void notTranslatedException(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AbstractResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertNoResponse(this.get("/text?qp=throw-not-translated"), HttpResponseStatus.INTERNAL_SERVER_ERROR));
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void translatedException(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AbstractResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertNoResponse(this.get("/text?qp=throw-translated"), HttpResponseStatus.CONFLICT));
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void implicitHead(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AbstractResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertResponse(this.head("/text"), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, (Matcher<String>)Matchers.emptyString(), 16));
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void explicitHead(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AbstractResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertResponse(this.head("/head"), HttpResponseStatus.ACCEPTED, HttpHeaderValues.TEXT_PLAIN, (Matcher<String>)Matchers.emptyString(), 123));
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void implicitOptions(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AbstractResourceTest.runTwiceToEnsureEndpointCache(() -> {
            StreamingHttpResponse res = this.sendAndAssertResponse(this.options("/text"), HttpResponseStatus.OK, CharSequences.newAsciiString((CharSequence)"application/vnd.sun.wadl+xml"), (Matcher<String>)Matchers.not((Matcher)Matchers.emptyString()), String::length);
            MatcherAssert.assertThat((Object)res.headers().get((CharSequence)"Allow").toString().split(","), (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new String[]{"HEAD", "POST", "GET", "OPTIONS"})));
        });
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void getText(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AbstractResourceTest.runTwiceToEnsureEndpointCache(() -> {
            this.sendAndAssertResponse(this.get("/text"), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, "GOT: null & null");
            this.sendAndAssertResponse(this.get("/text?null=true"), HttpResponseStatus.NO_CONTENT, null, (Matcher<String>)Matchers.emptyString(), __ -> null);
        });
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void getTextQueryParam(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AbstractResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertResponse(this.get("/text?qp=foo%20%7Cbar"), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, "GOT: foo |bar & null"));
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void getTextHeaderParam(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AbstractResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertResponse(this.withHeader(this.get("/text"), "hp", "bar"), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, "GOT: null & bar"));
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void postText(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AbstractResourceTest.runTwiceToEnsureEndpointCache(() -> {
            this.sendAndAssertResponse(this.post("/text", "foo", HttpHeaderValues.TEXT_PLAIN), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, "GOT: foo");
            CharSequence payload = TestUtils.newLargePayload();
            this.sendAndAssertResponse(this.post("/text", payload, HttpHeaderValues.TEXT_PLAIN), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, (Matcher<String>)Matchers.is((Object)("GOT: " + payload)), __ -> null);
        });
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void postTextNoEntity(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AbstractResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertResponse(this.noPayloadRequest(HttpRequestMethod.POST, "/text"), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, "GOT: "));
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void getTextResponse(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AbstractResourceTest.runTwiceToEnsureEndpointCache(() -> {
            StreamingHttpResponse res = this.sendAndAssertResponse(this.withHeader(this.get("/text-response"), "hdr", "bar"), HttpResponseStatus.NO_CONTENT, null, (Matcher<String>)Matchers.emptyString(), __ -> null);
            MatcherAssert.assertThat((Object)res.headers().get((CharSequence)"X-Test"), (Matcher)Matchers.is((Object)CharSequences.newAsciiString((CharSequence)"bar")));
        });
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void postTextResponse(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AbstractResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertResponse(this.withHeader(this.post("/text-response", "foo", HttpHeaderValues.TEXT_PLAIN), "hdr", "bar"), HttpResponseStatus.ACCEPTED, HttpHeaderValues.TEXT_PLAIN, "GOT: foo"));
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void filtered(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AbstractResourceTest.runTwiceToEnsureEndpointCache(() -> {
            StreamingHttpResponse res = this.sendAndAssertResponse(this.post("/filtered", "foo1", HttpHeaderValues.TEXT_PLAIN), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, "GOT: foo1");
            MatcherAssert.assertThat((Object)res.headers().get((CharSequence)"X-Foo-Prop"), (Matcher)Matchers.is((Object)CharSequences.newAsciiString((CharSequence)"barProp")));
            res = this.sendAndAssertNoResponse(this.withHeader(this.post("/filtered", "foo2", HttpHeaderValues.TEXT_PLAIN), "X-Abort-With-Status", "451"), HttpResponseStatus.of((int)451, (String)""));
            MatcherAssert.assertThat((Object)res.headers().get((CharSequence)"X-Foo-Prop"), (Matcher)Matchers.is((Object)CharSequences.newAsciiString((CharSequence)"barProp")));
        });
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void getJson(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AbstractResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertResponse(this.get("/json"), HttpResponseStatus.OK, HttpHeaderValues.APPLICATION_JSON, (Matcher<String>)JsonMatchers.jsonStringEquals((Object)"{\"foo\":\"bar0\"}"), this.getJsonResponseContentLengthExtractor()));
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void postJson(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AbstractResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertResponse(this.post("/json", "{\"key\":\"val0\"}", HttpHeaderValues.APPLICATION_JSON), HttpResponseStatus.OK, HttpHeaderValues.APPLICATION_JSON, (Matcher<String>)JsonMatchers.jsonStringEquals((Object)"{\"key\":\"val0\",\"foo\":\"bar1\"}"), this.getJsonResponseContentLengthExtractor()));
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void putJsonResponse(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AbstractResourceTest.runTwiceToEnsureEndpointCache(() -> {
            StreamingHttpResponse res = this.sendAndAssertResponse(this.put("/json-response", "{\"key\":\"val1\"}", HttpHeaderValues.APPLICATION_JSON), HttpResponseStatus.ACCEPTED, HttpHeaderValues.APPLICATION_JSON, (Matcher<String>)JsonMatchers.jsonStringEquals((Object)"{\"key\":\"val1\",\"foo\":\"bar2\"}"), this.getJsonResponseContentLengthExtractor());
            MatcherAssert.assertThat((Object)res.headers().get((CharSequence)"X-Test"), (Matcher)Matchers.is((Object)CharSequences.newAsciiString((CharSequence)"test-header")));
        });
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void getTextBuffer(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AbstractResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertResponse(this.get("/text-buffer"), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, "DONE"));
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void getTextBufferResponse(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AbstractResourceTest.runTwiceToEnsureEndpointCache(() -> {
            StreamingHttpResponse res = this.sendAndAssertResponse(this.withHeader(this.get("/text-buffer-response"), "hdr", "bar"), HttpResponseStatus.NON_AUTHORITATIVE_INFORMATION, HttpHeaderValues.TEXT_PLAIN, "DONE");
            MatcherAssert.assertThat((Object)res.headers().get((CharSequence)"X-Test"), (Matcher)Matchers.is((Object)CharSequences.newAsciiString((CharSequence)"bar")));
        });
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void postTextBuffer(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AbstractResourceTest.runTwiceToEnsureEndpointCache(() -> {
            this.sendAndAssertResponse(this.post("/text-buffer", "foo", HttpHeaderValues.TEXT_PLAIN), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, "GOT: foo");
            CharSequence payload = TestUtils.newLargePayload();
            this.sendAndAssertResponse(this.post("/text-buffer", payload, HttpHeaderValues.TEXT_PLAIN), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, "GOT: " + payload);
        });
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void postJsonBuffer(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AbstractResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertResponse(this.post("/json-buffer", "{\"key\":456}", HttpHeaderValues.APPLICATION_JSON), HttpResponseStatus.OK, HttpHeaderValues.APPLICATION_JSON, (Matcher<String>)JsonMatchers.jsonStringEquals((Object)"{\"got\":{\"key\":456}}"), String::length));
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void postTextBufferResponse(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AbstractResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertResponse(this.withHeader(this.post("/text-buffer-response", "foo", HttpHeaderValues.TEXT_PLAIN), "hdr", "bar"), HttpResponseStatus.ACCEPTED, HttpHeaderValues.TEXT_PLAIN, "GOT: foo"));
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void postJsonPojoInPojoOut(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AbstractResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertResponse(this.post("/json-pojoin-pojoout", "{\"aString\":\"val8\",\"anInt\":123}", HttpHeaderValues.APPLICATION_JSON), HttpResponseStatus.OK, HttpHeaderValues.APPLICATION_JSON, (Matcher<String>)JsonMatchers.jsonEquals((Object)"{\"aString\":\"val8x\",\"anInt\":124}"), this.getJsonResponseContentLengthExtractor()));
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void postTextBytes(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AbstractResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertResponse(this.post("/text-bytes", "bar", HttpHeaderValues.TEXT_PLAIN), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, "GOT: bar"));
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void postJsonBytes(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AbstractResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertResponse(this.post("/json-bytes", "{\"key\":789}", HttpHeaderValues.APPLICATION_JSON), HttpResponseStatus.OK, HttpHeaderValues.APPLICATION_JSON, (Matcher<String>)JsonMatchers.jsonStringEquals((Object)"{\"got\":{\"key\":789}}"), String::length));
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void postBadJson(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AbstractResourceTest.runTwiceToEnsureEndpointCache(() -> {
            this.sendAndAssertStatusOnly(this.post("/json-pojoin-pojoout", "{key:789}", HttpHeaderValues.APPLICATION_JSON), HttpResponseStatus.BAD_REQUEST);
            this.sendAndAssertStatusOnly(this.post("/json-pojoin-pojoout", "{\"foo\":\"bar\"}", HttpHeaderValues.APPLICATION_JSON), HttpResponseStatus.BAD_REQUEST);
        });
    }

    static void assumeSafeToDisableOffloading(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        Assumptions.assumeFalse((serverNoOffloads && api == AbstractJerseyStreamingHttpServiceTest.RouterApi.BLOCKING_STREAMING ? 1 : 0) != 0, (String)"BlockingStreaming + noOffloads = deadlock");
    }

    static class TestApplication
    extends Application {
        TestApplication() {
        }

        public Set<Class<?>> getClasses() {
            return new HashSet(Arrays.asList(TestFilter.class, SynchronousResources.class, AsynchronousResources.class));
        }
    }

    @TestFiltered
    @Provider
    public static class TestFilter
    implements ContainerRequestFilter,
    ContainerResponseFilter {
        private static final String TEST_PROPERTY_NAME = "fooProp";

        public void filter(ContainerRequestContext requestContext) {
            String abortStatus = requestContext.getHeaderString("X-Abort-With-Status");
            if (abortStatus != null) {
                requestContext.abortWith(Response.status((int)Integer.parseInt(abortStatus)).build());
            }
            requestContext.setProperty(TEST_PROPERTY_NAME, (Object)"barProp");
        }

        public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
            responseContext.getHeaders().add((Object)"X-Foo-Prop", requestContext.getProperty(TEST_PROPERTY_NAME));
        }
    }

    @NameBinding
    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TestFiltered {
    }
}

