/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.router.jersey;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.buffer.netty.BufferAllocators;
import io.servicetalk.concurrent.api.BlockingTestUtils;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.TestTimeoutConstants;
import io.servicetalk.http.api.BlockingHttpService;
import io.servicetalk.http.api.BlockingStreamingHttpService;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaderValues;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.HttpServerBuilder;
import io.servicetalk.http.api.HttpService;
import io.servicetalk.http.api.StreamingHttpClient;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.netty.HttpClients;
import io.servicetalk.http.netty.HttpServers;
import io.servicetalk.http.router.jersey.DefaultJerseyStreamingHttpRouter;
import io.servicetalk.http.router.jersey.HttpJerseyRouterBuilder;
import io.servicetalk.http.router.jersey.TestUtils;
import io.servicetalk.transport.api.HostAndPort;
import io.servicetalk.transport.api.ServerContext;
import io.servicetalk.transport.netty.internal.AddressUtils;
import io.servicetalk.transport.netty.internal.ExecutionContextExtension;
import java.net.SocketAddress;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.CommonProperties;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.extension.RegisterExtension;

public abstract class AbstractJerseyStreamingHttpServiceTest {
    @RegisterExtension
    final ExecutionContextExtension serverCtx = ExecutionContextExtension.cached((String)"stserverio", (String)"serverctx");
    protected RouterApi api;
    private ServerContext serverContext;
    private String hostHeader;
    private boolean streamingJsonEnabled;
    private StreamingHttpClient httpClient;

    protected void setUp(RouterApi api) throws Exception {
        this.api = api;
        HttpServerBuilder serverBuilder = HttpServers.forAddress((SocketAddress)AddressUtils.localAddress((int)0));
        HttpJerseyRouterBuilder routerBuilder = new HttpJerseyRouterBuilder();
        this.configureBuilders(serverBuilder, routerBuilder);
        DefaultJerseyStreamingHttpRouter router = routerBuilder.from(this.application());
        Configuration config = router.configuration();
        this.streamingJsonEnabled = ((String)CommonProperties.getValue((Map)config.getProperties(), (RuntimeType)config.getRuntimeType(), (String)"jersey.config.jsonFeature", (Object)"", String.class)).toLowerCase(Locale.ENGLISH).contains("servicetalk");
        HttpServerBuilder httpServerBuilder = serverBuilder.ioExecutor(this.serverCtx.ioExecutor()).bufferAllocator(this.serverCtx.bufferAllocator());
        switch (api) {
            case ASYNC_AGGREGATED: {
                this.serverContext = this.buildRouter(httpServerBuilder, HttpJerseyRouterBuilder.toAggregated((DefaultJerseyStreamingHttpRouter)router));
                break;
            }
            case ASYNC_STREAMING: {
                this.serverContext = this.buildRouter(httpServerBuilder, (StreamingHttpService)router);
                break;
            }
            case BLOCKING_AGGREGATED: {
                this.serverContext = this.buildRouter(httpServerBuilder, HttpJerseyRouterBuilder.toBlocking((DefaultJerseyStreamingHttpRouter)router));
                break;
            }
            case BLOCKING_STREAMING: {
                this.serverContext = this.buildRouter(httpServerBuilder, HttpJerseyRouterBuilder.toBlockingStreaming((DefaultJerseyStreamingHttpRouter)router));
                break;
            }
            default: {
                throw new IllegalArgumentException(api.name());
            }
        }
        HostAndPort hostAndPort = AddressUtils.serverHostAndPort((ServerContext)this.serverContext);
        this.httpClient = HttpClients.forSingleAddress((HostAndPort)hostAndPort).buildStreaming();
        this.hostHeader = AddressUtils.hostHeader((HostAndPort)hostAndPort);
    }

    ServerContext buildRouter(HttpServerBuilder httpServerBuilder, HttpService router) throws Exception {
        return httpServerBuilder.listenAndAwait(router);
    }

    ServerContext buildRouter(HttpServerBuilder httpServerBuilder, StreamingHttpService router) throws Exception {
        return httpServerBuilder.listenStreamingAndAwait(router);
    }

    ServerContext buildRouter(HttpServerBuilder httpServerBuilder, BlockingHttpService router) throws Exception {
        return httpServerBuilder.listenBlockingAndAwait(router);
    }

    ServerContext buildRouter(HttpServerBuilder httpServerBuilder, BlockingStreamingHttpService router) throws Exception {
        return httpServerBuilder.listenBlockingStreamingAndAwait(router);
    }

    void configureBuilders(HttpServerBuilder serverBuilder, HttpJerseyRouterBuilder jerseyRouterBuilder) {
        serverBuilder.executor(this.serverCtx.executor()).executionStrategy(HttpExecutionStrategies.defaultStrategy());
    }

    @AfterEach
    public final void closeClient() throws Exception {
        if (this.httpClient != null) {
            this.httpClient.closeAsync().toFuture().get();
        }
    }

    @AfterEach
    public final void closeServer() throws Exception {
        if (this.serverContext != null) {
            this.serverContext.closeAsync().toFuture().get();
        }
    }

    protected abstract Application application();

    String host() {
        return this.hostHeader;
    }

    boolean isStreamingJsonEnabled() {
        return this.streamingJsonEnabled;
    }

    protected String testUri(String path) {
        return path;
    }

    StreamingHttpRequest options(String path) {
        return this.noPayloadRequest(HttpRequestMethod.OPTIONS, path);
    }

    StreamingHttpRequest head(String path) {
        return this.noPayloadRequest(HttpRequestMethod.HEAD, path);
    }

    StreamingHttpRequest get(String path) {
        return this.noPayloadRequest(HttpRequestMethod.GET, path);
    }

    protected StreamingHttpRequest post(String path, CharSequence payload, CharSequence contentType) {
        return this.payloadRequest(HttpRequestMethod.POST, path, payload, contentType);
    }

    protected StreamingHttpRequest post(String path, byte[] payload, CharSequence contentType) {
        return this.payloadRequest(HttpRequestMethod.POST, path, payload, contentType);
    }

    StreamingHttpRequest put(String path, CharSequence payload, CharSequence contentType) {
        return this.payloadRequest(HttpRequestMethod.PUT, path, payload, contentType);
    }

    StreamingHttpRequest noPayloadRequest(HttpRequestMethod method, String path) {
        StreamingHttpRequest req = this.httpClient.newRequest(method, this.testUri(path));
        req.headers().set(HttpHeaderNames.HOST, (CharSequence)this.host());
        return req;
    }

    private StreamingHttpRequest payloadRequest(HttpRequestMethod method, String path, CharSequence payload, CharSequence contentType) {
        return this.payloadRequest(method, path, BufferAllocators.DEFAULT_ALLOCATOR.fromUtf8(payload), contentType);
    }

    private StreamingHttpRequest payloadRequest(HttpRequestMethod method, String path, byte[] payload, CharSequence contentType) {
        return this.payloadRequest(method, path, BufferAllocators.DEFAULT_ALLOCATOR.wrap(payload), contentType);
    }

    private StreamingHttpRequest payloadRequest(HttpRequestMethod method, String path, Buffer content, CharSequence contentType) {
        StreamingHttpRequest req = this.httpClient.newRequest(method, this.testUri(path)).payloadBody(Publisher.from((Object)content));
        req.headers().set(HttpHeaderNames.HOST, (CharSequence)this.host());
        req.headers().set(HttpHeaderNames.CONTENT_TYPE, contentType);
        req.headers().set(HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Integer.toString(content.readableBytes()));
        return req;
    }

    StreamingHttpRequest withHeader(StreamingHttpRequest req, String name, String value) {
        req.headers().set((CharSequence)name, (CharSequence)value);
        return req;
    }

    Function<String, Integer> getJsonResponseContentLengthExtractor() {
        return this.isStreamingJsonEnabled() ? __ -> null : String::length;
    }

    protected StreamingHttpResponse sendAndAssertNoResponse(StreamingHttpRequest req, HttpResponseStatus expectedStatus) {
        return this.sendAndAssertResponse(req, expectedStatus, null, "");
    }

    protected String sendAndAssertStatusOnly(StreamingHttpRequest req, HttpResponseStatus expectedStatus) {
        StreamingHttpResponse res = this.sendAndAssertStatus(req, HttpProtocolVersion.HTTP_1_1, expectedStatus, TestTimeoutConstants.DEFAULT_TIMEOUT_SECONDS, TimeUnit.SECONDS);
        return TestUtils.getContentAsString(res);
    }

    protected StreamingHttpResponse sendAndAssertResponse(StreamingHttpRequest req, HttpResponseStatus expectedStatus, @Nullable CharSequence expectedContentType, String expectedContent) {
        return this.sendAndAssertResponse(req, expectedStatus, expectedContentType, (Matcher<String>)Matchers.is((Object)expectedContent), __ -> expectedContent.length());
    }

    StreamingHttpResponse sendAndAssertResponse(StreamingHttpRequest req, HttpResponseStatus expectedStatus, @Nullable CharSequence expectedContentType, Matcher<String> contentMatcher, int expectedContentLength) {
        return this.sendAndAssertResponse(req, expectedStatus, expectedContentType, contentMatcher, __ -> expectedContentLength);
    }

    protected StreamingHttpResponse sendAndAssertResponse(StreamingHttpRequest req, HttpResponseStatus expectedStatus, @Nullable CharSequence expectedContentType, Matcher<String> contentMatcher, Function<String, Integer> expectedContentLengthExtractor) {
        return this.sendAndAssertResponse(req, HttpProtocolVersion.HTTP_1_1, expectedStatus, expectedContentType, contentMatcher, expectedContentLengthExtractor);
    }

    StreamingHttpResponse sendAndAssertResponse(StreamingHttpRequest req, HttpResponseStatus expectedStatus, CharSequence expectedContentType, String expectedContent, int timeout, TimeUnit unit) {
        return this.sendAndAssertResponse(req, HttpProtocolVersion.HTTP_1_1, expectedStatus, expectedContentType, (Matcher<String>)Matchers.is((Object)expectedContent), __ -> expectedContent.length(), timeout, unit);
    }

    StreamingHttpResponse sendAndAssertResponse(StreamingHttpRequest req, HttpProtocolVersion expectedHttpVersion, HttpResponseStatus expectedStatus, @Nullable CharSequence expectedContentType, Matcher<String> contentMatcher, Function<String, Integer> expectedContentLengthExtractor) {
        return this.sendAndAssertResponse(req, expectedHttpVersion, expectedStatus, expectedContentType, contentMatcher, expectedContentLengthExtractor, TestTimeoutConstants.DEFAULT_TIMEOUT_SECONDS, TimeUnit.SECONDS);
    }

    private StreamingHttpResponse sendAndAssertResponse(StreamingHttpRequest req, HttpProtocolVersion expectedHttpVersion, HttpResponseStatus expectedStatus, @Nullable CharSequence expectedContentType, Matcher<String> contentMatcher, Function<String, Integer> expectedContentLengthExtractor, int timeout, TimeUnit unit) {
        StreamingHttpResponse res = this.sendAndAssertStatus(req, expectedHttpVersion, expectedStatus, timeout, unit);
        if (expectedContentType != null) {
            CharSequence contentType = res.headers().get(HttpHeaderNames.CONTENT_TYPE);
            MatcherAssert.assertThat((Object)contentType, (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)contentType.toString(), (Matcher)Matchers.equalTo((Object)expectedContentType.toString()));
        } else {
            MatcherAssert.assertThat((Object)res.headers().contains(HttpHeaderNames.CONTENT_TYPE), (Matcher)Matchers.is((Object)false));
        }
        String contentAsString = TestUtils.getContentAsString(res);
        Integer expectedContentLength = expectedContentLengthExtractor.apply(contentAsString);
        if (expectedContentLength != null) {
            MatcherAssert.assertThat((Object)res.headers().get(HttpHeaderNames.CONTENT_LENGTH), (Matcher)Matchers.is((Object)CharSequences.newAsciiString((CharSequence)Integer.toString(expectedContentLength))));
            res.headers().valuesIterator(HttpHeaderNames.TRANSFER_ENCODING).forEachRemaining(h -> MatcherAssert.assertThat((Object)h.toString(), (Matcher)Matchers.equalToIgnoringCase((String)"chunked")));
        } else {
            MatcherAssert.assertThat((Object)res.headers().contains(HttpHeaderNames.CONTENT_LENGTH), (Matcher)Matchers.is((Object)false));
            if (HttpResponseStatus.StatusClass.SUCCESSFUL_2XX.contains(res.status()) && !HttpResponseStatus.NO_CONTENT.equals((Object)res.status()) && !HttpRequestMethod.HEAD.equals((Object)req.method())) {
                MatcherAssert.assertThat((Object)res.headers().get(HttpHeaderNames.TRANSFER_ENCODING), (Matcher)Matchers.is((Object)HttpHeaderValues.CHUNKED));
            }
        }
        MatcherAssert.assertThat((Object)contentAsString, contentMatcher);
        return res;
    }

    private StreamingHttpResponse sendAndAssertStatus(StreamingHttpRequest req, HttpProtocolVersion expectedHttpVersion, HttpResponseStatus expectedStatus, int timeout, TimeUnit unit) {
        try {
            StreamingHttpResponse res = (StreamingHttpResponse)BlockingTestUtils.awaitNonNull((Single)this.httpClient.request(req), (long)timeout, (TimeUnit)unit);
            MatcherAssert.assertThat((Object)res.version(), (Matcher)Matchers.is((Object)expectedHttpVersion));
            HttpResponseStatus status = res.status();
            MatcherAssert.assertThat((Object)status, (Matcher)Matchers.is((Object)expectedStatus));
            MatcherAssert.assertThat((Object)status.reasonPhrase(), (Matcher)Matchers.is((Object)expectedStatus.reasonPhrase()));
            return res;
        }
        catch (AssertionError ae) {
            throw ae;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    protected static void runTwiceToEnsureEndpointCache(Runnable test) {
        test.run();
        test.run();
    }

    public static enum RouterApi {
        ASYNC_AGGREGATED,
        ASYNC_STREAMING,
        BLOCKING_AGGREGATED,
        BLOCKING_STREAMING;

    }
}

