/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.router.jersey;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.HttpHeaderValues;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.router.jersey.AbstractJerseyStreamingHttpServiceTest;
import io.servicetalk.http.router.jersey.AbstractMessageBodyReaderWriter;
import io.servicetalk.http.router.jersey.TestPojo;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import net.javacrumbs.jsonunit.JsonMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public abstract class AbstractFilterInterceptorTest
extends AbstractJerseyStreamingHttpServiceTest {
    @ParameterizedTest
    @EnumSource(value=AbstractJerseyStreamingHttpServiceTest.RouterApi.class)
    void synchronousResource(AbstractJerseyStreamingHttpServiceTest.RouterApi api) throws Exception {
        this.setUp(api);
        AbstractFilterInterceptorTest.runTwiceToEnsureEndpointCache(() -> {
            this.sendAndAssertResponse(this.post("/sync/text", "foo1", HttpHeaderValues.TEXT_PLAIN), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, "G0T: F001");
            this.sendAndAssertResponse(this.post("/sync/text-response", "foo2", HttpHeaderValues.TEXT_PLAIN), HttpResponseStatus.ACCEPTED, HttpHeaderValues.TEXT_PLAIN, "G0T: F002");
            this.sendAndAssertResponse(this.post("/sync/json", "{\"key\":\"val1\"}", HttpHeaderValues.APPLICATION_JSON), HttpResponseStatus.OK, HttpHeaderValues.APPLICATION_JSON, (Matcher<String>)JsonMatchers.jsonEquals((Object)"{\"KEY\":\"VAL1\",\"f00\":\"bar1\"}"), this.getJsonResponseContentLengthExtractor());
            this.sendAndAssertResponse(this.put("/sync/json-response", "{\"key\":\"val2\"}", HttpHeaderValues.APPLICATION_JSON), HttpResponseStatus.ACCEPTED, HttpHeaderValues.APPLICATION_JSON, (Matcher<String>)JsonMatchers.jsonEquals((Object)"{\"KEY\":\"VAL2\",\"f00\":\"bar2\"}"), this.getJsonResponseContentLengthExtractor());
        });
    }

    @ParameterizedTest
    @EnumSource(value=AbstractJerseyStreamingHttpServiceTest.RouterApi.class)
    void publisherResources(AbstractJerseyStreamingHttpServiceTest.RouterApi api) throws Exception {
        this.setUp(api);
        AbstractFilterInterceptorTest.runTwiceToEnsureEndpointCache(() -> {
            this.sendAndAssertResponse(this.post("/sync/text-strin-pubout", "foo1", HttpHeaderValues.TEXT_PLAIN), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, (Matcher<String>)Matchers.is((Object)"G0T: F001"), __ -> null);
            this.sendAndAssertResponse(this.post("/sync/text-pubin-strout", "foo2", HttpHeaderValues.TEXT_PLAIN), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, "G0T: F002");
            this.sendAndAssertResponse(this.post("/sync/text-pubin-pubout", "foo3", HttpHeaderValues.TEXT_PLAIN), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, (Matcher<String>)Matchers.is((Object)"G0T: F003"), __ -> null);
        });
    }

    @ParameterizedTest
    @EnumSource(value=AbstractJerseyStreamingHttpServiceTest.RouterApi.class)
    void oioStreamsResource(AbstractJerseyStreamingHttpServiceTest.RouterApi api) throws Exception {
        this.setUp(api);
        AbstractFilterInterceptorTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertResponse(this.post("/sync/text-oio-streams", "bar", HttpHeaderValues.TEXT_PLAIN), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, "G0T: BAR"));
    }

    @ParameterizedTest
    @EnumSource(value=AbstractJerseyStreamingHttpServiceTest.RouterApi.class)
    void asynchronousResource(AbstractJerseyStreamingHttpServiceTest.RouterApi api) throws Exception {
        this.setUp(api);
        AbstractFilterInterceptorTest.runTwiceToEnsureEndpointCache(() -> {
            this.sendAndAssertResponse(this.post("/async/text", "baz1", HttpHeaderValues.TEXT_PLAIN), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, "G0T: BAZ1");
            this.sendAndAssertResponse(this.post("/async/text-response", "baz2", HttpHeaderValues.TEXT_PLAIN), HttpResponseStatus.ACCEPTED, HttpHeaderValues.TEXT_PLAIN, "G0T: BAZ2");
        });
    }

    @ParameterizedTest
    @EnumSource(value=AbstractJerseyStreamingHttpServiceTest.RouterApi.class)
    void singleResources(AbstractJerseyStreamingHttpServiceTest.RouterApi api) throws Exception {
        this.setUp(api);
        AbstractFilterInterceptorTest.runTwiceToEnsureEndpointCache(() -> {
            this.sendAndAssertResponse(this.post("/sync/json-buf-sglin-sglout-response", "{\"key\":\"val1\"}", HttpHeaderValues.APPLICATION_JSON), HttpResponseStatus.ACCEPTED, HttpHeaderValues.APPLICATION_JSON, (Matcher<String>)JsonMatchers.jsonEquals((Object)"{\"KEY\":\"VAL1\",\"f00\":\"bar6\"}"), __ -> null);
            this.sendAndAssertResponse(this.get("/async/single-response"), HttpResponseStatus.ACCEPTED, HttpHeaderValues.TEXT_PLAIN, "D0NE");
            this.sendAndAssertResponse(this.get("/async/single-map"), HttpResponseStatus.OK, HttpHeaderValues.APPLICATION_JSON, (Matcher<String>)JsonMatchers.jsonEquals((Object)"{\"f00\":\"bar4\"}"), this.getJsonResponseContentLengthExtractor());
            this.sendAndAssertResponse(this.get("/async/single-pojo"), HttpResponseStatus.OK, HttpHeaderValues.APPLICATION_JSON, (Matcher<String>)JsonMatchers.jsonEquals((Object)"{\"aString\":\"b00\",\"anInt\":456}"), this.getJsonResponseContentLengthExtractor());
            this.sendAndAssertResponse(this.post("/async/json-buf-sglin-sglout", "{\"key\":\"val3\"}", HttpHeaderValues.APPLICATION_JSON), HttpResponseStatus.OK, HttpHeaderValues.APPLICATION_JSON, (Matcher<String>)JsonMatchers.jsonEquals((Object)"{\"KEY\":\"VAL3\",\"f00\":\"bar6\"}"), String::length);
        });
    }

    @ParameterizedTest
    @EnumSource(value=AbstractJerseyStreamingHttpServiceTest.RouterApi.class)
    void bufferResources(AbstractJerseyStreamingHttpServiceTest.RouterApi api) throws Exception {
        this.setUp(api);
        AbstractFilterInterceptorTest.runTwiceToEnsureEndpointCache(() -> {
            this.sendAndAssertResponse(this.get("/sync/text-buffer"), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, "D0NE");
            StreamingHttpResponse res = this.sendAndAssertResponse(this.withHeader(this.get("/sync/text-buffer-response"), "hdr", "bar"), HttpResponseStatus.NON_AUTHORITATIVE_INFORMATION, HttpHeaderValues.TEXT_PLAIN, "D0NE");
            MatcherAssert.assertThat((Object)res.headers().get((CharSequence)"X-Test"), (Matcher)Matchers.is((Object)CharSequences.newAsciiString((CharSequence)"bar")));
            this.sendAndAssertResponse(this.post("/sync/text-buffer", "foo", HttpHeaderValues.TEXT_PLAIN), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, "G0T: F00");
            this.sendAndAssertResponse(this.withHeader(this.post("/sync/text-buffer-response", "foo", HttpHeaderValues.TEXT_PLAIN), "hdr", "bar"), HttpResponseStatus.ACCEPTED, HttpHeaderValues.TEXT_PLAIN, "G0T: F00");
            this.sendAndAssertResponse(this.post("/sync/json-buf-pubin-pubout", "{\"key\":\"foo2\"}", HttpHeaderValues.APPLICATION_JSON), HttpResponseStatus.OK, HttpHeaderValues.APPLICATION_JSON, (Matcher<String>)JsonMatchers.jsonEquals((Object)"{\"KEY\":\"F002\"}"), __ -> null);
            this.sendAndAssertResponse(this.post("/async/json-buf-sglin-sglout?fail=true", "{\"key\":\"val5\"}", HttpHeaderValues.APPLICATION_JSON), HttpResponseStatus.INTERNAL_SERVER_ERROR, null, "");
        });
    }

    private static Buffer oTo0(Buffer buf) {
        for (int i = 0; i < buf.readableBytes(); ++i) {
            byte b = buf.getByte(buf.readerIndex() + i);
            if (b != 111 && b != 79) continue;
            buf.setByte(buf.readerIndex() + i, 48);
        }
        return buf;
    }

    private static Map<String, Object> oTo0(Map<String, Object> map) {
        return map.entrySet().stream().collect(Collectors.toMap(e -> (String)AbstractFilterInterceptorTest.oTo0(e.getKey()), e -> AbstractFilterInterceptorTest.oTo0(e.getValue())));
    }

    private static <T> T oTo0(T o) {
        return (T)(o instanceof String ? ((String)o).replaceAll("[oO]", "0") : o);
    }

    private static class Oto0OutputStream
    extends FilterOutputStream {
        private boolean closed;

        Oto0OutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            super.close();
        }

        @Override
        public void write(int b) throws IOException {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            super.write(b == 111 || b == 79 ? 48 : b);
        }
    }

    public static class UpperCaseInputStream
    extends FilterInputStream {
        private boolean closed;

        public UpperCaseInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            super.close();
        }

        @Override
        public int read() throws IOException {
            this.ensureNotClosed();
            return Character.toUpperCase(super.read());
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.ensureNotClosed();
            int read = super.read(b, off, len);
            for (int i = 0; i < read; ++i) {
                b[off + i] = (byte)Character.toUpperCase(b[off + i]);
            }
            return read;
        }

        private void ensureNotClosed() throws IOException {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
        }
    }

    @Priority(value=4000)
    @Provider
    public static class TestGlobalInterceptor
    implements ReaderInterceptor,
    WriterInterceptor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object aroundReadFrom(ReaderInterceptorContext readerInterceptorCtx) throws IOException {
            InputStream old = readerInterceptorCtx.getInputStream();
            readerInterceptorCtx.setInputStream((InputStream)new UpperCaseInputStream(old));
            try {
                Object object = readerInterceptorCtx.proceed();
                return object;
            }
            finally {
                readerInterceptorCtx.setInputStream(old);
            }
        }

        public void aroundWriteTo(WriterInterceptorContext writerInterceptorCtx) throws IOException {
            if (AbstractMessageBodyReaderWriter.isSourceOfType((Type)writerInterceptorCtx.getGenericType(), Publisher.class, Buffer.class)) {
                Publisher contentWith0 = ((Publisher)writerInterceptorCtx.getEntity()).map(x$0 -> AbstractFilterInterceptorTest.oTo0(x$0));
                writerInterceptorCtx.setEntity((Object)contentWith0);
                writerInterceptorCtx.proceed();
            } else if (AbstractMessageBodyReaderWriter.isSourceOfType((Type)writerInterceptorCtx.getGenericType(), Single.class, Buffer.class)) {
                Single contentWith0 = ((Single)writerInterceptorCtx.getEntity()).map(x$0 -> AbstractFilterInterceptorTest.oTo0(x$0));
                writerInterceptorCtx.setEntity((Object)contentWith0);
                writerInterceptorCtx.proceed();
            } else if (AbstractMessageBodyReaderWriter.isSourceOfType((Type)writerInterceptorCtx.getGenericType(), Single.class, Map.class)) {
                Single contentWith0 = ((Single)writerInterceptorCtx.getEntity()).map(x$0 -> AbstractFilterInterceptorTest.oTo0(x$0));
                writerInterceptorCtx.setEntity((Object)contentWith0);
                writerInterceptorCtx.proceed();
            } else if (writerInterceptorCtx.getEntity() instanceof Buffer) {
                writerInterceptorCtx.setEntity((Object)AbstractFilterInterceptorTest.oTo0((Buffer)writerInterceptorCtx.getEntity()));
                writerInterceptorCtx.proceed();
            } else if (writerInterceptorCtx.getEntity() instanceof Map) {
                Map contentWith0 = AbstractFilterInterceptorTest.oTo0((Map)writerInterceptorCtx.getEntity());
                writerInterceptorCtx.setEntity((Object)contentWith0);
                writerInterceptorCtx.setType(Map.class);
                writerInterceptorCtx.setGenericType(Map.class);
                writerInterceptorCtx.proceed();
            } else if (writerInterceptorCtx.getEntity() instanceof TestPojo) {
                TestPojo contentWith0 = (TestPojo)writerInterceptorCtx.getEntity();
                MatcherAssert.assertThat((Object)contentWith0.getaString(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
                contentWith0.setaString((String)AbstractFilterInterceptorTest.oTo0(contentWith0.getaString()));
                writerInterceptorCtx.setEntity((Object)contentWith0);
                writerInterceptorCtx.proceed();
            } else {
                OutputStream previous = writerInterceptorCtx.getOutputStream();
                writerInterceptorCtx.setOutputStream((OutputStream)new Oto0OutputStream(previous));
                try {
                    writerInterceptorCtx.proceed();
                }
                finally {
                    writerInterceptorCtx.setOutputStream(previous);
                }
            }
        }
    }

    @Priority(value=4000)
    @Provider
    public static class TestInputConsumingGlobalFilter
    extends TestGlobalFilter {
        @Override
        public void filter(ContainerRequestContext requestCtx) {
            try {
                Collection collection = (Collection)Publisher.fromInputStream((InputStream)new UpperCaseInputStream(requestCtx.getEntityStream())).toFuture().get();
                requestCtx.setEntityStream(Publisher.fromIterable((Iterable)collection).toInputStream(Function.identity()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Priority(value=4000)
    @Provider
    public static class TestGlobalFilter
    implements ContainerRequestFilter,
    ContainerResponseFilter {
        public void filter(ContainerRequestContext requestCtx) {
            requestCtx.setEntityStream((InputStream)new UpperCaseInputStream(requestCtx.getEntityStream()));
        }

        public void filter(ContainerRequestContext requestCtx, ContainerResponseContext responseCtx) {
            if (AbstractMessageBodyReaderWriter.isSourceOfType((Type)responseCtx.getEntityType(), Publisher.class, Buffer.class)) {
                Publisher contentWith0 = ((Publisher)responseCtx.getEntity()).map(x$0 -> AbstractFilterInterceptorTest.oTo0(x$0));
                responseCtx.setEntity((Object)new GenericEntity<Publisher<Buffer>>(contentWith0){});
            } else if (AbstractMessageBodyReaderWriter.isSourceOfType((Type)responseCtx.getEntityType(), Single.class, Buffer.class)) {
                Single contentWith0 = ((Single)responseCtx.getEntity()).map(x$0 -> AbstractFilterInterceptorTest.oTo0(x$0));
                responseCtx.setEntity((Object)new GenericEntity<Single<Buffer>>(contentWith0){});
            } else if (AbstractMessageBodyReaderWriter.isSourceOfType((Type)responseCtx.getEntityType(), Single.class, Map.class)) {
                Single contentWith0 = ((Single)responseCtx.getEntity()).map(x$0 -> AbstractFilterInterceptorTest.oTo0(x$0));
                responseCtx.setEntity((Object)new GenericEntity<Single<Map>>(contentWith0){});
            } else if (responseCtx.getEntity() instanceof Buffer) {
                responseCtx.setEntity((Object)AbstractFilterInterceptorTest.oTo0((Buffer)responseCtx.getEntity()));
            } else if (responseCtx.getEntity() instanceof Map) {
                Map contentWith0 = AbstractFilterInterceptorTest.oTo0((Map)responseCtx.getEntity());
                responseCtx.setEntity((Object)new GenericEntity<Map<String, Object>>(contentWith0){});
            } else if (responseCtx.getEntity() instanceof TestPojo) {
                TestPojo contentWith0 = (TestPojo)responseCtx.getEntity();
                MatcherAssert.assertThat((Object)contentWith0.getaString(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
                contentWith0.setaString((String)AbstractFilterInterceptorTest.oTo0(contentWith0.getaString()));
                responseCtx.setEntity((Object)contentWith0);
            } else {
                responseCtx.setEntityStream((OutputStream)new Oto0OutputStream(responseCtx.getEntityStream()));
            }
        }
    }
}

