/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.http.api.BlockingHttpService;
import io.servicetalk.http.api.BlockingUtils;
import io.servicetalk.http.api.HttpRequest;
import io.servicetalk.http.api.HttpResponse;
import io.servicetalk.http.api.HttpResponseFactory;
import io.servicetalk.http.api.HttpServiceContext;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpService;
import java.util.Objects;

final class StreamingHttpServiceToBlockingHttpService
implements BlockingHttpService {
    private final StreamingHttpService original;

    StreamingHttpServiceToBlockingHttpService(StreamingHttpService original) {
        this.original = Objects.requireNonNull(original);
    }

    @Override
    public HttpResponse handle(HttpServiceContext ctx, HttpRequest request, HttpResponseFactory responseFactory) throws Exception {
        return (HttpResponse)BlockingUtils.futureGetCancelOnInterrupt(this.original.handle(ctx, request.toStreamingRequest(), ctx.streamingResponseFactory()).flatMap(StreamingHttpResponse::toResponse).toFuture());
    }

    @Override
    public void close() throws Exception {
        this.original.closeAsync().toFuture().get();
    }
}

