/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.HttpRequest;
import io.servicetalk.http.api.HttpResponse;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.utils.internal.PlatformDependent;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

final class BlockingUtils {
    private BlockingUtils() {
    }

    static Completable blockingToCompletable(RunnableCheckedException r) {
        return Completable.fromRunnable(r::runUnchecked);
    }

    static <T> T futureGetCancelOnInterrupt(Future<T> future) throws Exception {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            future.cancel(false);
            throw e;
        }
        catch (ExecutionException e) {
            return (T)PlatformDependent.throwException((Throwable)BlockingUtils.executionExceptionCause(e));
        }
    }

    static HttpResponse request(StreamingHttpRequester requester, HttpRequest request) throws Exception {
        return (HttpResponse)BlockingUtils.blockingInvocation(requester.request(request.toStreamingRequest()).flatMap(response -> response.toResponse().shareContextOnSubscribe()));
    }

    static <T> T blockingInvocation(Single<T> source) throws Exception {
        try {
            return (T)source.toFuture().get();
        }
        catch (ExecutionException e) {
            return (T)PlatformDependent.throwException((Throwable)BlockingUtils.executionExceptionCause(e));
        }
    }

    static void blockingInvocation(Completable source) throws Exception {
        try {
            source.toFuture().get();
        }
        catch (ExecutionException e) {
            PlatformDependent.throwException((Throwable)BlockingUtils.executionExceptionCause(e));
        }
    }

    private static Throwable executionExceptionCause(ExecutionException original) {
        return original.getCause() != null ? original.getCause() : original;
    }

    static interface RunnableCheckedException {
        public void run() throws Exception;

        default public void runUnchecked() {
            try {
                this.run();
            }
            catch (Exception e) {
                PlatformDependent.throwException((Throwable)e);
            }
        }
    }
}

