/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.http.api.Uri;
import io.servicetalk.http.api.UriComponentType;
import io.servicetalk.http.api.UriUtils;
import java.nio.charset.Charset;
import javax.annotation.Nullable;

final class HttpAuthorityFormUri
implements Uri {
    private final String uri;
    private final String host;
    private final int port;

    HttpAuthorityFormUri(String uri) {
        int i = 0;
        int begin = 0;
        String parsedHost = null;
        int parsedPort = -1;
        int parsingIPv6 = 0;
        boolean foundColonForPort = false;
        while (i < uri.length()) {
            char c = uri.charAt(i);
            if (c == '[') {
                if (parsingIPv6 != 0 || parsedHost != null) {
                    throw new IllegalArgumentException("unexpected [");
                }
                parsingIPv6 = 1;
                begin = i++;
                continue;
            }
            if (c == ']') {
                if (parsingIPv6 == 0) {
                    throw new IllegalArgumentException("unexpected ]");
                }
                if (i - 1 <= begin) {
                    throw new IllegalArgumentException("empty ip literal");
                }
                parsedHost = uri.substring(begin, i + 1);
                foundColonForPort = false;
                parsingIPv6 = 2;
                begin = ++i;
                continue;
            }
            if (c == ':') {
                if (parsingIPv6 == 0) {
                    if (parsedHost != null) {
                        throw new IllegalArgumentException("duplicate/invalid host");
                    }
                    parsedHost = uri.substring(begin, i);
                } else if (parsingIPv6 == 2 && begin != i) {
                    throw new IllegalArgumentException("Port must be immediately after IPv6address");
                }
                ++i;
                if (parsingIPv6 == 1) continue;
                begin = i;
                foundColonForPort = true;
                continue;
            }
            if (c == '@' || c == '?' || c == '#' || c == '/') {
                throw new IllegalArgumentException("authority-form URI doesn't allow userinfo, path, query, fragment");
            }
            ++i;
        }
        if (parsedHost == null) {
            if (parsingIPv6 == 1) {
                throw new IllegalArgumentException("missing closing ] for IP-literal");
            }
            parsedHost = uri;
        } else if (foundColonForPort) {
            parsedPort = UriUtils.parsePort(uri, begin, uri.length());
        } else if (parsedHost.length() != uri.length()) {
            throw new IllegalArgumentException("authority-form URI only supports the host component");
        }
        this.host = parsedHost;
        this.port = parsedPort;
        this.uri = uri;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    @Nullable
    public String scheme() {
        return null;
    }

    @Override
    public String authority() {
        StringBuilder sb = new StringBuilder(this.host.length() + 6);
        sb.append(this.host);
        if (this.port >= 0) {
            sb.append(':').append(this.port);
        }
        return sb.toString();
    }

    @Override
    @Nullable
    public String userInfo() {
        return null;
    }

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public int port() {
        return this.port;
    }

    @Override
    public String path() {
        return "";
    }

    @Override
    public String path(Charset charset) {
        return "";
    }

    @Override
    @Nullable
    public String query() {
        return null;
    }

    @Override
    @Nullable
    public String query(Charset charset) {
        return null;
    }

    @Override
    @Nullable
    public String fragment() {
        return null;
    }

    static String encode(String requestTarget, Charset charset) {
        HttpAuthorityFormUri uri = new HttpAuthorityFormUri(requestTarget);
        StringBuilder sb = new StringBuilder(uri.uri.length() + 16);
        if (!uri.host.isEmpty()) {
            sb.append(uri.host.charAt(0) != '[' ? UriUtils.encodeComponent(UriComponentType.HOST_NON_IP, uri.host, charset, true) : uri.host);
        }
        if (uri.port >= 0) {
            sb.append(':').append(uri.port);
        }
        return sb.toString();
    }

    static String decode(String requestTarget, Charset charset) {
        HttpAuthorityFormUri uri = new HttpAuthorityFormUri(requestTarget);
        StringBuilder sb = new StringBuilder(uri.uri.length());
        if (!uri.host.isEmpty()) {
            sb.append(uri.host.charAt(0) != '[' ? UriUtils.decodeComponent(uri.host, charset) : uri.host);
        }
        if (uri.port >= 0) {
            sb.append(':').append(uri.port);
        }
        return sb.toString();
    }
}

