/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.http.api.DefaultHttpRequestMetaData;
import io.servicetalk.http.api.DefaultPayloadInfo;
import io.servicetalk.http.api.DefaultStreamingHttpRequest;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpHeadersFactory;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.StreamingHttpRequest;

public final class StreamingHttpRequests {
    private StreamingHttpRequests() {
    }

    public static StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget, HttpProtocolVersion version, HttpHeaders headers, BufferAllocator allocator, HttpHeadersFactory headersFactory) {
        return new DefaultStreamingHttpRequest(method, requestTarget, version, headers, null, null, null, allocator, null, DefaultPayloadInfo.forUserCreated(), headersFactory);
    }

    @Deprecated
    public static StreamingHttpRequest newTransportRequest(HttpRequestMethod method, String requestTarget, HttpProtocolVersion version, HttpHeaders headers, BufferAllocator allocator, Publisher<Object> payload, boolean requireTrailerHeader, HttpHeadersFactory headersFactory) {
        return new DefaultStreamingHttpRequest(method, requestTarget, version, headers, null, null, null, allocator, payload, DefaultPayloadInfo.forTransportReceive(requireTrailerHeader, version, headers), headersFactory);
    }

    public static StreamingHttpRequest newTransportRequest(HttpRequestMetaData metaData, BufferAllocator allocator, Publisher<Object> payload, boolean requireTrailerHeader, HttpHeadersFactory headersFactory) {
        ContextMap context = metaData instanceof DefaultHttpRequestMetaData ? ((DefaultHttpRequestMetaData)metaData).context0() : metaData.context();
        return new DefaultStreamingHttpRequest(metaData.method(), metaData.requestTarget(), metaData.version(), metaData.headers(), context, metaData.encoding(), metaData.contentEncoding(), allocator, payload, DefaultPayloadInfo.forTransportReceive(requireTrailerHeader, metaData.version(), metaData.headers()), headersFactory);
    }
}

