/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.BlockingHttpClient;
import io.servicetalk.http.api.BlockingStreamingHttpClient;
import io.servicetalk.http.api.FilterableReservedStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.HttpApiConversions;
import io.servicetalk.http.api.HttpClient;
import io.servicetalk.http.api.HttpConnectionContext;
import io.servicetalk.http.api.HttpEventKey;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.ReservedBlockingHttpConnection;
import io.servicetalk.http.api.ReservedBlockingStreamingHttpConnection;
import io.servicetalk.http.api.ReservedHttpConnection;
import io.servicetalk.http.api.ReservedStreamingHttpConnection;
import io.servicetalk.http.api.StreamingHttpClient;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequestResponseFactory;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;

public final class TestStreamingHttpClient {
    private TestStreamingHttpClient() {
    }

    public static StreamingHttpClient from(final StreamingHttpRequestResponseFactory reqRespFactory, final HttpExecutionContext executionContext, StreamingHttpClientFilterFactory factory) {
        StreamingHttpClientFilter filterChain = factory.create(new FilterableStreamingHttpClient(){
            private final ListenableAsyncCloseable closeable = AsyncCloseables.emptyAsyncCloseable();

            public Single<? extends FilterableReservedStreamingHttpConnection> reserveConnection(HttpRequestMetaData metaData) {
                return Single.failed((Throwable)new UnsupportedOperationException());
            }

            public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
                return Single.failed((Throwable)new UnsupportedOperationException());
            }

            public HttpExecutionContext executionContext() {
                return executionContext;
            }

            public StreamingHttpResponseFactory httpResponseFactory() {
                return reqRespFactory;
            }

            public Completable closeAsync() {
                return this.closeable.closeAsync();
            }

            public Completable closeAsyncGracefully() {
                return this.closeable.closeAsyncGracefully();
            }

            public Completable onClose() {
                return this.closeable.onClose();
            }

            public Completable onClosing() {
                return this.closeable.onClosing();
            }

            public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
                return reqRespFactory.newRequest(method, requestTarget);
            }
        });
        return TestStreamingHttpClient.from((FilterableStreamingHttpClient)filterChain);
    }

    public static StreamingHttpClient from(final FilterableStreamingHttpClient filterChain) {
        return new StreamingHttpClient(){

            public Single<ReservedStreamingHttpConnection> reserveConnection(HttpRequestMetaData metaData) {
                return filterChain.reserveConnection(metaData).map(rc -> new ReservedStreamingHttpConnection((FilterableReservedStreamingHttpConnection)rc){
                    final /* synthetic */ FilterableReservedStreamingHttpConnection val$rc;
                    {
                        this.val$rc = filterableReservedStreamingHttpConnection;
                    }

                    public ReservedHttpConnection asConnection() {
                        return HttpApiConversions.toReservedConnection((ReservedStreamingHttpConnection)this, (HttpExecutionStrategy)HttpExecutionStrategies.offloadNone());
                    }

                    public ReservedBlockingStreamingHttpConnection asBlockingStreamingConnection() {
                        return HttpApiConversions.toReservedBlockingStreamingConnection((ReservedStreamingHttpConnection)this, (HttpExecutionStrategy)HttpExecutionStrategies.offloadNone());
                    }

                    public ReservedBlockingHttpConnection asBlockingConnection() {
                        return HttpApiConversions.toReservedBlockingConnection((ReservedStreamingHttpConnection)this, (HttpExecutionStrategy)HttpExecutionStrategies.offloadNone());
                    }

                    public Completable releaseAsync() {
                        return this.val$rc.releaseAsync();
                    }

                    public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
                        return this.val$rc.request(request);
                    }

                    public HttpConnectionContext connectionContext() {
                        return this.val$rc.connectionContext();
                    }

                    public <T> Publisher<? extends T> transportEventStream(HttpEventKey<T> settingKey) {
                        return this.val$rc.transportEventStream(settingKey);
                    }

                    public HttpExecutionContext executionContext() {
                        return this.val$rc.executionContext();
                    }

                    public StreamingHttpResponseFactory httpResponseFactory() {
                        return this.val$rc.httpResponseFactory();
                    }

                    public Completable onClose() {
                        return this.val$rc.onClose();
                    }

                    public Completable onClosing() {
                        return this.val$rc.onClosing();
                    }

                    public Completable closeAsync() {
                        return this.val$rc.closeAsync();
                    }

                    public Completable closeAsyncGracefully() {
                        return this.val$rc.closeAsyncGracefully();
                    }

                    public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
                        return this.val$rc.newRequest(method, requestTarget);
                    }
                });
            }

            public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
                return filterChain.newRequest(method, requestTarget);
            }

            public Completable closeAsync() {
                return filterChain.closeAsync();
            }

            public Completable closeAsyncGracefully() {
                return filterChain.closeAsyncGracefully();
            }

            public Completable onClose() {
                return filterChain.onClose();
            }

            public Completable onClosing() {
                return filterChain.onClosing();
            }

            public HttpExecutionContext executionContext() {
                return filterChain.executionContext();
            }

            public StreamingHttpResponseFactory httpResponseFactory() {
                return filterChain.httpResponseFactory();
            }

            public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
                return filterChain.request(request);
            }

            public HttpClient asClient() {
                return HttpApiConversions.toClient((StreamingHttpClient)this, (HttpExecutionStrategy)HttpExecutionStrategies.offloadNone());
            }

            public BlockingStreamingHttpClient asBlockingStreamingClient() {
                return HttpApiConversions.toBlockingStreamingClient((StreamingHttpClient)this, (HttpExecutionStrategy)HttpExecutionStrategies.offloadNone());
            }

            public BlockingHttpClient asBlockingClient() {
                return HttpApiConversions.toBlockingClient((StreamingHttpClient)this, (HttpExecutionStrategy)HttpExecutionStrategies.offloadNone());
            }
        };
    }
}

