/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.Processors;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.PublisherOperator;
import io.servicetalk.concurrent.api.ScanMapper;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.SourceAdapters;
import io.servicetalk.http.api.DefaultPayloadInfo;
import io.servicetalk.http.api.HttpDataSourceTransformations;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpHeadersFactory;
import io.servicetalk.http.api.HttpStreamingDeserializer;
import io.servicetalk.http.api.HttpStreamingSerializer;
import io.servicetalk.http.api.PayloadInfo;
import io.servicetalk.http.api.TrailersTransformer;
import io.servicetalk.http.api.UnsupportedHttpChunkException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

final class StreamingHttpPayloadHolder
implements PayloadInfo {
    private static final Publisher<Buffer> EMPTY = Publisher.empty();
    private final HttpHeaders headers;
    private final BufferAllocator allocator;
    private final DefaultPayloadInfo payloadInfo;
    private final HttpHeadersFactory headersFactory;
    @Nullable
    private Publisher<?> messageBody;

    StreamingHttpPayloadHolder(HttpHeaders headers, BufferAllocator allocator, @Nullable Publisher<?> messageBody, DefaultPayloadInfo messageBodyInfo, HttpHeadersFactory headersFactory) {
        assert (messageBody != null || !messageBodyInfo.mayHaveTrailers());
        this.headers = Objects.requireNonNull(headers);
        this.allocator = Objects.requireNonNull(allocator);
        this.payloadInfo = Objects.requireNonNull(messageBodyInfo);
        this.headersFactory = Objects.requireNonNull(headersFactory);
        this.messageBody = messageBody;
        this.payloadInfo.setEmpty(messageBody == null || messageBody == Publisher.empty());
    }

    Publisher<Buffer> payloadBody() {
        return this.messageBody == null ? Publisher.empty() : (!this.payloadInfo.isGenericTypeBuffer() || this.payloadInfo.mayHaveTrailers() ? this.messageBody.liftSync(HttpDataSourceTransformations.HttpTransportBufferFilterOperator.INSTANCE) : this.messageBody);
    }

    Publisher<Object> messageBody() {
        return this.messageBody == null ? Publisher.empty() : this.messageBody;
    }

    void payloadBody(Publisher<Buffer> payloadBody) {
        this.payloadInfo.setEmpty(payloadBody == EMPTY);
        if (this.messageBody == null) {
            this.messageBody = Objects.requireNonNull(payloadBody);
            this.payloadInfo.setGenericTypeBuffer(true);
        } else if (this.payloadInfo.mayHaveTrailers()) {
            Publisher<?> oldMessageBody = this.messageBody;
            this.messageBody = Publisher.defer(() -> {
                SingleSource.Processor trailersProcessor = Processors.newSingleProcessor();
                return StreamingHttpPayloadHolder.merge(payloadBody.liftSync((PublisherOperator)new HttpDataSourceTransformations.BridgeFlowControlAndDiscardOperator(oldMessageBody.liftSync((PublisherOperator)new PreserveTrailersBufferOperator(trailersProcessor)))), (Single<HttpHeaders>)SourceAdapters.fromSource((SingleSource)trailersProcessor)).shareContextOnSubscribe();
            });
        } else {
            this.messageBody = payloadBody.liftSync((PublisherOperator)new HttpDataSourceTransformations.BridgeFlowControlAndDiscardOperator(this.messageBody));
            this.payloadInfo.setGenericTypeBuffer(true);
        }
    }

    void messageBody(Publisher<?> msgBody) {
        this.payloadInfo.setEmpty(this.messageBody == EMPTY);
        this.messageBody = this.messageBody == null ? Objects.requireNonNull(msgBody) : msgBody.liftSync((PublisherOperator)new HttpDataSourceTransformations.ObjectBridgeFlowControlAndDiscardOperator(this.messageBody));
        this.payloadInfo.setMayHaveTrailersAndGenericTypeBuffer(true);
    }

    <T> void payloadBody(Publisher<T> payloadBody, HttpStreamingSerializer<T> serializer) {
        this.payloadBody(serializer.serialize(this.headers, payloadBody, this.allocator));
        this.payloadInfo.setEmpty(payloadBody == Publisher.empty());
    }

    <T> void transformPayloadBody(Function<Publisher<Buffer>, Publisher<T>> transformer, HttpStreamingSerializer<T> serializer) {
        this.transformPayloadBody(bufPub -> serializer.serialize(this.headers, (Publisher)transformer.apply((Publisher<Buffer>)bufPub), this.allocator));
    }

    void transformPayloadBody(UnaryOperator<Publisher<Buffer>> transformer) {
        if (this.payloadInfo.mayHaveTrailers()) {
            assert (this.messageBody != null);
            this.payloadInfo.setEmpty(false);
            Publisher<?> oldMessageBody = this.messageBody;
            this.messageBody = Publisher.defer(() -> {
                SingleSource.Processor trailersProcessor = Processors.newSingleProcessor();
                Publisher transformedPayloadBody = (Publisher)transformer.apply(oldMessageBody.liftSync((PublisherOperator)new PreserveTrailersBufferOperator(trailersProcessor)));
                this.payloadInfo.setEmpty(transformedPayloadBody == EMPTY);
                return StreamingHttpPayloadHolder.merge(transformedPayloadBody, (Single<HttpHeaders>)SourceAdapters.fromSource((SingleSource)trailersProcessor)).shareContextOnSubscribe();
            });
        } else {
            Publisher transformedPayloadBody = (Publisher)transformer.apply(this.payloadBody());
            this.messageBody = Objects.requireNonNull(transformedPayloadBody);
            this.payloadInfo.setEmpty(transformedPayloadBody == EMPTY).setGenericTypeBuffer(true);
        }
    }

    void transformMessageBody(UnaryOperator<Publisher<?>> transformer) {
        this.messageBody = (Publisher)transformer.apply(this.messageBody());
    }

    <T, S> void transform(TrailersTransformer<T, S> trailersTransformer, HttpStreamingDeserializer<S> serializer) {
        this.transform(trailersTransformer, (Publisher<?> body) -> Publisher.defer(() -> {
            SingleSource.Processor trailersProcessor = Processors.newSingleProcessor();
            Publisher transformedPayloadBody = body.liftSync((PublisherOperator)new PreserveTrailersBufferOperator(trailersProcessor));
            return StreamingHttpPayloadHolder.merge(serializer.deserialize(this.headers, (Publisher<Buffer>)transformedPayloadBody, this.allocator), (Single<HttpHeaders>)SourceAdapters.fromSource((SingleSource)trailersProcessor)).scanWithMapper(() -> new TrailersMapper(trailersTransformer, this.headersFactory)).shareContextOnSubscribe();
        }));
    }

    <T> void transform(TrailersTransformer<T, Buffer> trailersTransformer) {
        this.transform(trailersTransformer, (Publisher<?> body) -> body.scanWithMapper(() -> new TrailersMapper(trailersTransformer, this.headersFactory)));
    }

    private <T, S> void transform(TrailersTransformer<T, S> trailersTransformer, Function<Publisher<?>, Publisher<?>> internalTransformer) {
        if (this.messageBody == null) {
            this.messageBody = Publisher.defer(() -> Publisher.from((Object)trailersTransformer.payloadComplete(trailersTransformer.newState(), this.headersFactory.newEmptyTrailers())).shareContextOnSubscribe());
        } else {
            this.payloadInfo.setEmpty(false);
            this.messageBody = internalTransformer.apply(this.messageBody);
        }
        this.payloadInfo.setMayHaveTrailersAndGenericTypeBuffer(true);
    }

    Single<HttpDataSourceTransformations.PayloadAndTrailers> aggregate() {
        this.payloadInfo.setSafeToAggregate(true);
        return HttpDataSourceTransformations.aggregatePayloadAndTrailers(this.payloadInfo, this.messageBody(), this.allocator);
    }

    @Override
    public boolean isEmpty() {
        return this.payloadInfo.isEmpty();
    }

    @Override
    public boolean isSafeToAggregate() {
        return this.payloadInfo.isSafeToAggregate();
    }

    @Override
    public boolean mayHaveTrailers() {
        return this.payloadInfo.mayHaveTrailers();
    }

    @Override
    public boolean isGenericTypeBuffer() {
        return this.payloadInfo.isGenericTypeBuffer();
    }

    DefaultPayloadInfo payloadInfo() {
        return this.payloadInfo;
    }

    BufferAllocator allocator() {
        return this.allocator;
    }

    HttpHeadersFactory headersFactory() {
        return this.headersFactory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamingHttpPayloadHolder that = (StreamingHttpPayloadHolder)o;
        if (!this.headers.equals(that.headers)) {
            return false;
        }
        if (!this.allocator.equals(that.allocator)) {
            return false;
        }
        if (!this.payloadInfo.equals(that.payloadInfo)) {
            return false;
        }
        if (!this.headersFactory.equals(that.headersFactory)) {
            return false;
        }
        return Objects.equals(this.messageBody, that.messageBody);
    }

    public int hashCode() {
        int result = this.headers.hashCode();
        result = 31 * result + this.allocator.hashCode();
        result = 31 * result + this.payloadInfo.hashCode();
        result = 31 * result + this.headersFactory.hashCode();
        result = 31 * result + Objects.hashCode(this.messageBody);
        return result;
    }

    private static void throwDuplicateTrailersException(HttpHeaders trailers, Object o) {
        throw new IllegalStateException("trailers already set to: " + trailers + " but duplicate trailers seen: " + o);
    }

    private static void throwOnNextAfterTrailersException(HttpHeaders trailers, @Nullable Object o) {
        throw new IllegalStateException("trailers must be the last onNext signal, but got: " + o + " after: " + trailers);
    }

    private static Publisher<?> merge(Publisher<?> p, Single<HttpHeaders> s) {
        return Publisher.from(p, (Object)s.toPublisher().filter(Objects::nonNull)).flatMapMerge(Function.identity(), 2);
    }

    private static final class PreserveTrailersBufferOperator
    implements PublisherOperator<Object, Buffer> {
        private final SingleSource.Processor<HttpHeaders, HttpHeaders> trailersProcessor;

        private PreserveTrailersBufferOperator(SingleSource.Processor<HttpHeaders, HttpHeaders> trailersProcessor) {
            this.trailersProcessor = trailersProcessor;
        }

        public PublisherSource.Subscriber<? super Object> apply(PublisherSource.Subscriber<? super Buffer> subscriber) {
            return new PreserveTrailersBufferSubscriber(subscriber, this.trailersProcessor);
        }

        private static final class PreserveTrailersBufferSubscriber
        implements PublisherSource.Subscriber<Object> {
            private final PublisherSource.Subscriber<? super Buffer> target;
            private final SingleSource.Processor<HttpHeaders, HttpHeaders> trailersProcessor;
            @Nullable
            private HttpHeaders trailers;

            PreserveTrailersBufferSubscriber(PublisherSource.Subscriber<? super Buffer> target, SingleSource.Processor<HttpHeaders, HttpHeaders> trailersProcessor) {
                this.target = target;
                this.trailersProcessor = trailersProcessor;
            }

            public void onSubscribe(PublisherSource.Subscription subscription) {
                this.target.onSubscribe(subscription);
            }

            public void onNext(Object o) {
                if (o instanceof Buffer) {
                    this.target.onNext((Object)((Buffer)o));
                } else if (o instanceof HttpHeaders) {
                    if (this.trailers != null) {
                        StreamingHttpPayloadHolder.throwDuplicateTrailersException(this.trailers, o);
                    }
                    this.trailers = (HttpHeaders)o;
                    this.trailersProcessor.onSuccess((Object)this.trailers);
                } else {
                    throw new UnsupportedHttpChunkException(o);
                }
            }

            public void onError(Throwable t) {
                try {
                    this.trailersProcessor.onError(t);
                }
                finally {
                    this.target.onError(t);
                }
            }

            public void onComplete() {
                try {
                    if (this.trailers == null) {
                        this.trailersProcessor.onSuccess(null);
                    }
                }
                finally {
                    this.target.onComplete();
                }
            }
        }
    }

    private static final class DefaultMappedTerminal<T>
    implements ScanMapper.MappedTerminal<T> {
        private final T onNext;

        private DefaultMappedTerminal(T onNext) {
            this.onNext = onNext;
        }

        @Nullable
        public T onNext() {
            return this.onNext;
        }

        public boolean onNextValid() {
            return true;
        }

        @Nullable
        public Throwable terminal() {
            return null;
        }
    }

    private static final class TrailersMapper<T, S>
    implements ScanMapper<Object, Object> {
        private final TrailersTransformer<T, S> trailersTransformer;
        private final HttpHeadersFactory headersFactory;
        @Nullable
        private final T state;
        @Nullable
        private HttpHeaders trailers;

        private TrailersMapper(TrailersTransformer<T, S> trailersTransformer, HttpHeadersFactory headersFactory) {
            this.trailersTransformer = Objects.requireNonNull(trailersTransformer);
            this.headersFactory = headersFactory;
            this.state = trailersTransformer.newState();
        }

        public Object mapOnNext(@Nullable Object next) {
            if (next instanceof HttpHeaders) {
                if (this.trailers != null) {
                    StreamingHttpPayloadHolder.throwDuplicateTrailersException(this.trailers, next);
                }
                this.trailers = (HttpHeaders)next;
                return this.trailersTransformer.payloadComplete(this.state, this.trailers);
            }
            if (this.trailers != null) {
                StreamingHttpPayloadHolder.throwOnNextAfterTrailersException(this.trailers, next);
            }
            Object nextS = Objects.requireNonNull(next);
            return this.trailersTransformer.accept(this.state, nextS);
        }

        @Nullable
        public ScanMapper.MappedTerminal<Object> mapOnError(Throwable t) throws Throwable {
            return this.trailers == null ? new DefaultMappedTerminal(this.trailersTransformer.catchPayloadFailure(this.state, t, this.headersFactory.newEmptyTrailers())) : null;
        }

        @Nullable
        public ScanMapper.MappedTerminal<Object> mapOnComplete() {
            return this.trailers == null ? new DefaultMappedTerminal(this.trailersTransformer.payloadComplete(this.state, this.headersFactory.newEmptyTrailers())) : null;
        }
    }
}

