/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.http.api.NoopHttpLifecycleObservers;
import io.servicetalk.transport.api.ConnectionInfo;

@FunctionalInterface
public interface HttpLifecycleObserver {
    public HttpExchangeObserver onNewExchange();

    public static interface HttpResponseObserver {
        default public void onResponseDataRequested(long n) {
        }

        default public void onResponseData(Buffer data) {
        }

        default public void onResponseTrailers(HttpHeaders trailers) {
        }

        default public void onResponseComplete() {
        }

        default public void onResponseError(Throwable cause) {
        }

        default public void onResponseCancel() {
        }
    }

    public static interface HttpRequestObserver {
        default public void onRequestDataRequested(long n) {
        }

        default public void onRequestData(Buffer data) {
        }

        default public void onRequestTrailers(HttpHeaders trailers) {
        }

        default public void onRequestComplete() {
        }

        default public void onRequestError(Throwable cause) {
        }

        default public void onRequestCancel() {
        }
    }

    public static interface HttpExchangeObserver {
        default public void onConnectionSelected(ConnectionInfo info) {
        }

        default public HttpRequestObserver onRequest(HttpRequestMetaData requestMetaData) {
            return NoopHttpLifecycleObservers.NOOP_HTTP_REQUEST_OBSERVER;
        }

        default public HttpResponseObserver onResponse(HttpResponseMetaData responseMetaData) {
            return NoopHttpLifecycleObservers.NOOP_HTTP_RESPONSE_OBSERVER;
        }

        default public void onResponseError(Throwable cause) {
        }

        default public void onResponseCancel() {
        }

        default public void onExchangeFinally() {
        }
    }
}

