/*
 * Copyright © 2018, 2021 Apple Inc. and the ServiceTalk project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.servicetalk.http.api;

/**
 * A static factory class for {@link HttpResponseMetaData} objects.
 * <p>
 * This is typically only used by HTTP decoders.
 */
public final class HttpResponseMetaDataFactory {
    private HttpResponseMetaDataFactory() {
        // no instances
    }

    /**
     * Create a new instance.
     *
     * @param status the {@link HttpResponseStatus} of the response.
     * @param version the {@link HttpProtocolVersion} of the response.
     * @param headers the {@link HttpHeaders} to use for the response.
     * @return a new {@link HttpResponseMetaData}.
     */
    public static HttpResponseMetaData newResponseMetaData(HttpProtocolVersion version, HttpResponseStatus status,
                                                           HttpHeaders headers) {
        return new DefaultHttpResponseMetaData(status, version, headers, null);
    }
}
