/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.http.api.DefaultHttpHeadersFactory;
import io.servicetalk.http.api.DefaultStreamingHttpRequest;
import io.servicetalk.http.api.EmptyHttpHeaders;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.RedirectConfig;
import io.servicetalk.http.api.StatelessTrailersTransformer;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.utils.internal.NumberUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nullable;

public final class RedirectConfigBuilder {
    private static final int DEFAULT_MAX_REDIRECTS = 5;
    private static final Set<HttpResponseStatus> DEFAULT_ALLOWED_STATUSES = RedirectConfigBuilder.toSet(HttpResponseStatus.MULTIPLE_CHOICES, HttpResponseStatus.MOVED_PERMANENTLY, HttpResponseStatus.FOUND, HttpResponseStatus.SEE_OTHER, HttpResponseStatus.TEMPORARY_REDIRECT, HttpResponseStatus.PERMANENT_REDIRECT);
    private static final Set<HttpRequestMethod> DEFAULT_ALLOWED_METHODS = RedirectConfigBuilder.toSet(HttpRequestMethod.GET, HttpRequestMethod.HEAD);
    private static final BiFunction<HttpRequestMetaData, HttpResponseMetaData, String> DEFAULT_LOCATION_MAPPER = (__, response) -> {
        CharSequence locationHeader = response.headers().get(HttpHeaderNames.LOCATION);
        return locationHeader == null || locationHeader.length() == 0 ? null : locationHeader.toString();
    };
    private static final RedirectConfig.RedirectPredicate DEFAULT_REDIRECT_PREDICATE = (relative, redirectCnt, previousRequest, redirectResponse) -> true;
    private static final CharSequence[] EMPTY_CHAR_SEQUENCE_ARRAY = new CharSequence[0];
    private static final RedirectConfig.RedirectRequestTransformer DEFAULT_REDIRECT_REQUEST_TRANSFORMER = (relative, previousRequest, redirectResponse, redirectRequest) -> redirectRequest;
    private int maxRedirects = 5;
    private boolean allowNonRelativeRedirects;
    @Nullable
    private HttpResponseStatus[] allowedStatuses;
    @Nullable
    private HttpRequestMethod[] allowedMethods;
    private BiFunction<HttpRequestMetaData, HttpResponseMetaData, String> locationMapper = DEFAULT_LOCATION_MAPPER;
    private RedirectConfig.RedirectPredicate redirectPredicate = DEFAULT_REDIRECT_PREDICATE;
    private boolean changePostToGet;
    private CharSequence[] headersToRedirect = EMPTY_CHAR_SEQUENCE_ARRAY;
    private boolean redirectPayloadBody;
    private CharSequence[] trailersToRedirect = EMPTY_CHAR_SEQUENCE_ARRAY;
    private RedirectConfig.RedirectRequestTransformer redirectRequestTransformer = DEFAULT_REDIRECT_REQUEST_TRANSFORMER;

    public RedirectConfigBuilder maxRedirects(int maxRedirects) {
        this.maxRedirects = NumberUtils.ensureNonNegative((int)maxRedirects, (String)"maxRedirects");
        return this;
    }

    public RedirectConfigBuilder allowedStatuses(HttpResponseStatus ... statuses) {
        for (HttpResponseStatus status : Objects.requireNonNull(statuses)) {
            if (HttpResponseStatus.StatusClass.REDIRECTION_3XX.contains(status)) continue;
            throw new IllegalArgumentException("status: " + status + " belongs to " + (Object)((Object)status.statusClass()) + " (expected: " + (Object)((Object)HttpResponseStatus.StatusClass.REDIRECTION_3XX) + ')');
        }
        this.allowedStatuses = (HttpResponseStatus[])statuses.clone();
        return this;
    }

    public RedirectConfigBuilder allowedMethods(HttpRequestMethod ... methods) {
        this.allowedMethods = (HttpRequestMethod[])Objects.requireNonNull(methods).clone();
        return this;
    }

    public RedirectConfigBuilder allowNonRelativeRedirects(boolean allowNonRelativeRedirects) {
        this.allowNonRelativeRedirects = allowNonRelativeRedirects;
        return this;
    }

    public RedirectConfigBuilder locationMapper(BiFunction<HttpRequestMetaData, HttpResponseMetaData, String> locationMapper) {
        this.locationMapper = Objects.requireNonNull(locationMapper);
        return this;
    }

    public RedirectConfigBuilder redirectPredicate(RedirectConfig.RedirectPredicate predicate) {
        this.redirectPredicate = Objects.requireNonNull(predicate);
        return this;
    }

    public RedirectConfigBuilder changePostToGet(boolean changePostToGet) {
        this.changePostToGet = changePostToGet;
        return this;
    }

    public RedirectConfigBuilder headersToRedirect(CharSequence ... headerNames) {
        this.headersToRedirect = (CharSequence[])Objects.requireNonNull(headerNames).clone();
        return this;
    }

    public RedirectConfigBuilder redirectPayloadBody(boolean redirectPayloadBody) {
        this.redirectPayloadBody = redirectPayloadBody;
        return this;
    }

    public RedirectConfigBuilder trailersToRedirect(CharSequence ... trailerNames) {
        this.trailersToRedirect = (CharSequence[])Objects.requireNonNull(trailerNames).clone();
        return this;
    }

    public RedirectConfigBuilder redirectRequestTransformer(RedirectConfig.RedirectRequestTransformer transformer) {
        this.redirectRequestTransformer = Objects.requireNonNull(transformer);
        return this;
    }

    public RedirectConfig build() {
        return new DefaultRedirectConfig(this.maxRedirects, this.allowedStatuses == null ? DEFAULT_ALLOWED_STATUSES : RedirectConfigBuilder.toSet(this.allowedStatuses), this.allowedMethods == null ? DEFAULT_ALLOWED_METHODS : RedirectConfigBuilder.toSet(this.allowedMethods), this.allowNonRelativeRedirects, this.locationMapper, this.redirectPredicate, new DefaultRedirectRequestTransformer(this.changePostToGet, this.headersToRedirect, this.redirectPayloadBody, this.trailersToRedirect, this.redirectRequestTransformer));
    }

    private static Set<HttpResponseStatus> toSet(HttpResponseStatus ... allowedStatuses) {
        HashSet<HttpResponseStatus> set = new HashSet<HttpResponseStatus>((int)((float)allowedStatuses.length / 0.75f) + 1);
        set.addAll(Arrays.asList(allowedStatuses));
        return Collections.unmodifiableSet(set);
    }

    private static Set<HttpRequestMethod> toSet(HttpRequestMethod ... allowedMethods) {
        HashSet<HttpRequestMethod> set = new HashSet<HttpRequestMethod>((int)((float)allowedMethods.length / 0.75f) + 1);
        set.addAll(Arrays.asList(allowedMethods));
        return Collections.unmodifiableSet(set);
    }

    private static final class DefaultRedirectRequestTransformer
    implements RedirectConfig.RedirectRequestTransformer {
        private static final StatelessTrailersTransformer<Buffer> NOOP_TRAILERS_TRANSFORMER = new StatelessTrailersTransformer();
        private final boolean changePostToGet;
        private final HttpHeaders headersToRedirect;
        private final boolean redirectPayloadBody;
        @Nullable
        private final StatelessTrailersTransformer<Buffer> trailersTransformer;
        private final RedirectConfig.RedirectRequestTransformer userDefinedTransformer;

        DefaultRedirectRequestTransformer(boolean changePostToGet, CharSequence[] headersToRedirect, boolean redirectPayloadBody, CharSequence[] trailersToRedirect, RedirectConfig.RedirectRequestTransformer userDefinedTransformer) {
            this.changePostToGet = changePostToGet;
            this.headersToRedirect = DefaultRedirectRequestTransformer.toHeaders(headersToRedirect);
            this.redirectPayloadBody = redirectPayloadBody;
            this.trailersTransformer = trailersToRedirect.length == 0 ? null : new FilterTrailersTransformer(DefaultRedirectRequestTransformer.toHeaders(trailersToRedirect));
            this.userDefinedTransformer = userDefinedTransformer;
        }

        @Override
        public StreamingHttpRequest apply(boolean relative, StreamingHttpRequest previousRequest, StreamingHttpResponse redirectResponse, StreamingHttpRequest redirectRequest) {
            int statusCode = redirectResponse.status().code();
            if (this.changePostToGet && (statusCode == HttpResponseStatus.MOVED_PERMANENTLY.code() || statusCode == HttpResponseStatus.FOUND.code()) && HttpRequestMethod.POST.name().equals(previousRequest.method().name())) {
                redirectRequest.method(HttpRequestMethod.GET);
            }
            if (relative) {
                DefaultRedirectRequestTransformer.fullCopy(previousRequest, redirectRequest);
            } else {
                this.safeCopy(previousRequest, redirectRequest);
            }
            return this.userDefinedTransformer.apply(relative, previousRequest, redirectResponse, redirectRequest);
        }

        private static void fullCopy(StreamingHttpRequest originalRequest, StreamingHttpRequest redirectRequest) {
            redirectRequest.setHeaders(originalRequest.headers());
            DefaultRedirectRequestTransformer.preserveMessageBody(originalRequest, redirectRequest);
            if (DefaultStreamingHttpRequest.class.equals(redirectRequest.getClass()) && DefaultStreamingHttpRequest.class.equals(originalRequest.getClass())) {
                ((DefaultStreamingHttpRequest)redirectRequest).payloadHolder().payloadInfo().setAll((DefaultStreamingHttpRequest)originalRequest);
            } else {
                redirectRequest.transform(NOOP_TRAILERS_TRANSFORMER);
            }
        }

        private void safeCopy(StreamingHttpRequest request, StreamingHttpRequest redirectRequest) {
            this.copyHeaders(request.headers(), redirectRequest.headers());
            if (this.redirectPayloadBody) {
                if (this.trailersTransformer == null) {
                    redirectRequest.payloadBody(request.payloadBody());
                } else {
                    DefaultRedirectRequestTransformer.preserveMessageBody(request, redirectRequest).transform(this.trailersTransformer);
                }
            } else if (this.trailersTransformer != null) {
                DefaultRedirectRequestTransformer.preserveMessageBody(request, redirectRequest).transformMessageBody(p -> p.filter(item -> item instanceof HttpHeaders)).transform(this.trailersTransformer);
            }
        }

        private static StreamingHttpRequest preserveMessageBody(StreamingHttpRequest originalRequest, StreamingHttpRequest redirectRequest) {
            return redirectRequest.transformMessageBody(p -> {
                if (p == Publisher.empty()) {
                    return originalRequest.messageBody();
                }
                return p.ignoreElements().concat(originalRequest.messageBody());
            });
        }

        private void copyHeaders(HttpHeaders requestHeaders, HttpHeaders redirectHeaders) {
            if (this.headersToRedirect.size() < requestHeaders.size()) {
                for (Map.Entry<CharSequence, CharSequence> toRedirect : this.headersToRedirect) {
                    CharSequence headerName = toRedirect.getKey();
                    for (CharSequence charSequence : requestHeaders.values(headerName)) {
                        redirectHeaders.add(headerName, charSequence);
                    }
                }
            } else {
                for (Map.Entry<CharSequence, CharSequence> hdr : requestHeaders) {
                    if (!this.headersToRedirect.contains(hdr.getKey())) continue;
                    redirectHeaders.add(hdr.getKey(), hdr.getValue());
                }
            }
        }

        private static HttpHeaders toHeaders(CharSequence[] names) {
            if (names.length == 0) {
                return EmptyHttpHeaders.INSTANCE;
            }
            HttpHeaders headers = DefaultHttpHeadersFactory.INSTANCE.newHeaders();
            for (CharSequence name : names) {
                headers.add(name, (CharSequence)"");
            }
            return headers;
        }

        private static final class FilterTrailersTransformer
        extends StatelessTrailersTransformer<Buffer> {
            private final HttpHeaders trailersToRedirect;

            private FilterTrailersTransformer(HttpHeaders trailersToRedirect) {
                this.trailersToRedirect = trailersToRedirect;
            }

            @Override
            protected HttpHeaders payloadComplete(HttpHeaders trailers) {
                return FilterTrailersTransformer.filterTrailers(trailers, this.trailersToRedirect);
            }

            private static HttpHeaders filterTrailers(HttpHeaders trailers, HttpHeaders toRedirect) {
                Iterator<Map.Entry<CharSequence, CharSequence>> it = trailers.iterator();
                while (it.hasNext()) {
                    Map.Entry<CharSequence, CharSequence> entry = it.next();
                    if (toRedirect.contains(entry.getKey())) continue;
                    it.remove();
                }
                return trailers;
            }
        }
    }

    private static final class DefaultRedirectConfig
    implements RedirectConfig {
        private final int maxRedirects;
        private final Set<HttpResponseStatus> allowedStatuses;
        private final Set<HttpRequestMethod> allowedMethods;
        private final boolean allowNonRelativeRedirects;
        private final BiFunction<HttpRequestMetaData, HttpResponseMetaData, String> locationMapper;
        private final RedirectConfig.RedirectPredicate redirectPredicate;
        private final RedirectConfig.RedirectRequestTransformer redirectRequestTransformer;

        private DefaultRedirectConfig(int maxRedirects, Set<HttpResponseStatus> allowedStatuses, Set<HttpRequestMethod> allowedMethods, boolean allowNonRelativeRedirects, BiFunction<HttpRequestMetaData, HttpResponseMetaData, String> locationMapper, RedirectConfig.RedirectPredicate redirectPredicate, RedirectConfig.RedirectRequestTransformer redirectRequestTransformer) {
            this.maxRedirects = maxRedirects;
            this.allowedStatuses = allowedStatuses;
            this.allowedMethods = allowedMethods;
            this.allowNonRelativeRedirects = allowNonRelativeRedirects;
            this.locationMapper = locationMapper;
            this.redirectPredicate = redirectPredicate;
            this.redirectRequestTransformer = redirectRequestTransformer;
        }

        @Override
        public int maxRedirects() {
            return this.maxRedirects;
        }

        @Override
        public Set<HttpResponseStatus> allowedStatuses() {
            return this.allowedStatuses;
        }

        @Override
        public Set<HttpRequestMethod> allowedMethods() {
            return this.allowedMethods;
        }

        @Override
        public boolean allowNonRelativeRedirects() {
            return this.allowNonRelativeRedirects;
        }

        @Override
        public BiFunction<HttpRequestMetaData, HttpResponseMetaData, String> locationMapper() {
            return this.locationMapper;
        }

        @Override
        public RedirectConfig.RedirectPredicate redirectPredicate() {
            return this.redirectPredicate;
        }

        @Override
        public RedirectConfig.RedirectRequestTransformer redirectRequestTransformer() {
            return this.redirectRequestTransformer;
        }
    }
}

