/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.http.api.BlockingHttpClient;
import io.servicetalk.http.api.BlockingHttpConnection;
import io.servicetalk.http.api.BlockingHttpService;
import io.servicetalk.http.api.BlockingStreamingHttpClient;
import io.servicetalk.http.api.BlockingStreamingHttpConnection;
import io.servicetalk.http.api.BlockingStreamingHttpService;
import io.servicetalk.http.api.BlockingStreamingToStreamingService;
import io.servicetalk.http.api.BlockingToStreamingService;
import io.servicetalk.http.api.HttpClient;
import io.servicetalk.http.api.HttpConnection;
import io.servicetalk.http.api.HttpContextKeys;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.HttpMetaData;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpService;
import io.servicetalk.http.api.PayloadInfo;
import io.servicetalk.http.api.ReservedBlockingHttpConnection;
import io.servicetalk.http.api.ReservedBlockingStreamingHttpConnection;
import io.servicetalk.http.api.ReservedHttpConnection;
import io.servicetalk.http.api.ReservedStreamingHttpConnection;
import io.servicetalk.http.api.ServiceToStreamingService;
import io.servicetalk.http.api.StreamingHttpClient;
import io.servicetalk.http.api.StreamingHttpClientToBlockingHttpClient;
import io.servicetalk.http.api.StreamingHttpClientToBlockingStreamingHttpClient;
import io.servicetalk.http.api.StreamingHttpClientToHttpClient;
import io.servicetalk.http.api.StreamingHttpConnection;
import io.servicetalk.http.api.StreamingHttpConnectionToBlockingHttpConnection;
import io.servicetalk.http.api.StreamingHttpConnectionToBlockingStreamingHttpConnection;
import io.servicetalk.http.api.StreamingHttpConnectionToHttpConnection;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceToBlockingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceToBlockingStreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceToHttpService;

public final class HttpApiConversions {
    private HttpApiConversions() {
    }

    @Deprecated
    public static ReservedHttpConnection toReservedConnection(ReservedStreamingHttpConnection original, HttpExecutionStrategyInfluencer influencer) {
        return HttpApiConversions.toReservedConnection(original, influencer.requiredOffloads());
    }

    public static ReservedHttpConnection toReservedConnection(ReservedStreamingHttpConnection original, HttpExecutionStrategy strategy) {
        return new StreamingHttpClientToHttpClient.ReservedStreamingHttpConnectionToReservedHttpConnection(original, strategy);
    }

    @Deprecated
    public static ReservedBlockingHttpConnection toReservedBlockingConnection(ReservedStreamingHttpConnection original, HttpExecutionStrategyInfluencer influencer) {
        return HttpApiConversions.toReservedBlockingConnection(original, influencer.requiredOffloads());
    }

    public static ReservedBlockingHttpConnection toReservedBlockingConnection(ReservedStreamingHttpConnection original, HttpExecutionStrategy strategy) {
        return new StreamingHttpClientToBlockingHttpClient.ReservedStreamingHttpConnectionToReservedBlockingHttpConnection(original, strategy);
    }

    @Deprecated
    public static ReservedBlockingStreamingHttpConnection toReservedBlockingStreamingConnection(ReservedStreamingHttpConnection original, HttpExecutionStrategyInfluencer influencer) {
        return HttpApiConversions.toReservedBlockingStreamingConnection(original, influencer.requiredOffloads());
    }

    public static ReservedBlockingStreamingHttpConnection toReservedBlockingStreamingConnection(ReservedStreamingHttpConnection original, HttpExecutionStrategy strategy) {
        return new StreamingHttpClientToBlockingStreamingHttpClient.ReservedStreamingHttpConnectionToBlockingStreaming(original, strategy);
    }

    @Deprecated
    public static HttpConnection toConnection(StreamingHttpConnection original, HttpExecutionStrategyInfluencer influencer) {
        return HttpApiConversions.toConnection(original, influencer.requiredOffloads());
    }

    public static HttpConnection toConnection(StreamingHttpConnection original, HttpExecutionStrategy strategy) {
        return new StreamingHttpConnectionToHttpConnection(original, strategy);
    }

    @Deprecated
    public static BlockingHttpConnection toBlockingConnection(StreamingHttpConnection original, HttpExecutionStrategyInfluencer influencer) {
        return HttpApiConversions.toBlockingConnection(original, influencer.requiredOffloads());
    }

    public static BlockingHttpConnection toBlockingConnection(StreamingHttpConnection original, HttpExecutionStrategy strategy) {
        return new StreamingHttpConnectionToBlockingHttpConnection(original, strategy);
    }

    @Deprecated
    public static BlockingStreamingHttpConnection toBlockingStreamingConnection(StreamingHttpConnection original, HttpExecutionStrategyInfluencer influencer) {
        return HttpApiConversions.toBlockingStreamingConnection(original, influencer.requiredOffloads());
    }

    public static BlockingStreamingHttpConnection toBlockingStreamingConnection(StreamingHttpConnection original, HttpExecutionStrategy strategy) {
        return new StreamingHttpConnectionToBlockingStreamingHttpConnection(original, strategy);
    }

    @Deprecated
    public static HttpClient toClient(StreamingHttpClient original, HttpExecutionStrategyInfluencer influencer) {
        return HttpApiConversions.toClient(original, influencer.requiredOffloads());
    }

    public static HttpClient toClient(StreamingHttpClient original, HttpExecutionStrategy strategy) {
        return new StreamingHttpClientToHttpClient(original, strategy);
    }

    @Deprecated
    public static BlockingHttpClient toBlockingClient(StreamingHttpClient original, HttpExecutionStrategyInfluencer influencer) {
        return HttpApiConversions.toBlockingClient(original, influencer.requiredOffloads());
    }

    public static BlockingHttpClient toBlockingClient(StreamingHttpClient original, HttpExecutionStrategy strategy) {
        return new StreamingHttpClientToBlockingHttpClient(original, strategy);
    }

    @Deprecated
    public static BlockingStreamingHttpClient toBlockingStreamingClient(StreamingHttpClient original, HttpExecutionStrategyInfluencer influencer) {
        return HttpApiConversions.toBlockingStreamingClient(original, influencer.requiredOffloads());
    }

    public static BlockingStreamingHttpClient toBlockingStreamingClient(StreamingHttpClient original, HttpExecutionStrategy strategy) {
        return new StreamingHttpClientToBlockingStreamingHttpClient(original, strategy);
    }

    @Deprecated
    public static ServiceAdapterHolder toStreamingHttpService(HttpService service, HttpExecutionStrategyInfluencer influencer) {
        return HttpApiConversions.toStreamingHttpService(service, influencer.requiredOffloads());
    }

    @Deprecated
    public static ServiceAdapterHolder toStreamingHttpService(HttpService service, HttpExecutionStrategy strategy) {
        return new ServiceToStreamingService(service, strategy);
    }

    public static StreamingHttpService toStreamingHttpService(HttpExecutionStrategy strategy, HttpService service) {
        return new ServiceToStreamingService(service, strategy);
    }

    @Deprecated
    public static ServiceAdapterHolder toStreamingHttpService(BlockingStreamingHttpService service, HttpExecutionStrategyInfluencer influencer) {
        return HttpApiConversions.toStreamingHttpService(service, influencer.requiredOffloads());
    }

    @Deprecated
    public static ServiceAdapterHolder toStreamingHttpService(BlockingStreamingHttpService service, HttpExecutionStrategy strategy) {
        return new BlockingStreamingToStreamingService(service, strategy);
    }

    public static StreamingHttpService toStreamingHttpService(HttpExecutionStrategy strategy, BlockingStreamingHttpService service) {
        return new BlockingStreamingToStreamingService(service, strategy);
    }

    @Deprecated
    public static ServiceAdapterHolder toStreamingHttpService(BlockingHttpService service, HttpExecutionStrategyInfluencer influencer) {
        return HttpApiConversions.toStreamingHttpService(service, influencer.requiredOffloads());
    }

    @Deprecated
    public static ServiceAdapterHolder toStreamingHttpService(BlockingHttpService service, HttpExecutionStrategy strategy) {
        return new BlockingToStreamingService(service, strategy);
    }

    public static StreamingHttpService toStreamingHttpService(HttpExecutionStrategy strategy, BlockingHttpService service) {
        return new BlockingToStreamingService(service, strategy);
    }

    public static boolean isPayloadEmpty(HttpMetaData metadata) {
        return metadata instanceof PayloadInfo && ((PayloadInfo)((Object)metadata)).isEmpty();
    }

    public static boolean isSafeToAggregate(HttpMetaData metadata) {
        return metadata instanceof PayloadInfo && ((PayloadInfo)((Object)metadata)).isSafeToAggregate();
    }

    public static boolean mayHaveTrailers(HttpMetaData metadata) {
        return metadata instanceof PayloadInfo && ((PayloadInfo)((Object)metadata)).mayHaveTrailers();
    }

    public static BlockingHttpService toBlockingHttpService(StreamingHttpService service) {
        return new StreamingHttpServiceToBlockingHttpService(service);
    }

    public static HttpService toHttpService(StreamingHttpService service) {
        return new StreamingHttpServiceToHttpService(service);
    }

    public static BlockingStreamingHttpService toBlockingStreamingHttpService(StreamingHttpService service) {
        return new StreamingHttpServiceToBlockingStreamingHttpService(service);
    }

    static void assignStrategy(HttpRequestMetaData metaData, HttpExecutionStrategy strategy) {
        metaData.context().putIfAbsent(HttpContextKeys.HTTP_EXECUTION_STRATEGY_KEY, (Object)strategy);
    }

    @Deprecated
    public static interface ServiceAdapterHolder {
        public StreamingHttpService adaptor();

        public HttpExecutionStrategy serviceInvocationStrategy();
    }
}

