/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.ReadOnlyBufferAllocators;
import io.servicetalk.http.api.BufferUtils;
import io.servicetalk.transport.api.ConnectionInfo;

public final class HttpProtocolVersion
implements ConnectionInfo.Protocol,
Comparable<HttpProtocolVersion> {
    public static final HttpProtocolVersion HTTP_1_1 = new HttpProtocolVersion(1, 1);
    public static final HttpProtocolVersion HTTP_1_0 = new HttpProtocolVersion(1, 0);
    public static final HttpProtocolVersion HTTP_2_0 = new HttpProtocolVersion(2, 0);
    private final int major;
    private final int minor;
    private final String httpVersion;
    private final Buffer encodedAsBuffer;
    private final String fullVersion;

    private HttpProtocolVersion(int major, int minor) {
        if (major < 0 || major > 9) {
            throw new IllegalArgumentException("Illegal major version: " + major + ", expected [0-9]");
        }
        this.major = major;
        if (minor < 0 || minor > 9) {
            throw new IllegalArgumentException("Illegal minor version: " + minor + ", expected [0-9]");
        }
        this.minor = minor;
        this.fullVersion = major + "." + minor;
        this.httpVersion = "HTTP/" + this.fullVersion;
        this.encodedAsBuffer = ReadOnlyBufferAllocators.PREFER_HEAP_RO_ALLOCATOR.fromAscii((CharSequence)this.httpVersion);
    }

    public static HttpProtocolVersion of(int major, int minor) {
        if (major == 1) {
            if (minor == 1) {
                return HTTP_1_1;
            }
            if (minor == 0) {
                return HTTP_1_0;
            }
        } else if (major == 2 && minor == 0) {
            return HTTP_2_0;
        }
        return new HttpProtocolVersion(major, minor);
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public void writeTo(Buffer buffer) {
        BufferUtils.writeReadOnlyBuffer(this.encodedAsBuffer, buffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpProtocolVersion)) {
            return false;
        }
        HttpProtocolVersion that = (HttpProtocolVersion)o;
        return this.major == that.major() && this.minor == that.minor();
    }

    public int hashCode() {
        return 31 * this.major + this.minor;
    }

    public String toString() {
        return this.httpVersion;
    }

    public String name() {
        return this.httpVersion;
    }

    public String fullVersion() {
        return this.fullVersion;
    }

    static boolean h1TrailersSupported(HttpProtocolVersion version) {
        return version.major() == 1 && version.minor() > 0;
    }

    @Override
    public int compareTo(HttpProtocolVersion that) {
        int compareMajor = Integer.compare(this.major(), that.major());
        return compareMajor == 0 ? Integer.compare(this.minor(), that.minor()) : compareMajor;
    }
}

