/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.http.api.DefaultHttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.SpecialHttpExecutionStrategy;
import java.util.EnumSet;
import javax.annotation.Nullable;

public final class HttpExecutionStrategies {
    private HttpExecutionStrategies() {
    }

    public static HttpExecutionStrategy defaultStrategy() {
        return SpecialHttpExecutionStrategy.DEFAULT_HTTP_EXECUTION_STRATEGY;
    }

    public static HttpExecutionStrategy offloadNever() {
        return SpecialHttpExecutionStrategy.OFFLOAD_NEVER_STRATEGY;
    }

    public static HttpExecutionStrategy offloadNone() {
        return DefaultHttpExecutionStrategy.OFFLOAD_NONE_STRATEGY;
    }

    public static HttpExecutionStrategy offloadAll() {
        return DefaultHttpExecutionStrategy.OFFLOAD_ALL_STRATEGY;
    }

    public static Builder customStrategyBuilder() {
        return new Builder();
    }

    @Nullable
    public static HttpExecutionStrategy difference(HttpExecutionStrategy left, HttpExecutionStrategy right) {
        if (left.equals(right) || !right.hasOffloads()) {
            return null;
        }
        if (!left.hasOffloads()) {
            return right;
        }
        byte effectiveOffloads = 0;
        if (right.isSendOffloaded() && !left.isSendOffloaded()) {
            effectiveOffloads = (byte)(effectiveOffloads | HttpOffload.OFFLOAD_SEND.mask());
        }
        if (right.isMetadataReceiveOffloaded() && !left.isMetadataReceiveOffloaded()) {
            effectiveOffloads = (byte)(effectiveOffloads | HttpOffload.OFFLOAD_RECEIVE_META.mask());
        }
        if (right.isDataReceiveOffloaded() && !left.isDataReceiveOffloaded()) {
            effectiveOffloads = (byte)(effectiveOffloads | HttpOffload.OFFLOAD_RECEIVE_DATA.mask());
        }
        if (right.isEventOffloaded() && !left.isEventOffloaded()) {
            effectiveOffloads = (byte)(effectiveOffloads | HttpOffload.OFFLOAD_EVENT.mask());
        }
        if (right.isCloseOffloaded() && !left.isCloseOffloaded()) {
            effectiveOffloads = (byte)(effectiveOffloads | HttpOffload.OFFLOAD_CLOSE.mask());
        }
        if (0 == effectiveOffloads) {
            return null;
        }
        return DefaultHttpExecutionStrategy.fromMask(effectiveOffloads);
    }

    static enum HttpOffload {
        OFFLOAD_RECEIVE_META,
        OFFLOAD_RECEIVE_DATA,
        OFFLOAD_SEND,
        OFFLOAD_EVENT,
        OFFLOAD_CLOSE;


        byte mask() {
            return (byte)(1 << this.ordinal());
        }

        static byte toMask(EnumSet<HttpOffload> offloads) {
            return (byte)offloads.stream().mapToInt(HttpOffload::mask).reduce(0, Integer::sum);
        }
    }

    public static final class Builder {
        private byte offloads;

        private Builder() {
        }

        public Builder offloadReceiveMetadata() {
            return this.offload(HttpOffload.OFFLOAD_RECEIVE_META);
        }

        public Builder offloadReceiveData() {
            return this.offload(HttpOffload.OFFLOAD_RECEIVE_DATA);
        }

        public Builder offloadSend() {
            return this.offload(HttpOffload.OFFLOAD_SEND);
        }

        public Builder offloadEvent() {
            return this.offload(HttpOffload.OFFLOAD_EVENT);
        }

        public Builder offloadClose() {
            return this.offload(HttpOffload.OFFLOAD_CLOSE);
        }

        public Builder offloadAll() {
            return this.offloadReceiveMetadata().offloadReceiveData().offloadSend().offloadEvent().offloadClose();
        }

        private Builder offload(HttpOffload offload) {
            this.offloads = (byte)(this.offloads | offload.mask());
            return this;
        }

        public Builder offloadNone() {
            this.offloads = 0;
            return this;
        }

        public HttpExecutionStrategy build() {
            return DefaultHttpExecutionStrategy.fromMask(this.offloads);
        }
    }
}

