/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.transport.api.ConnectExecutionStrategy;
import io.servicetalk.transport.api.ExecutionStrategy;
import java.util.Objects;

public final class ConnectAndHttpExecutionStrategy
implements ConnectExecutionStrategy,
HttpExecutionStrategy {
    final ConnectExecutionStrategy connectStrategy;
    final HttpExecutionStrategy httpStrategy;

    public ConnectAndHttpExecutionStrategy(ConnectExecutionStrategy connectStrategy) {
        this(connectStrategy, HttpExecutionStrategies.offloadNone());
    }

    public ConnectAndHttpExecutionStrategy(HttpExecutionStrategy httpStrategy) {
        this(ConnectExecutionStrategy.offloadNone(), httpStrategy);
    }

    public ConnectAndHttpExecutionStrategy(ConnectExecutionStrategy connect, HttpExecutionStrategy http) {
        this.connectStrategy = connect;
        this.httpStrategy = http;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectAndHttpExecutionStrategy that = (ConnectAndHttpExecutionStrategy)o;
        return this.connectStrategy.equals(that.connectStrategy) && this.httpStrategy.equals(that.httpStrategy);
    }

    public int hashCode() {
        return Objects.hash(this.connectStrategy, this.httpStrategy);
    }

    public String toString() {
        return this.connectStrategy + " " + this.httpStrategy;
    }

    @Override
    public boolean hasOffloads() {
        return this.connectStrategy.hasOffloads() || this.httpStrategy.hasOffloads();
    }

    public boolean isCloseOffloaded() {
        return this.httpStrategy.isCloseOffloaded() || this.connectStrategy.isCloseOffloaded();
    }

    @Override
    public boolean isMetadataReceiveOffloaded() {
        return this.httpStrategy.isMetadataReceiveOffloaded();
    }

    @Override
    public boolean isDataReceiveOffloaded() {
        return this.httpStrategy.isDataReceiveOffloaded();
    }

    @Override
    public boolean isSendOffloaded() {
        return this.httpStrategy.isSendOffloaded();
    }

    @Override
    public boolean isEventOffloaded() {
        return this.httpStrategy.isEventOffloaded();
    }

    public boolean isConnectOffloaded() {
        return this.connectStrategy.isConnectOffloaded();
    }

    public ConnectAndHttpExecutionStrategy merge(ExecutionStrategy other) {
        if (other instanceof ConnectAndHttpExecutionStrategy) {
            return this.merge((ConnectAndHttpExecutionStrategy)other);
        }
        if (other instanceof HttpExecutionStrategy) {
            return this.merge((HttpExecutionStrategy)other);
        }
        if (other instanceof ConnectExecutionStrategy) {
            return this.merge((ConnectExecutionStrategy)other);
        }
        return other.hasOffloads() ? new ConnectAndHttpExecutionStrategy(ConnectExecutionStrategy.offloadAll(), HttpExecutionStrategies.offloadAll()) : this;
    }

    private ConnectAndHttpExecutionStrategy merge(ConnectExecutionStrategy other) {
        ConnectExecutionStrategy merged = this.connectStrategy.merge((ExecutionStrategy)other);
        return merged == this.connectStrategy ? this : new ConnectAndHttpExecutionStrategy(merged, this.httpStrategy);
    }

    @Override
    public ConnectAndHttpExecutionStrategy merge(HttpExecutionStrategy other) {
        HttpExecutionStrategy merged = this.httpStrategy.merge(other);
        return merged == this.httpStrategy ? this : new ConnectAndHttpExecutionStrategy(this.connectStrategy, merged);
    }

    private ConnectAndHttpExecutionStrategy merge(ConnectAndHttpExecutionStrategy other) {
        ConnectExecutionStrategy mergedConnect = this.connectStrategy.merge((ExecutionStrategy)other);
        HttpExecutionStrategy mergedHttp = this.httpStrategy.merge(other);
        return mergedConnect == this.connectStrategy && mergedHttp == this.httpStrategy ? this : new ConnectAndHttpExecutionStrategy(mergedConnect, mergedHttp);
    }

    public HttpExecutionStrategy httpStrategy() {
        return this.httpStrategy;
    }

    public ConnectExecutionStrategy connectStrategy() {
        return this.connectStrategy;
    }

    public static ConnectAndHttpExecutionStrategy from(ExecutionStrategy executionStrategy) {
        return executionStrategy instanceof ConnectAndHttpExecutionStrategy ? (ConnectAndHttpExecutionStrategy)executionStrategy : new ConnectAndHttpExecutionStrategy(ConnectExecutionStrategy.offloadNone(), HttpExecutionStrategies.defaultStrategy()).merge(executionStrategy);
    }
}

