/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.http.api.DefaultHttpHeadersFactory;
import io.servicetalk.http.api.EmptyHttpHeaders;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.RedirectConfig;
import io.servicetalk.http.api.StatelessTrailersTransformer;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public final class RedirectConfigBuilder {
    private static final int DEFAULT_MAX_REDIRECTS = 5;
    private static final Set<HttpRequestMethod> DEFAULT_ALLOWED_METHODS = RedirectConfigBuilder.toSet(HttpRequestMethod.GET, HttpRequestMethod.HEAD);
    private static final RedirectConfig.RedirectPredicate DEFAULT_REDIRECT_PREDICATE = (relative, redirectCnt, previousRequest, redirectResponse) -> true;
    private static final CharSequence[] EMPTY_CHAR_SEQUENCE_ARRAY = new CharSequence[0];
    private static final RedirectConfig.RedirectRequestTransformer DEFAULT_REDIRECT_REQUEST_TRANSFORMER = (relative, previousRequest, redirectResponse, redirectRequest) -> redirectRequest;
    private int maxRedirects = 5;
    private boolean allowNonRelativeRedirects;
    @Nullable
    private HttpRequestMethod[] allowedMethods;
    private RedirectConfig.RedirectPredicate redirectPredicate = DEFAULT_REDIRECT_PREDICATE;
    private boolean changePostToGet;
    private CharSequence[] headersToRedirect = EMPTY_CHAR_SEQUENCE_ARRAY;
    private boolean redirectPayloadBody;
    private CharSequence[] trailersToRedirect = EMPTY_CHAR_SEQUENCE_ARRAY;
    private RedirectConfig.RedirectRequestTransformer redirectRequestTransformer = DEFAULT_REDIRECT_REQUEST_TRANSFORMER;

    public RedirectConfigBuilder maxRedirects(int maxRedirects) {
        if (maxRedirects < 0) {
            throw new IllegalArgumentException("maxRedirects: " + maxRedirects + " (expected >= 0)");
        }
        this.maxRedirects = maxRedirects;
        return this;
    }

    public RedirectConfigBuilder allowedMethods(HttpRequestMethod ... methods) {
        this.allowedMethods = Objects.requireNonNull(methods);
        return this;
    }

    public RedirectConfigBuilder allowNonRelativeRedirects(boolean allowNonRelativeRedirects) {
        this.allowNonRelativeRedirects = allowNonRelativeRedirects;
        return this;
    }

    public RedirectConfigBuilder redirectPredicate(RedirectConfig.RedirectPredicate predicate) {
        this.redirectPredicate = Objects.requireNonNull(predicate);
        return this;
    }

    public RedirectConfigBuilder changePostToGet(boolean changePostToGet) {
        this.changePostToGet = changePostToGet;
        return this;
    }

    public RedirectConfigBuilder headersToRedirect(CharSequence ... headerNames) {
        this.headersToRedirect = Objects.requireNonNull(headerNames);
        return this;
    }

    public RedirectConfigBuilder redirectPayloadBody(boolean redirectPayloadBody) {
        this.redirectPayloadBody = redirectPayloadBody;
        return this;
    }

    public RedirectConfigBuilder trailersToRedirect(CharSequence ... trailerNames) {
        this.trailersToRedirect = Objects.requireNonNull(trailerNames);
        return this;
    }

    public RedirectConfigBuilder redirectRequestTransformer(RedirectConfig.RedirectRequestTransformer transformer) {
        this.redirectRequestTransformer = Objects.requireNonNull(transformer);
        return this;
    }

    public RedirectConfig build() {
        return new DefaultRedirectConfig(this.maxRedirects, this.allowedMethods == null ? DEFAULT_ALLOWED_METHODS : RedirectConfigBuilder.toSet(this.allowedMethods), this.allowNonRelativeRedirects, this.redirectPredicate, new DefaultRedirectRequestTransformer(this.changePostToGet, this.headersToRedirect, this.redirectPayloadBody, this.trailersToRedirect, this.redirectRequestTransformer));
    }

    private static Set<HttpRequestMethod> toSet(HttpRequestMethod ... allowedMethods) {
        HashSet<HttpRequestMethod> set = new HashSet<HttpRequestMethod>((int)((float)allowedMethods.length / 0.75f) + 1);
        set.addAll(Arrays.asList(allowedMethods));
        return Collections.unmodifiableSet(set);
    }

    private static final class DefaultRedirectRequestTransformer
    implements RedirectConfig.RedirectRequestTransformer {
        private static final StatelessTrailersTransformer<Buffer> NOOP_TRAILERS_TRANSFORMER = new StatelessTrailersTransformer();
        private final boolean changePostToGet;
        private final HttpHeaders headersToRedirect;
        private final boolean redirectPayloadBody;
        @Nullable
        private final StatelessTrailersTransformer<Buffer> trailersTransformer;
        private final RedirectConfig.RedirectRequestTransformer userDefinedTransformer;

        DefaultRedirectRequestTransformer(boolean changePostToGet, CharSequence[] headersToRedirect, boolean redirectPayloadBody, CharSequence[] trailersToRedirect, RedirectConfig.RedirectRequestTransformer userDefinedTransformer) {
            this.changePostToGet = changePostToGet;
            this.headersToRedirect = DefaultRedirectRequestTransformer.toHeaders(headersToRedirect);
            this.redirectPayloadBody = redirectPayloadBody;
            this.trailersTransformer = trailersToRedirect.length == 0 ? null : new FilterTrailersTransformer(DefaultRedirectRequestTransformer.toHeaders(trailersToRedirect));
            this.userDefinedTransformer = userDefinedTransformer;
        }

        @Override
        public StreamingHttpRequest apply(boolean relative, StreamingHttpRequest previousRequest, StreamingHttpResponse redirectResponse, StreamingHttpRequest redirectRequest) {
            int statusCode = redirectResponse.status().code();
            if (this.changePostToGet && (statusCode == HttpResponseStatus.MOVED_PERMANENTLY.code() || statusCode == HttpResponseStatus.FOUND.code()) && HttpRequestMethod.POST.name().equals(previousRequest.method().name())) {
                redirectRequest.method(HttpRequestMethod.GET);
            }
            if (relative) {
                DefaultRedirectRequestTransformer.fullCopy(previousRequest, redirectRequest);
            } else {
                this.safeCopy(previousRequest, redirectRequest);
            }
            return this.userDefinedTransformer.apply(relative, previousRequest, redirectResponse, redirectRequest);
        }

        private static void fullCopy(StreamingHttpRequest originalRequest, StreamingHttpRequest redirectRequest) {
            redirectRequest.setHeaders(originalRequest.headers());
            redirectRequest.transformMessageBody(p -> p.ignoreElements().concat(originalRequest.messageBody()));
            redirectRequest.transform(NOOP_TRAILERS_TRANSFORMER);
        }

        private void safeCopy(StreamingHttpRequest request, StreamingHttpRequest redirectRequest) {
            this.copyHeaders(request.headers(), redirectRequest.headers());
            if (this.redirectPayloadBody) {
                if (this.trailersTransformer == null) {
                    redirectRequest.payloadBody(request.payloadBody());
                } else {
                    redirectRequest.transformMessageBody(p -> p.ignoreElements().concat(request.messageBody())).transform(this.trailersTransformer);
                }
            } else if (this.trailersTransformer != null) {
                redirectRequest.transformMessageBody(p -> p.ignoreElements().concat(request.messageBody().filter(item -> item instanceof HttpHeaders))).transform(this.trailersTransformer);
            }
        }

        private void copyHeaders(HttpHeaders requestHeaders, HttpHeaders redirectHeaders) {
            if (this.headersToRedirect.size() < requestHeaders.size()) {
                for (Map.Entry<CharSequence, CharSequence> toRedirect : this.headersToRedirect) {
                    CharSequence headerName = toRedirect.getKey();
                    for (CharSequence charSequence : requestHeaders.values(headerName)) {
                        redirectHeaders.add(headerName, charSequence);
                    }
                }
            } else {
                for (Map.Entry<CharSequence, CharSequence> hdr : requestHeaders) {
                    if (!this.headersToRedirect.contains(hdr.getKey())) continue;
                    redirectHeaders.add(hdr.getKey(), hdr.getValue());
                }
            }
        }

        private static HttpHeaders toHeaders(CharSequence[] names) {
            if (names.length == 0) {
                return EmptyHttpHeaders.INSTANCE;
            }
            HttpHeaders headers = DefaultHttpHeadersFactory.INSTANCE.newHeaders();
            for (CharSequence name : names) {
                headers.add(name, (CharSequence)"");
            }
            return headers;
        }

        private static final class FilterTrailersTransformer
        extends StatelessTrailersTransformer<Buffer> {
            private final HttpHeaders trailersToRedirect;

            private FilterTrailersTransformer(HttpHeaders trailersToRedirect) {
                this.trailersToRedirect = trailersToRedirect;
            }

            @Override
            protected HttpHeaders payloadComplete(HttpHeaders trailers) {
                return FilterTrailersTransformer.filterTrailers(trailers, this.trailersToRedirect);
            }

            private static HttpHeaders filterTrailers(HttpHeaders trailers, HttpHeaders toRedirect) {
                Iterator<Map.Entry<CharSequence, CharSequence>> it = trailers.iterator();
                while (it.hasNext()) {
                    Map.Entry<CharSequence, CharSequence> entry = it.next();
                    if (toRedirect.contains(entry.getKey())) continue;
                    it.remove();
                }
                return trailers;
            }
        }
    }

    private static final class DefaultRedirectConfig
    implements RedirectConfig {
        private final int maxRedirects;
        private final Set<HttpRequestMethod> allowedMethods;
        private final boolean allowNonRelativeRedirects;
        private final RedirectConfig.RedirectPredicate redirectPredicate;
        private final RedirectConfig.RedirectRequestTransformer redirectRequestTransformer;

        private DefaultRedirectConfig(int maxRedirects, Set<HttpRequestMethod> allowedMethods, boolean allowNonRelativeRedirects, RedirectConfig.RedirectPredicate redirectPredicate, RedirectConfig.RedirectRequestTransformer redirectRequestTransformer) {
            this.maxRedirects = maxRedirects;
            this.allowedMethods = allowedMethods;
            this.allowNonRelativeRedirects = allowNonRelativeRedirects;
            this.redirectPredicate = redirectPredicate;
            this.redirectRequestTransformer = redirectRequestTransformer;
        }

        @Override
        public int maxRedirects() {
            return this.maxRedirects;
        }

        @Override
        public Set<HttpRequestMethod> allowedMethods() {
            return this.allowedMethods;
        }

        @Override
        public boolean allowNonRelativeRedirects() {
            return this.allowNonRelativeRedirects;
        }

        @Override
        public RedirectConfig.RedirectPredicate redirectPredicate() {
            return this.redirectPredicate;
        }

        @Override
        public RedirectConfig.RedirectRequestTransformer redirectRequestTransformer() {
            return this.redirectRequestTransformer;
        }
    }
}

