/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.netty.BufferAllocators;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.AbstractHttpRequesterFilterTest;
import io.servicetalk.http.api.DefaultHttpHeadersFactory;
import io.servicetalk.http.api.DefaultStreamingHttpRequestResponseFactory;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpServiceContext;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequestResponseFactory;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.api.StreamingHttpServiceFilter;
import io.servicetalk.http.api.StreamingHttpServiceFilterFactory;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLSession;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public abstract class AbstractHttpServiceFilterTest {
    private static final StreamingHttpRequestResponseFactory REQ_RES_FACTORY = new DefaultStreamingHttpRequestResponseFactory(BufferAllocators.DEFAULT_ALLOCATOR, DefaultHttpHeadersFactory.INSTANCE, HttpProtocolVersion.HTTP_1_1);
    @Mock
    private HttpExecutionContext executionContext;
    @Mock
    private HttpServiceContext mockConnectionContext;

    @BeforeEach
    void setUp() {
        Mockito.lenient().when((Object)this.mockConnectionContext.executionContext()).thenReturn((Object)this.executionContext);
        Mockito.lenient().when((Object)this.mockConnectionContext.remoteAddress()).thenAnswer(__ -> this.remoteAddress());
        Mockito.lenient().when((Object)this.mockConnectionContext.localAddress()).thenAnswer(__ -> this.localAddress());
    }

    protected void setUp(SecurityType security) {
        Mockito.lenient().when((Object)this.mockConnectionContext.sslSession()).thenAnswer(__ -> {
            switch (security) {
                case Secure: {
                    return this.sslSession();
                }
            }
            return null;
        });
    }

    protected InetSocketAddress remoteAddress() {
        return InetSocketAddress.createUnresolved("127.0.1.2", 28080);
    }

    protected InetSocketAddress localAddress() {
        return InetSocketAddress.createUnresolved("127.0.1.1", 80);
    }

    protected SSLSession sslSession() {
        return (SSLSession)Mockito.mock(SSLSession.class);
    }

    protected final StreamingHttpRequester createFilter(AbstractHttpRequesterFilterTest.RequestHandler handler, StreamingHttpServiceFilterFactory factory) {
        final StreamingHttpServiceFilter service = factory.create((ctx, request, responseFactory) -> handler.request(responseFactory, request));
        return new StreamingHttpRequester(){

            public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
                return service.handle(AbstractHttpServiceFilterTest.this.mockConnectionContext, request, (StreamingHttpResponseFactory)REQ_RES_FACTORY);
            }

            public HttpExecutionContext executionContext() {
                return AbstractHttpServiceFilterTest.this.executionContext;
            }

            public StreamingHttpResponseFactory httpResponseFactory() {
                return REQ_RES_FACTORY;
            }

            public Completable onClose() {
                return Completable.completed();
            }

            public Completable closeAsync() {
                return Completable.completed();
            }

            public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
                return REQ_RES_FACTORY.newRequest(method, requestTarget);
            }
        };
    }

    public static enum SecurityType {
        Secure,
        Insecure;

    }
}

