/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.FilterableReservedStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.ReservedStreamingHttpConnectionFilter;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import java.util.Objects;

public class StreamingHttpClientFilter
implements FilterableStreamingHttpClient {
    private final FilterableStreamingHttpClient delegate;

    protected StreamingHttpClientFilter(FilterableStreamingHttpClient delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public final Single<StreamingHttpResponse> request(HttpExecutionStrategy strategy, StreamingHttpRequest request) {
        return this.request(this.delegate, strategy, request);
    }

    @Override
    public Single<? extends FilterableReservedStreamingHttpConnection> reserveConnection(HttpExecutionStrategy strategy, HttpRequestMetaData metaData) {
        return this.delegate.reserveConnection(strategy, metaData).map(x$0 -> new ClientFilterToReservedConnectionFilter((FilterableReservedStreamingHttpConnection)x$0));
    }

    @Override
    public HttpExecutionContext executionContext() {
        return this.delegate.executionContext();
    }

    @Override
    public StreamingHttpResponseFactory httpResponseFactory() {
        return this.delegate.httpResponseFactory();
    }

    public Completable onClose() {
        return this.delegate.onClose();
    }

    public Completable closeAsync() {
        return this.delegate.closeAsync();
    }

    public Completable closeAsyncGracefully() {
        return this.delegate.closeAsyncGracefully();
    }

    @Override
    public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
        return this.delegate.newRequest(method, requestTarget);
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.delegate + ')';
    }

    protected final FilterableStreamingHttpClient delegate() {
        return this.delegate;
    }

    protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, HttpExecutionStrategy strategy, StreamingHttpRequest request) {
        return delegate.request(strategy, request);
    }

    private final class ClientFilterToReservedConnectionFilter
    extends ReservedStreamingHttpConnectionFilter {
        ClientFilterToReservedConnectionFilter(FilterableReservedStreamingHttpConnection delegate) {
            super(delegate);
        }

        @Override
        protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, HttpExecutionStrategy strategy, StreamingHttpRequest request) {
            return StreamingHttpClientFilter.this.request(delegate, strategy, request);
        }
    }
}

