/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.CloseableIterable;
import io.servicetalk.concurrent.CloseableIterator;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.internal.CloseableIteratorBufferAsInputStream;
import io.servicetalk.http.api.HttpCookiePair;
import io.servicetalk.http.api.HttpDeserializer;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpResponse;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.HttpSerializer;
import io.servicetalk.http.api.HttpSetCookie;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.TrailersTransformer;
import java.io.InputStream;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public interface BlockingStreamingHttpResponse
extends HttpResponseMetaData {
    public BlockingIterable<Buffer> payloadBody();

    default public InputStream payloadBodyInputStream() {
        return new CloseableIteratorBufferAsInputStream((CloseableIterator)this.payloadBody().iterator());
    }

    default public <T> BlockingIterable<T> payloadBody(HttpDeserializer<T> deserializer) {
        return deserializer.deserialize(this.headers(), this.payloadBody());
    }

    public BlockingStreamingHttpResponse payloadBody(Iterable<Buffer> var1);

    @Deprecated
    default public BlockingStreamingHttpResponse payloadBody(CloseableIterable<Buffer> payloadBody) {
        this.payloadBody((Iterable<Buffer>)payloadBody);
        return this;
    }

    public BlockingStreamingHttpResponse payloadBody(InputStream var1);

    public <T> BlockingStreamingHttpResponse payloadBody(Iterable<T> var1, HttpSerializer<T> var2);

    @Deprecated
    default public <T> BlockingStreamingHttpResponse payloadBody(CloseableIterable<T> payloadBody, HttpSerializer<T> serializer) {
        this.payloadBody((Iterable<T>)payloadBody, serializer);
        return this;
    }

    public <T> BlockingStreamingHttpResponse transformPayloadBody(Function<BlockingIterable<Buffer>, BlockingIterable<T>> var1, HttpSerializer<T> var2);

    default public <T, R> BlockingStreamingHttpResponse transformPayloadBody(Function<BlockingIterable<T>, BlockingIterable<R>> transformer, HttpDeserializer<T> deserializer, HttpSerializer<R> serializer) {
        return this.transformPayloadBody(buffers -> (BlockingIterable)transformer.apply(this.payloadBody(deserializer)), serializer);
    }

    public BlockingStreamingHttpResponse transformPayloadBody(UnaryOperator<BlockingIterable<Buffer>> var1);

    public <T> BlockingStreamingHttpResponse transform(TrailersTransformer<T, Buffer> var1);

    public Single<HttpResponse> toResponse();

    public StreamingHttpResponse toStreamingResponse();

    @Override
    public BlockingStreamingHttpResponse version(HttpProtocolVersion var1);

    @Override
    public BlockingStreamingHttpResponse status(HttpResponseStatus var1);

    @Override
    default public BlockingStreamingHttpResponse addHeader(CharSequence name, CharSequence value) {
        HttpResponseMetaData.super.addHeader(name, value);
        return this;
    }

    @Override
    default public BlockingStreamingHttpResponse addHeaders(HttpHeaders headers) {
        HttpResponseMetaData.super.addHeaders(headers);
        return this;
    }

    @Override
    default public BlockingStreamingHttpResponse setHeader(CharSequence name, CharSequence value) {
        HttpResponseMetaData.super.setHeader(name, value);
        return this;
    }

    @Override
    default public BlockingStreamingHttpResponse setHeaders(HttpHeaders headers) {
        HttpResponseMetaData.super.setHeaders(headers);
        return this;
    }

    @Override
    default public BlockingStreamingHttpResponse addCookie(HttpCookiePair cookie) {
        HttpResponseMetaData.super.addCookie(cookie);
        return this;
    }

    @Override
    default public BlockingStreamingHttpResponse addCookie(CharSequence name, CharSequence value) {
        HttpResponseMetaData.super.addCookie(name, value);
        return this;
    }

    @Override
    default public BlockingStreamingHttpResponse addSetCookie(HttpSetCookie cookie) {
        HttpResponseMetaData.super.addSetCookie(cookie);
        return this;
    }

    @Override
    default public BlockingStreamingHttpResponse addSetCookie(CharSequence name, CharSequence value) {
        HttpResponseMetaData.super.addSetCookie(name, value);
        return this;
    }
}

