/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.api.AsyncContext;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.AsyncContextAwareHttpServiceFilter;
import io.servicetalk.http.api.BlockingHttpService;
import io.servicetalk.http.api.BlockingStreamingHttpService;
import io.servicetalk.http.api.BlockingUtils;
import io.servicetalk.http.api.HttpApiConversions;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.HttpProtocolConfig;
import io.servicetalk.http.api.HttpServerSecurityConfigurator;
import io.servicetalk.http.api.HttpService;
import io.servicetalk.http.api.StrategyInfluencerAwareConversions;
import io.servicetalk.http.api.StrategyInfluencerChainBuilder;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceFilterFactory;
import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.transport.api.ConnectionAcceptor;
import io.servicetalk.transport.api.ConnectionAcceptorFactory;
import io.servicetalk.transport.api.IoExecutor;
import io.servicetalk.transport.api.ServerContext;
import io.servicetalk.transport.api.ServerSslConfig;
import io.servicetalk.transport.api.ServiceTalkSocketOptions;
import io.servicetalk.transport.api.TransportObserver;
import java.net.SocketOption;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public abstract class HttpServerBuilder {
    @Nullable
    private ConnectionAcceptorFactory connectionAcceptorFactory;
    @Nullable
    private StreamingHttpServiceFilterFactory serviceFilter;
    private HttpExecutionStrategy strategy = HttpExecutionStrategies.defaultStrategy();
    private final StrategyInfluencerChainBuilder influencerChainBuilder = new StrategyInfluencerChainBuilder();
    private boolean drainRequestPayloadBody = true;

    public abstract HttpServerBuilder protocols(HttpProtocolConfig ... var1);

    @Deprecated
    public HttpServerBuilder backlog(int backlog) {
        this.listenSocketOption(ServiceTalkSocketOptions.SO_BACKLOG, backlog);
        return this;
    }

    @Deprecated
    public abstract HttpServerSecurityConfigurator secure();

    public abstract HttpServerBuilder sslConfig(ServerSslConfig var1);

    public abstract HttpServerBuilder sslConfig(ServerSslConfig var1, Map<String, ServerSslConfig> var2);

    public abstract <T> HttpServerBuilder socketOption(SocketOption<T> var1, T var2);

    public abstract <T> HttpServerBuilder listenSocketOption(SocketOption<T> var1, T var2);

    @Deprecated
    public abstract HttpServerBuilder enableWireLogging(String var1);

    public abstract HttpServerBuilder enableWireLogging(String var1, LogLevel var2, BooleanSupplier var3);

    public abstract HttpServerBuilder transportObserver(TransportObserver var1);

    public final HttpServerBuilder disableDrainingRequestPayloadBody() {
        this.drainRequestPayloadBody = false;
        return this;
    }

    public abstract HttpServerBuilder allowDropRequestTrailers(boolean var1);

    public final HttpServerBuilder appendConnectionAcceptorFilter(ConnectionAcceptorFactory factory) {
        this.connectionAcceptorFactory = this.connectionAcceptorFactory == null ? factory : this.connectionAcceptorFactory.append(factory);
        return this;
    }

    public final HttpServerBuilder appendServiceFilter(StreamingHttpServiceFilterFactory factory) {
        Objects.requireNonNull(factory);
        this.serviceFilter = HttpServerBuilder.appendFilter(this.serviceFilter, factory);
        if (!this.influencerChainBuilder.appendIfInfluencer(factory)) {
            this.influencerChainBuilder.append(HttpExecutionStrategyInfluencer.defaultStreamingInfluencer());
        }
        return this;
    }

    public final HttpServerBuilder appendServiceFilter(Predicate<StreamingHttpRequest> predicate, StreamingHttpServiceFilterFactory factory) {
        this.appendServiceFilter(StrategyInfluencerAwareConversions.toConditionalServiceFilterFactory(predicate, factory));
        return this;
    }

    public abstract HttpServerBuilder ioExecutor(IoExecutor var1);

    public HttpServerBuilder executor(Executor executor) {
        throw new UnsupportedOperationException("Setting Executor not yet supported by " + this.getClass().getSimpleName());
    }

    public abstract HttpServerBuilder bufferAllocator(BufferAllocator var1);

    public final HttpServerBuilder executionStrategy(HttpExecutionStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public final ServerContext listenAndAwait(HttpService service) throws Exception {
        return BlockingUtils.blockingInvocation(this.listen(service));
    }

    public final ServerContext listenStreamingAndAwait(StreamingHttpService handler) throws Exception {
        return BlockingUtils.blockingInvocation(this.listenStreaming(handler));
    }

    public final ServerContext listenBlockingAndAwait(BlockingHttpService service) throws Exception {
        return BlockingUtils.blockingInvocation(this.listenBlocking(service));
    }

    public final ServerContext listenBlockingStreamingAndAwait(BlockingStreamingHttpService handler) throws Exception {
        return BlockingUtils.blockingInvocation(this.listenBlockingStreaming(handler));
    }

    public final Single<ServerContext> listen(HttpService service) {
        this.influencerChainBuilder.prependIfInfluencer(service);
        return this.listenForAdapter(HttpApiConversions.toStreamingHttpService(service, this.influencerChainBuilder.build(this.strategy)));
    }

    public final Single<ServerContext> listenStreaming(StreamingHttpService service) {
        return this.listenForService(service, this.strategy);
    }

    public final Single<ServerContext> listenBlocking(BlockingHttpService service) {
        this.influencerChainBuilder.prependIfInfluencer(service);
        return this.listenForAdapter(HttpApiConversions.toStreamingHttpService(service, this.influencerChainBuilder.build(this.strategy)));
    }

    public final Single<ServerContext> listenBlockingStreaming(BlockingStreamingHttpService service) {
        this.influencerChainBuilder.prependIfInfluencer(service);
        return this.listenForAdapter(HttpApiConversions.toStreamingHttpService(service, this.influencerChainBuilder.build(this.strategy)));
    }

    protected abstract Single<ServerContext> doListen(@Nullable ConnectionAcceptor var1, StreamingHttpService var2, HttpExecutionStrategy var3, boolean var4);

    private Single<ServerContext> listenForAdapter(HttpApiConversions.ServiceAdapterHolder adapterHolder) {
        return this.listenForService(adapterHolder.adaptor(), adapterHolder.serviceInvocationStrategy());
    }

    private Single<ServerContext> listenForService(StreamingHttpService rawService, HttpExecutionStrategy strategy) {
        ConnectionAcceptor connectionAcceptor = this.connectionAcceptorFactory == null ? null : this.connectionAcceptorFactory.create(ConnectionAcceptor.ACCEPT_ALL);
        StreamingHttpServiceFilterFactory currServiceFilter = this.serviceFilter;
        if (!AsyncContext.isDisabled()) {
            AsyncContextAwareHttpServiceFilter asyncContextFilter = new AsyncContextAwareHttpServiceFilter();
            currServiceFilter = currServiceFilter == null ? asyncContextFilter : HttpServerBuilder.appendFilter(asyncContextFilter, currServiceFilter);
        }
        StreamingHttpService filteredService = currServiceFilter != null ? currServiceFilter.create(rawService) : rawService;
        return this.doListen(connectionAcceptor, filteredService, strategy, this.drainRequestPayloadBody);
    }

    private static StreamingHttpServiceFilterFactory appendFilter(@Nullable StreamingHttpServiceFilterFactory current, StreamingHttpServiceFilterFactory next) {
        return current == null ? next : service -> current.create(next.create(service));
    }
}

