/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.encoding.api.Identity;
import io.servicetalk.http.api.HeaderUtils;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.HttpServiceContext;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceFilter;
import io.servicetalk.http.api.StreamingHttpServiceFilterFactory;
import io.servicetalk.http.api.UnsupportedContentEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContentCodingHttpServiceFilter
implements StreamingHttpServiceFilterFactory,
HttpExecutionStrategyInfluencer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentCodingHttpServiceFilter.class);
    private final List<ContentCodec> requestCodings;
    private final List<ContentCodec> responseCodings;

    public ContentCodingHttpServiceFilter(List<ContentCodec> supportedCodings) {
        this.requestCodings = Collections.emptyList();
        this.responseCodings = new ArrayList<ContentCodec>(supportedCodings);
    }

    public ContentCodingHttpServiceFilter(List<ContentCodec> supportedRequestCodings, List<ContentCodec> supportedResponseCodings) {
        this.requestCodings = new ArrayList<ContentCodec>(supportedRequestCodings);
        this.responseCodings = new ArrayList<ContentCodec>(supportedResponseCodings);
    }

    @Override
    public StreamingHttpServiceFilter create(final StreamingHttpService service) {
        return new StreamingHttpServiceFilter(service){

            @Override
            public Single<StreamingHttpResponse> handle(HttpServiceContext ctx, StreamingHttpRequest request, StreamingHttpResponseFactory responseFactory) {
                return Single.defer(() -> {
                    BufferAllocator allocator = ctx.executionContext().bufferAllocator();
                    try {
                        ContentCodec coding = HeaderUtils.identifyContentEncodingOrNullIfIdentity(request.headers(), ContentCodingHttpServiceFilter.this.requestCodings);
                        if (coding != null) {
                            request.transformPayloadBody(bufferPublisher -> coding.decode(bufferPublisher, allocator));
                        }
                        return super.handle(ctx, request, responseFactory).map(response -> {
                            ContentCodingHttpServiceFilter.encodePayloadContentIfAvailable(request.headers(), request.method(), ContentCodingHttpServiceFilter.this.responseCodings, response, allocator);
                            return response;
                        }).subscribeShareContext();
                    }
                    catch (UnsupportedContentEncodingException cause) {
                        LOGGER.error("Request failed for service={}, connection={}", new Object[]{service, this, cause});
                        return Single.succeeded((Object)responseFactory.unsupportedMediaType());
                    }
                });
            }
        };
    }

    @Override
    public HttpExecutionStrategy influenceStrategy(HttpExecutionStrategy strategy) {
        return strategy;
    }

    private static void encodePayloadContentIfAvailable(HttpHeaders requestHeaders, HttpRequestMethod method, List<ContentCodec> supportedEncodings, StreamingHttpResponse response, BufferAllocator allocator) {
        if (supportedEncodings.isEmpty() || HeaderUtils.hasContentEncoding(response.headers()) || ContentCodingHttpServiceFilter.isPassThrough(method, response)) {
            return;
        }
        ContentCodec coding = ContentCodingHttpServiceFilter.codingForResponse(requestHeaders, response, supportedEncodings);
        if (coding != null) {
            HeaderUtils.setContentEncoding(response.headers(), coding.name());
            response.transformPayloadBody(bufferPublisher -> coding.encode(bufferPublisher, allocator));
        }
    }

    private static boolean isPassThrough(HttpRequestMethod method, StreamingHttpResponse response) {
        int code = response.status().code();
        return HttpResponseStatus.StatusClass.INFORMATIONAL_1XX.contains(code) || code == HttpResponseStatus.NO_CONTENT.code() || code == HttpResponseStatus.NOT_MODIFIED.code() || method == HttpRequestMethod.HEAD || method == HttpRequestMethod.CONNECT && HttpResponseStatus.StatusClass.SUCCESSFUL_2XX.contains(code);
    }

    @Nullable
    private static ContentCodec codingForResponse(HttpHeaders requestHeaders, StreamingHttpResponse response, List<ContentCodec> supportedEncodings) {
        ContentCodec encoding = response.encoding();
        if (encoding == null) {
            encoding = io.servicetalk.encoding.api.internal.HeaderUtils.negotiateAcceptedEncoding((CharSequence)requestHeaders.get(HttpHeaderNames.ACCEPT_ENCODING), supportedEncodings);
        }
        return Identity.identity().equals(encoding) ? null : encoding;
    }
}

