/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpMetaData;
import io.servicetalk.http.api.HttpProtocolVersion;
import java.util.Objects;
import javax.annotation.Nullable;

abstract class AbstractHttpMetaData
implements HttpMetaData {
    @Nullable
    private ContentCodec encoding;
    private HttpProtocolVersion version;
    private final HttpHeaders headers;

    AbstractHttpMetaData(HttpProtocolVersion version, HttpHeaders headers) {
        this.version = Objects.requireNonNull(version);
        this.headers = Objects.requireNonNull(headers);
    }

    AbstractHttpMetaData(HttpProtocolVersion version, HttpHeaders headers, @Nullable ContentCodec encoding) {
        this.version = Objects.requireNonNull(version);
        this.headers = Objects.requireNonNull(headers);
        this.encoding = encoding;
    }

    AbstractHttpMetaData(AbstractHttpMetaData metaData) {
        this(metaData.version, metaData.headers, metaData.encoding);
    }

    @Override
    public final HttpProtocolVersion version() {
        return this.version;
    }

    @Override
    public HttpMetaData version(HttpProtocolVersion version) {
        this.version = Objects.requireNonNull(version);
        return this;
    }

    @Override
    public HttpMetaData encoding(ContentCodec encoding) {
        this.encoding = Objects.requireNonNull(encoding);
        return this;
    }

    @Override
    public ContentCodec encoding() {
        return this.encoding;
    }

    @Override
    public final HttpHeaders headers() {
        return this.headers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractHttpMetaData that = (AbstractHttpMetaData)o;
        return this.version.equals(that.version) && this.headers.equals(that.headers);
    }

    public int hashCode() {
        return 31 * this.version.hashCode() + this.headers.hashCode();
    }
}

