/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.FilterableReservedStreamingHttpConnection;
import io.servicetalk.http.api.HttpConnectionContext;
import io.servicetalk.http.api.HttpContextKeys;
import io.servicetalk.http.api.HttpEventKey;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import java.util.Objects;

public class ReservedStreamingHttpConnectionFilter
implements FilterableReservedStreamingHttpConnection {
    private final FilterableReservedStreamingHttpConnection delegate;

    protected ReservedStreamingHttpConnectionFilter(FilterableReservedStreamingHttpConnection delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public Completable releaseAsync() {
        return this.delegate.releaseAsync();
    }

    @Override
    public HttpConnectionContext connectionContext() {
        return this.delegate.connectionContext();
    }

    @Override
    public <T> Publisher<? extends T> transportEventStream(HttpEventKey<T> eventKey) {
        return this.delegate.transportEventStream(eventKey);
    }

    @Override
    public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
        return this.delegate.request(request);
    }

    @Override
    @Deprecated
    public final Single<StreamingHttpResponse> request(HttpExecutionStrategy strategy, StreamingHttpRequest request) {
        return this.request(this.delegate, strategy, request);
    }

    @Override
    public HttpExecutionContext executionContext() {
        return this.delegate.executionContext();
    }

    @Override
    public StreamingHttpResponseFactory httpResponseFactory() {
        return this.delegate.httpResponseFactory();
    }

    public Completable onClose() {
        return this.delegate.onClose();
    }

    public Completable closeAsync() {
        return this.delegate.closeAsync();
    }

    public Completable closeAsyncGracefully() {
        return this.delegate.closeAsyncGracefully();
    }

    @Override
    public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
        return this.delegate.newRequest(method, requestTarget);
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.delegate + ')';
    }

    protected final FilterableReservedStreamingHttpConnection delegate() {
        return this.delegate;
    }

    @Deprecated
    protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, HttpExecutionStrategy strategy, StreamingHttpRequest request) {
        return Single.defer(() -> {
            request.context().put(HttpContextKeys.HTTP_EXECUTION_STRATEGY_KEY, (Object)strategy);
            return this.request(request).shareContextOnSubscribe();
        });
    }
}

