/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.internal.OffloaderAwareExecutor;
import io.servicetalk.concurrent.internal.SignalOffloaderFactory;
import io.servicetalk.http.api.ClientInvoker;
import io.servicetalk.http.api.ExecutionContextOverridingServiceContext;
import io.servicetalk.http.api.FunctionToSingle;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpServiceContext;
import io.servicetalk.http.api.NoOffloadsHttpExecutionStrategy;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.api.StreamingHttpService;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;

class DefaultHttpExecutionStrategy
implements HttpExecutionStrategy {
    static final byte OFFLOAD_RECEIVE_META = 1;
    static final byte OFFLOAD_RECEIVE_DATA = 2;
    static final byte OFFLOAD_SEND = 4;
    @Nullable
    private final Executor executor;
    private final byte offloads;
    private final HttpExecutionStrategies.Builder.MergeStrategy mergeStrategy;
    private final boolean threadAffinity;

    DefaultHttpExecutionStrategy(@Nullable Executor executor, byte offloads, boolean threadAffinity, HttpExecutionStrategies.Builder.MergeStrategy mergeStrategy) {
        this.mergeStrategy = mergeStrategy;
        this.executor = executor != null ? (threadAffinity ? OffloaderAwareExecutor.ensureThreadAffinity((Executor)executor) : executor) : null;
        this.offloads = offloads;
        this.threadAffinity = threadAffinity;
    }

    DefaultHttpExecutionStrategy(byte offloadOverride, HttpExecutionStrategy original) {
        this.offloads = offloadOverride;
        this.executor = original.executor();
        if (original instanceof DefaultHttpExecutionStrategy) {
            DefaultHttpExecutionStrategy originalAsDefault = (DefaultHttpExecutionStrategy)original;
            this.mergeStrategy = originalAsDefault.mergeStrategy;
            this.threadAffinity = originalAsDefault.threadAffinity;
        } else {
            this.mergeStrategy = HttpExecutionStrategies.Builder.MergeStrategy.Merge;
            this.threadAffinity = false;
        }
    }

    @Nullable
    public Executor executor() {
        return this.executor;
    }

    @Override
    public <FS> Single<StreamingHttpResponse> invokeClient(Executor fallback, Publisher<Object> flattenedRequest, @Nullable FS flushStrategy, ClientInvoker<FS> client) {
        Executor e = this.executor(fallback);
        if (this.offloaded((byte)4)) {
            flattenedRequest = flattenedRequest.subscribeOn(e);
        }
        Single resp = client.invokeClient((Publisher<Object>)flattenedRequest, flushStrategy);
        if (this.offloaded((byte)1)) {
            resp = resp.publishOn(e);
        }
        if (this.offloaded((byte)2)) {
            resp = resp.map(response -> response.transformMessageBody(payload -> payload.publishOn(e)));
        }
        return resp;
    }

    @Override
    public Publisher<Object> invokeService(Executor fallback, StreamingHttpRequest request, Function<StreamingHttpRequest, Publisher<Object>> service, BiFunction<Throwable, Executor, Publisher<Object>> errorHandler) {
        Publisher resp;
        Executor e = this.executor(fallback);
        if (this.offloaded((byte)2)) {
            request = request.transformMessageBody(payload -> payload.publishOn(e));
        }
        if (this.offloaded((byte)1)) {
            StreamingHttpRequest r = request;
            resp = e.submit(() -> ((Publisher)service.apply(r)).shareContextOnSubscribe()).onErrorReturn(cause -> (Publisher)errorHandler.apply((Throwable)cause, e)).flatMapPublisher(Function.identity());
        } else {
            resp = service.apply(request);
        }
        if (this.offloaded((byte)4)) {
            resp = resp.subscribeOn(e);
        }
        return resp;
    }

    @Override
    public StreamingHttpService offloadService(final Executor fallback, final StreamingHttpService service) {
        return new StreamingHttpService(){
            private final Executor e;
            {
                this.e = DefaultHttpExecutionStrategy.this.executor(fallback);
            }

            @Override
            public Single<StreamingHttpResponse> handle(HttpServiceContext ctx, StreamingHttpRequest request, StreamingHttpResponseFactory responseFactory) {
                Single resp;
                HttpExecutionStrategy diff = HttpExecutionStrategies.difference(fallback, ctx.executionContext().executionStrategy(), DefaultHttpExecutionStrategy.this);
                ExecutionContextOverridingServiceContext wrappedCtx = new ExecutionContextOverridingServiceContext(ctx, DefaultHttpExecutionStrategy.this, this.e);
                if (diff == null) {
                    return service.handle(wrappedCtx, request, responseFactory);
                }
                if (diff.isDataReceiveOffloaded()) {
                    request = request.transformMessageBody(p -> p.publishOn(this.e));
                }
                if (diff.isMetadataReceiveOffloaded()) {
                    StreamingHttpRequest r2 = request;
                    resp = this.e.submit(() -> service.handle(wrappedCtx, r2, responseFactory).shareContextOnSubscribe()).flatMap(Function.identity());
                } else {
                    resp = service.handle(wrappedCtx, request, responseFactory);
                }
                return diff.isSendOffloaded() ? resp.map(r -> r.transformMessageBody(p -> p.subscribeOn(this.e))).subscribeOn(this.e) : resp;
            }

            @Override
            public Completable closeAsync() {
                return service.closeAsync();
            }

            public Completable closeAsyncGracefully() {
                return service.closeAsyncGracefully();
            }
        };
    }

    @Override
    public boolean isMetadataReceiveOffloaded() {
        return this.offloaded((byte)1);
    }

    @Override
    public boolean isDataReceiveOffloaded() {
        return this.offloaded((byte)2);
    }

    @Override
    public boolean isSendOffloaded() {
        return this.offloaded((byte)4);
    }

    @Override
    public HttpExecutionStrategy merge(HttpExecutionStrategy other) {
        Executor executor;
        if (this.equals(other)) {
            return this;
        }
        switch (this.mergeStrategy) {
            case ReturnSelf: {
                return this;
            }
            case ReturnOther: {
                if (this.executor == null || this.executor == other.executor()) {
                    return other;
                }
                if (other instanceof DefaultHttpExecutionStrategy) {
                    DefaultHttpExecutionStrategy otherAsDefault = (DefaultHttpExecutionStrategy)other;
                    return new DefaultHttpExecutionStrategy(this.executor, otherAsDefault.offloads, otherAsDefault.threadAffinity, otherAsDefault.mergeStrategy);
                }
                return new DefaultHttpExecutionStrategy(this.executor, DefaultHttpExecutionStrategy.generateOffloadsFlag(other), DefaultHttpExecutionStrategy.extractThreadAffinity(other.executor()), HttpExecutionStrategies.Builder.MergeStrategy.Merge);
            }
            case Merge: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown merge strategy: " + (Object)((Object)this.mergeStrategy)));
            }
        }
        if (other instanceof NoOffloadsHttpExecutionStrategy) {
            return other;
        }
        Executor otherExecutor = other.executor();
        Executor executor2 = executor = otherExecutor == null ? this.executor : otherExecutor;
        if (other instanceof DefaultHttpExecutionStrategy) {
            DefaultHttpExecutionStrategy otherAsDefault = (DefaultHttpExecutionStrategy)other;
            if (otherAsDefault.mergeStrategy == HttpExecutionStrategies.Builder.MergeStrategy.ReturnOther) {
                return this.executor == otherExecutor ? this : new DefaultHttpExecutionStrategy(executor, this.offloads, this.threadAffinity, this.mergeStrategy);
            }
            return new DefaultHttpExecutionStrategy(executor, (byte)(otherAsDefault.offloads | this.offloads), this.threadAffinity || otherAsDefault.threadAffinity, otherAsDefault.mergeStrategy == this.mergeStrategy ? this.mergeStrategy : HttpExecutionStrategies.Builder.MergeStrategy.Merge);
        }
        byte otherOffloads = DefaultHttpExecutionStrategy.generateOffloadsFlag(other);
        boolean otherThreadAffinity = DefaultHttpExecutionStrategy.extractThreadAffinity(otherExecutor);
        HttpExecutionStrategies.Builder.MergeStrategy otherMergeStrategy = HttpExecutionStrategies.Builder.MergeStrategy.Merge;
        return otherOffloads == this.offloads && executor == otherExecutor && otherThreadAffinity == this.threadAffinity && otherMergeStrategy == this.mergeStrategy ? this : new DefaultHttpExecutionStrategy(executor, (byte)(otherOffloads | this.offloads), this.threadAffinity || otherThreadAffinity, otherMergeStrategy);
    }

    private static boolean extractThreadAffinity(@Nullable Executor otherExecutor) {
        return otherExecutor instanceof SignalOffloaderFactory && ((SignalOffloaderFactory)otherExecutor).hasThreadAffinity();
    }

    private static byte generateOffloadsFlag(HttpExecutionStrategy strategy) {
        return (byte)((strategy.isDataReceiveOffloaded() ? 2 : 0) | (strategy.isMetadataReceiveOffloaded() ? 1 : 0) | (strategy.isSendOffloaded() ? 4 : 0));
    }

    @Override
    public <T> Single<T> invokeService(Executor fallback, Function<Executor, T> service) {
        Executor e = this.executor(fallback);
        if (this.offloaded((byte)1)) {
            return e.submit(() -> service.apply(e));
        }
        return new FunctionToSingle<Executor, T>(service, e);
    }

    public <T> Single<T> offloadSend(Executor fallback, Single<T> original) {
        return this.offloaded((byte)4) ? original.subscribeOn(this.executor(fallback)) : original;
    }

    public <T> Single<T> offloadReceive(Executor fallback, Single<T> original) {
        return this.offloaded((byte)1) || this.offloaded((byte)2) ? original.publishOn(this.executor(fallback)) : original;
    }

    public <T> Publisher<T> offloadSend(Executor fallback, Publisher<T> original) {
        return this.offloaded((byte)4) ? original.subscribeOn(this.executor(fallback)) : original;
    }

    public <T> Publisher<T> offloadReceive(Executor fallback, Publisher<T> original) {
        return this.offloaded((byte)1) || this.offloaded((byte)2) ? original.publishOn(this.executor(fallback)) : original;
    }

    private Executor executor(Executor fallback) {
        Objects.requireNonNull(fallback);
        return this.executor == null ? (this.threadAffinity ? OffloaderAwareExecutor.ensureThreadAffinity((Executor)fallback) : fallback) : this.executor;
    }

    boolean hasThreadAffinity() {
        return this.threadAffinity;
    }

    boolean offloaded(byte flag) {
        return (this.offloads & flag) == flag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultHttpExecutionStrategy that = (DefaultHttpExecutionStrategy)o;
        if (this.offloads != that.offloads) {
            return false;
        }
        if (this.threadAffinity != that.threadAffinity) {
            return false;
        }
        if (this.executor != null ? !this.executor.equals(that.executor) : that.executor != null) {
            return false;
        }
        return this.mergeStrategy == that.mergeStrategy;
    }

    public int hashCode() {
        int result = this.executor != null ? this.executor.hashCode() : 0;
        result = 31 * result + this.offloads;
        result = 31 * result + this.mergeStrategy.hashCode();
        result = 31 * result + (this.threadAffinity ? 1 : 0);
        return result;
    }

    public String toString() {
        return "DefaultHttpExecutionStrategy{executor=" + this.executor + ", offloads=" + this.offloads + ", mergeStrategy=" + (Object)((Object)this.mergeStrategy) + ", threadAffinity=" + this.threadAffinity + '}';
    }
}

