/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.http.api.DefaultHttpResponseMetaData;
import io.servicetalk.http.api.HttpCookiePair;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpOutputStream;
import io.servicetalk.http.api.HttpPayloadWriter;
import io.servicetalk.http.api.HttpPayloadWriterToHttpOutputStream;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.HttpSerializer;
import io.servicetalk.http.api.HttpSetCookie;
import java.util.Objects;

public abstract class BlockingStreamingHttpServerResponse
extends DefaultHttpResponseMetaData {
    private final HttpPayloadWriter<Buffer> payloadWriter;
    private final BufferAllocator allocator;

    BlockingStreamingHttpServerResponse(HttpResponseStatus status, HttpProtocolVersion version, HttpHeaders headers, HttpPayloadWriter<Buffer> payloadWriter, BufferAllocator allocator) {
        super(status, version, headers, null);
        this.payloadWriter = Objects.requireNonNull(payloadWriter);
        this.allocator = Objects.requireNonNull(allocator);
    }

    public abstract HttpPayloadWriter<Buffer> sendMetaData();

    public final <T> HttpPayloadWriter<T> sendMetaData(HttpSerializer<T> serializer) {
        HttpPayloadWriter<T> payloadWriter = serializer.serialize(this.headers(), this.payloadWriter, this.allocator);
        this.sendMetaData();
        return payloadWriter;
    }

    public final HttpOutputStream sendMetaDataOutputStream() {
        return new HttpPayloadWriterToHttpOutputStream(this.sendMetaData(), this.allocator);
    }

    @Override
    public BlockingStreamingHttpServerResponse version(HttpProtocolVersion version) {
        super.version(version);
        return this;
    }

    @Override
    public BlockingStreamingHttpServerResponse status(HttpResponseStatus status) {
        super.status(status);
        return this;
    }

    @Override
    public BlockingStreamingHttpServerResponse addHeader(CharSequence name, CharSequence value) {
        super.addHeader(name, value);
        return this;
    }

    @Override
    public BlockingStreamingHttpServerResponse addHeaders(HttpHeaders headers) {
        super.addHeaders(headers);
        return this;
    }

    @Override
    public BlockingStreamingHttpServerResponse setHeader(CharSequence name, CharSequence value) {
        super.setHeader(name, value);
        return this;
    }

    @Override
    public BlockingStreamingHttpServerResponse setHeaders(HttpHeaders headers) {
        super.setHeaders(headers);
        return this;
    }

    @Override
    public BlockingStreamingHttpServerResponse addCookie(HttpCookiePair cookie) {
        super.addCookie(cookie);
        return this;
    }

    @Override
    public BlockingStreamingHttpServerResponse addCookie(CharSequence name, CharSequence value) {
        super.addCookie(name, value);
        return this;
    }

    @Override
    public BlockingStreamingHttpServerResponse addSetCookie(HttpSetCookie cookie) {
        super.addSetCookie(cookie);
        return this;
    }

    @Override
    public BlockingStreamingHttpServerResponse addSetCookie(CharSequence name, CharSequence value) {
        super.addSetCookie(name, value);
        return this;
    }

    @Override
    public BlockingStreamingHttpServerResponse context(ContextMap context) {
        super.context(context);
        return this;
    }

    final HttpPayloadWriter<Buffer> payloadWriter() {
        return this.payloadWriter;
    }
}

