/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.http.api.ConditionalHttpClientFilter;
import io.servicetalk.http.api.ConditionalHttpConnectionFilter;
import io.servicetalk.http.api.FilterFactoryUtils;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.NewToDeprecatedFilter;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpConnectionFilter;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import java.util.function.Predicate;

public final class ConditionalFilterFactory
implements StreamingHttpConnectionFilterFactory,
StreamingHttpClientFilterFactory {
    private final Predicate<StreamingHttpRequest> predicate;
    private final FilterFactory predicateFactory;

    public ConditionalFilterFactory(Predicate<StreamingHttpRequest> predicate, FilterFactory predicateFactory) {
        this.predicate = predicate;
        this.predicateFactory = predicateFactory;
    }

    public StreamingHttpClientFilter create(FilterableStreamingHttpClient client) {
        return new ConditionalHttpClientFilter(this.predicate, (FilterableStreamingHttpClient)this.predicateFactory.create(client), client);
    }

    public StreamingHttpConnectionFilter create(FilterableStreamingHttpConnection connection) {
        return new ConditionalHttpConnectionFilter(this.predicate, (FilterableStreamingHttpConnection)this.predicateFactory.create(connection), connection);
    }

    public FilterFactory append(FilterFactory append) {
        final StreamingHttpClientFilterFactory clientFactory = FilterFactoryUtils.appendClientFilterFactory(FilterFactoryUtils.appendClientFilterFactory(this, append), (StreamingHttpClientFilterFactory)NewToDeprecatedFilter.NEW_TO_DEPRECATED_FILTER);
        final StreamingHttpConnectionFilterFactory connectionFactory = FilterFactoryUtils.appendConnectionFilterFactory(FilterFactoryUtils.appendConnectionFilterFactory(this, append), (StreamingHttpConnectionFilterFactory)NewToDeprecatedFilter.NEW_TO_DEPRECATED_FILTER);
        return new FilterFactory(){

            public StreamingHttpClientFilter create(FilterableStreamingHttpClient client) {
                return clientFactory.create(client);
            }

            public StreamingHttpConnectionFilter create(FilterableStreamingHttpConnection connection) {
                return connectionFactory.create(connection);
            }
        };
    }

    public static interface FilterFactory
    extends StreamingHttpClientFilterFactory,
    StreamingHttpConnectionFilterFactory {
        public static <FF extends StreamingHttpClientFilterFactory & StreamingHttpConnectionFilterFactory> FilterFactory from(final FF original) {
            return new FilterFactory(){

                public StreamingHttpClientFilter create(FilterableStreamingHttpClient client) {
                    return original.create(client);
                }

                public StreamingHttpConnectionFilter create(FilterableStreamingHttpConnection connection) {
                    return ((StreamingHttpConnectionFilterFactory)original).create(connection);
                }
            };
        }
    }
}

