/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.http.api.BlockingStreamingHttpRequest;
import io.servicetalk.http.api.HttpCookiePair;
import io.servicetalk.http.api.HttpDeserializer;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpRequest;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpSerializer;
import io.servicetalk.http.api.HttpSetCookie;
import io.servicetalk.http.api.TrailersTransformer;
import java.nio.charset.Charset;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

public interface StreamingHttpRequest
extends HttpRequestMetaData {
    public Publisher<Buffer> payloadBody();

    default public <T> Publisher<T> payloadBody(HttpDeserializer<T> deserializer) {
        return deserializer.deserialize(this.headers(), this.payloadBody());
    }

    public Publisher<Object> messageBody();

    public StreamingHttpRequest payloadBody(Publisher<Buffer> var1);

    public <T> StreamingHttpRequest payloadBody(Publisher<T> var1, HttpSerializer<T> var2);

    public <T> StreamingHttpRequest transformPayloadBody(Function<Publisher<Buffer>, Publisher<T>> var1, HttpSerializer<T> var2);

    default public <T, R> StreamingHttpRequest transformPayloadBody(Function<Publisher<T>, Publisher<R>> transformer, HttpDeserializer<T> deserializer, HttpSerializer<R> serializer) {
        return this.transformPayloadBody(bufferPublisher -> (Publisher)transformer.apply(deserializer.deserialize(this.headers(), (Publisher<Buffer>)bufferPublisher)), serializer);
    }

    public StreamingHttpRequest transformPayloadBody(UnaryOperator<Publisher<Buffer>> var1);

    public StreamingHttpRequest transformMessageBody(UnaryOperator<Publisher<?>> var1);

    public <T> StreamingHttpRequest transform(TrailersTransformer<T, Buffer> var1);

    public Single<HttpRequest> toRequest();

    public BlockingStreamingHttpRequest toBlockingStreamingRequest();

    @Override
    public StreamingHttpRequest rawPath(String var1);

    @Override
    public StreamingHttpRequest path(String var1);

    @Override
    public StreamingHttpRequest appendPathSegments(String ... var1);

    @Override
    public StreamingHttpRequest rawQuery(@Nullable String var1);

    @Override
    public StreamingHttpRequest query(@Nullable String var1);

    @Override
    public StreamingHttpRequest addQueryParameter(String var1, String var2);

    @Override
    public StreamingHttpRequest addQueryParameters(String var1, Iterable<String> var2);

    @Override
    public StreamingHttpRequest addQueryParameters(String var1, String ... var2);

    @Override
    public StreamingHttpRequest setQueryParameter(String var1, String var2);

    @Override
    public StreamingHttpRequest setQueryParameters(String var1, Iterable<String> var2);

    @Override
    public StreamingHttpRequest setQueryParameters(String var1, String ... var2);

    @Override
    public StreamingHttpRequest version(HttpProtocolVersion var1);

    @Override
    public StreamingHttpRequest method(HttpRequestMethod var1);

    @Override
    public StreamingHttpRequest encoding(ContentCodec var1);

    @Override
    public StreamingHttpRequest requestTarget(String var1);

    @Override
    public StreamingHttpRequest requestTarget(String var1, Charset var2);

    @Override
    default public StreamingHttpRequest addHeader(CharSequence name, CharSequence value) {
        HttpRequestMetaData.super.addHeader(name, value);
        return this;
    }

    @Override
    default public StreamingHttpRequest addHeaders(HttpHeaders headers) {
        HttpRequestMetaData.super.addHeaders(headers);
        return this;
    }

    @Override
    default public StreamingHttpRequest setHeader(CharSequence name, CharSequence value) {
        HttpRequestMetaData.super.setHeader(name, value);
        return this;
    }

    @Override
    default public StreamingHttpRequest setHeaders(HttpHeaders headers) {
        HttpRequestMetaData.super.setHeaders(headers);
        return this;
    }

    @Override
    default public StreamingHttpRequest addCookie(HttpCookiePair cookie) {
        HttpRequestMetaData.super.addCookie(cookie);
        return this;
    }

    @Override
    default public StreamingHttpRequest addCookie(CharSequence name, CharSequence value) {
        HttpRequestMetaData.super.addCookie(name, value);
        return this;
    }

    @Override
    default public StreamingHttpRequest addSetCookie(HttpSetCookie cookie) {
        HttpRequestMetaData.super.addSetCookie(cookie);
        return this;
    }

    @Override
    default public StreamingHttpRequest addSetCookie(CharSequence name, CharSequence value) {
        HttpRequestMetaData.super.addSetCookie(name, value);
        return this;
    }

    @Override
    default public StreamingHttpRequest context(ContextMap context) {
        HttpRequestMetaData.super.context(context);
        return this;
    }
}

