/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.context.api.ContextMap;
import io.servicetalk.context.api.ContextMapHolder;
import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.http.api.HttpCookiePair;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpSetCookie;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface HttpMetaData
extends ContextMapHolder {
    public HttpProtocolVersion version();

    public HttpMetaData version(HttpProtocolVersion var1);

    public HttpHeaders headers();

    public HttpMetaData encoding(ContentCodec var1);

    @Nullable
    public ContentCodec encoding();

    default public HttpMetaData addHeader(CharSequence name, CharSequence value) {
        this.headers().add(name, value);
        return this;
    }

    default public HttpMetaData addHeaders(HttpHeaders headers) {
        this.headers().add(headers);
        return this;
    }

    default public HttpMetaData setHeader(CharSequence name, CharSequence value) {
        this.headers().set(name, value);
        return this;
    }

    default public HttpMetaData setHeaders(HttpHeaders headers) {
        this.headers().set(headers);
        return this;
    }

    default public HttpMetaData addCookie(HttpCookiePair cookie) {
        this.headers().addCookie(cookie);
        return this;
    }

    default public HttpMetaData addCookie(CharSequence name, CharSequence value) {
        this.headers().addCookie(name, value);
        return this;
    }

    default public HttpMetaData addSetCookie(HttpSetCookie cookie) {
        this.headers().addSetCookie(cookie);
        return this;
    }

    default public HttpMetaData addSetCookie(CharSequence name, CharSequence value) {
        this.headers().addSetCookie(name, value);
        return this;
    }

    public String toString();

    default public String toString(BiFunction<? super CharSequence, ? super CharSequence, CharSequence> headerFilter) {
        return this.toString() + System.lineSeparator() + this.headers().toString(headerFilter);
    }

    @Nonnull
    default public ContextMap context() {
        throw new UnsupportedOperationException("Method context() is not supported by " + this.getClass().getName());
    }

    default public HttpMetaData context(ContextMap context) {
        throw new UnsupportedOperationException("Method context(ContextMap) is not supported by " + this.getClass().getName());
    }
}

