/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceFilterFactory;
import java.util.Objects;

public final class FilterFactoryUtils {
    private FilterFactoryUtils() {
    }

    public static StreamingHttpClientFilterFactory appendClientFilterFactory(StreamingHttpClientFilterFactory first, StreamingHttpClientFilterFactory second) {
        Objects.requireNonNull(first);
        Objects.requireNonNull(second);
        return client -> first.create((FilterableStreamingHttpClient)second.create(client));
    }

    public static StreamingHttpConnectionFilterFactory appendConnectionFilterFactory(StreamingHttpConnectionFilterFactory first, StreamingHttpConnectionFilterFactory second) {
        Objects.requireNonNull(first);
        Objects.requireNonNull(second);
        return connection -> first.create((FilterableStreamingHttpConnection)second.create(connection));
    }

    public static StreamingHttpServiceFilterFactory appendServiceFilterFactory(StreamingHttpServiceFilterFactory first, StreamingHttpServiceFilterFactory second) {
        Objects.requireNonNull(first);
        Objects.requireNonNull(second);
        return service -> first.create((StreamingHttpService)second.create(service));
    }
}

