/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.http.api.BlockingStreamingHttpRequest;
import io.servicetalk.http.api.DefaultBlockingStreamingHttpRequest;
import io.servicetalk.http.api.DefaultHttpRequest;
import io.servicetalk.http.api.DefaultHttpRequestMetaData;
import io.servicetalk.http.api.DefaultPayloadInfo;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpHeadersFactory;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpRequest;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpSerializer;
import io.servicetalk.http.api.PayloadInfo;
import io.servicetalk.http.api.StreamingHttpPayloadHolder;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.TrailersTransformer;
import java.nio.charset.Charset;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

final class DefaultStreamingHttpRequest
extends DefaultHttpRequestMetaData
implements StreamingHttpRequest,
PayloadInfo {
    private final StreamingHttpPayloadHolder payloadHolder;

    DefaultStreamingHttpRequest(HttpRequestMethod method, String requestTarget, HttpProtocolVersion version, HttpHeaders headers, @Nullable ContentCodec encoding, BufferAllocator allocator, @Nullable Publisher<?> payloadBody, DefaultPayloadInfo payloadInfo, HttpHeadersFactory headersFactory) {
        super(method, requestTarget, version, headers);
        if (encoding != null) {
            this.encoding(encoding);
        }
        this.payloadHolder = new StreamingHttpPayloadHolder(headers, allocator, payloadBody, payloadInfo, headersFactory, version);
    }

    @Override
    public StreamingHttpRequest version(HttpProtocolVersion version) {
        super.version(version);
        return this;
    }

    @Override
    public StreamingHttpRequest encoding(ContentCodec encoding) {
        super.encoding(encoding);
        return this;
    }

    @Override
    public StreamingHttpRequest method(HttpRequestMethod method) {
        super.method(method);
        return this;
    }

    @Override
    public StreamingHttpRequest requestTarget(String requestTarget) {
        super.requestTarget(requestTarget);
        return this;
    }

    @Override
    public StreamingHttpRequest requestTarget(String requestTarget, Charset encoding) {
        super.requestTarget(requestTarget, encoding);
        return this;
    }

    @Override
    public StreamingHttpRequest path(String path) {
        super.path(path);
        return this;
    }

    @Override
    public StreamingHttpRequest appendPathSegments(String ... segments) {
        super.appendPathSegments(segments);
        return this;
    }

    @Override
    public StreamingHttpRequest rawPath(String path) {
        super.rawPath(path);
        return this;
    }

    @Override
    public StreamingHttpRequest rawQuery(@Nullable String query) {
        super.rawQuery(query);
        return this;
    }

    @Override
    public StreamingHttpRequest query(@Nullable String query) {
        super.query(query);
        return this;
    }

    @Override
    public StreamingHttpRequest addQueryParameter(String key, String value) {
        super.addQueryParameter(key, value);
        return this;
    }

    @Override
    public StreamingHttpRequest addQueryParameters(String key, Iterable<String> values) {
        super.addQueryParameters(key, values);
        return this;
    }

    @Override
    public StreamingHttpRequest addQueryParameters(String key, String ... values) {
        super.addQueryParameters(key, values);
        return this;
    }

    @Override
    public StreamingHttpRequest setQueryParameter(String key, String value) {
        super.setQueryParameter(key, value);
        return this;
    }

    @Override
    public StreamingHttpRequest setQueryParameters(String key, Iterable<String> values) {
        super.setQueryParameters(key, values);
        return this;
    }

    @Override
    public StreamingHttpRequest setQueryParameters(String key, String ... values) {
        super.setQueryParameters(key, values);
        return this;
    }

    @Override
    public Publisher<Buffer> payloadBody() {
        return this.payloadHolder.payloadBody();
    }

    @Override
    public Publisher<Object> messageBody() {
        return this.payloadHolder.messageBody();
    }

    @Override
    public StreamingHttpRequest payloadBody(Publisher<Buffer> payloadBody) {
        this.payloadHolder.payloadBody(payloadBody);
        return this;
    }

    @Override
    public <T> StreamingHttpRequest payloadBody(Publisher<T> payloadBody, HttpSerializer<T> serializer) {
        this.payloadHolder.payloadBody(payloadBody, serializer);
        return this;
    }

    @Override
    public <T> StreamingHttpRequest transformPayloadBody(Function<Publisher<Buffer>, Publisher<T>> transformer, HttpSerializer<T> serializer) {
        this.payloadHolder.transformPayloadBody(transformer, serializer);
        return this;
    }

    @Override
    public StreamingHttpRequest transformPayloadBody(UnaryOperator<Publisher<Buffer>> transformer) {
        this.payloadHolder.transformPayloadBody(transformer);
        return this;
    }

    @Override
    public StreamingHttpRequest transformMessageBody(UnaryOperator<Publisher<?>> transformer) {
        this.payloadHolder.transformMessageBody(transformer);
        return this;
    }

    @Override
    public <T> StreamingHttpRequest transform(TrailersTransformer<T, Buffer> trailersTransformer) {
        this.payloadHolder.transform(trailersTransformer);
        return this;
    }

    @Override
    public Single<HttpRequest> toRequest() {
        return this.payloadHolder.aggregate().map(pair -> new DefaultHttpRequest(this, pair.payload, pair.trailers));
    }

    @Override
    public BlockingStreamingHttpRequest toBlockingStreamingRequest() {
        return new DefaultBlockingStreamingHttpRequest(this);
    }

    @Override
    public boolean isEmpty() {
        return this.payloadHolder.isEmpty();
    }

    @Override
    public boolean isSafeToAggregate() {
        return this.payloadHolder.isSafeToAggregate();
    }

    @Override
    public boolean mayHaveTrailers() {
        return this.payloadHolder.mayHaveTrailers();
    }

    @Override
    public boolean isGenericTypeBuffer() {
        return this.payloadHolder.isGenericTypeBuffer();
    }

    StreamingHttpPayloadHolder payloadHolder() {
        return this.payloadHolder;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultStreamingHttpRequest that = (DefaultStreamingHttpRequest)o;
        return this.payloadHolder.equals(that.payloadHolder);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.payloadHolder.hashCode();
        return result;
    }
}

