/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.http.api.DefaultHttpHeaders;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpHeadersFactory;

public final class DefaultHttpHeadersFactory
implements HttpHeadersFactory {
    public static final HttpHeadersFactory INSTANCE = new DefaultHttpHeadersFactory(true, true);
    private final boolean validateNames;
    private final boolean validateCookies;
    private final int headersArraySizeHint;
    private final int trailersArraySizeHint;

    public DefaultHttpHeadersFactory(boolean validateNames, boolean validateCookies) {
        this(validateNames, validateCookies, 16, 4);
    }

    public DefaultHttpHeadersFactory(boolean validateNames, boolean validateCookies, int headersArraySizeHint, int trailersArraySizeHint) {
        this.validateNames = validateNames;
        this.validateCookies = validateCookies;
        this.headersArraySizeHint = headersArraySizeHint;
        this.trailersArraySizeHint = trailersArraySizeHint;
    }

    @Override
    public HttpHeaders newHeaders() {
        return new DefaultHttpHeaders(this.headersArraySizeHint, this.validateNames, this.validateCookies);
    }

    @Override
    public HttpHeaders newTrailers() {
        return new DefaultHttpHeaders(this.trailersArraySizeHint, this.validateNames, this.validateCookies);
    }

    @Override
    public HttpHeaders newEmptyTrailers() {
        return new DefaultHttpHeaders(0, this.validateNames, this.validateCookies);
    }

    @Override
    public boolean validateCookies() {
        return this.validateCookies;
    }
}

