/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.client.api.DefaultServiceDiscovererEvent;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.client.api.partition.PartitionAttributes;
import io.servicetalk.client.api.partition.PartitionedServiceDiscovererEvent;
import io.servicetalk.concurrent.api.BiIntFunction;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.RetryStrategies;
import io.servicetalk.http.api.ServiceDiscoveryRetryStrategy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class DefaultServiceDiscoveryRetryStrategy<ResolvedAddress, E extends ServiceDiscovererEvent<ResolvedAddress>>
implements ServiceDiscoveryRetryStrategy<ResolvedAddress, E> {
    private final UnaryOperator<E> flipAvailability;
    private final boolean retainAddressesTillSuccess;
    private final BiIntFunction<Throwable, ? extends Completable> retryStrategy;

    private DefaultServiceDiscoveryRetryStrategy(UnaryOperator<E> flipAvailability, boolean retainAddressesTillSuccess, BiIntFunction<Throwable, ? extends Completable> retryStrategy) {
        this.flipAvailability = Objects.requireNonNull(flipAvailability);
        this.retainAddressesTillSuccess = retainAddressesTillSuccess;
        this.retryStrategy = Objects.requireNonNull(retryStrategy);
    }

    @Override
    public Publisher<Collection<E>> apply(Publisher<Collection<E>> sdEvents) {
        return Publisher.defer(() -> {
            EventsCache eventsCache = new EventsCache(this.flipAvailability);
            if (this.retainAddressesTillSuccess) {
                return sdEvents.map(eventsCache::consume).beforeOnError(__ -> eventsCache.errorSeen()).retryWhen(this.retryStrategy);
            }
            return sdEvents.map(eventsCache::consume).recoverWith(cause -> {
                Collection events = eventsCache.errorSeen();
                return events == null ? Publisher.failed((Throwable)cause) : Publisher.from(events.stream().map(this.flipAvailability).collect(Collectors.toList())).concat(Publisher.failed((Throwable)cause));
            }).retryWhen(this.retryStrategy);
        });
    }

    private static BiIntFunction<Throwable, ? extends Completable> defaultRetryStrategy(Executor executor, Duration initialDelay, Duration jitter) {
        return RetryStrategies.retryWithConstantBackoffDeltaJitter(__ -> true, (Duration)initialDelay, (Duration)jitter, (Executor)executor);
    }

    private static final class EventsCache<R, E extends ServiceDiscovererEvent<R>> {
        private static final Map NONE_RETAINED = Collections.emptyMap();
        private Map<R, E> retainedAddresses = EventsCache.noneRetained();
        private final Map<R, E> activeAddresses = new HashMap<R, E>();
        private final UnaryOperator<E> flipAvailability;

        EventsCache(UnaryOperator<E> flipAvailability) {
            this.flipAvailability = flipAvailability;
        }

        @Nullable
        Collection<E> errorSeen() {
            if (this.retainedAddresses == NONE_RETAINED) {
                this.retainedAddresses = new HashMap<R, E>(this.activeAddresses);
            }
            this.activeAddresses.clear();
            return this.retainedAddresses.isEmpty() ? null : this.retainedAddresses.values();
        }

        @Nullable
        Collection<E> consume(Collection<E> events) {
            if (this.retainedAddresses == NONE_RETAINED) {
                for (ServiceDiscovererEvent e : events) {
                    if (e.isAvailable()) {
                        this.activeAddresses.put(e.address(), e);
                        continue;
                    }
                    this.activeAddresses.remove(e.address());
                }
                return events;
            }
            for (ServiceDiscovererEvent event : events) {
                Object address = event.address();
                if (event.isAvailable()) {
                    this.activeAddresses.put(address, event);
                    continue;
                }
                this.activeAddresses.remove(address);
            }
            ArrayList toReturn = new ArrayList(this.activeAddresses.values());
            for (Object address : this.activeAddresses.keySet()) {
                this.retainedAddresses.remove(address);
            }
            if (!this.retainedAddresses.isEmpty()) {
                for (ServiceDiscovererEvent evt : this.retainedAddresses.values()) {
                    toReturn.add(this.flipAvailability.apply(evt));
                }
            }
            this.retainedAddresses = EventsCache.noneRetained();
            return toReturn.isEmpty() ? null : toReturn;
        }

        private static <R, E extends ServiceDiscovererEvent<R>> Map<R, E> noneRetained() {
            return NONE_RETAINED;
        }
    }

    public static final class Builder<ResolvedAddress, E extends ServiceDiscovererEvent<ResolvedAddress>> {
        private BiIntFunction<Throwable, ? extends Completable> retryStrategy;
        private final UnaryOperator<E> flipAvailability;
        private boolean retainAddressesTillSuccess = true;

        private Builder(BiIntFunction<Throwable, ? extends Completable> retryStrategy, UnaryOperator<E> flipAvailability) {
            this.retryStrategy = retryStrategy;
            this.flipAvailability = Objects.requireNonNull(flipAvailability);
        }

        public Builder<ResolvedAddress, E> retainAddressesTillSuccess(boolean retainAddressesTillSuccess) {
            this.retainAddressesTillSuccess = retainAddressesTillSuccess;
            return this;
        }

        public Builder<ResolvedAddress, E> retryStrategy(BiIntFunction<Throwable, ? extends Completable> retryStrategy) {
            this.retryStrategy = Objects.requireNonNull(retryStrategy);
            return this;
        }

        public ServiceDiscoveryRetryStrategy<ResolvedAddress, E> build() {
            return new DefaultServiceDiscoveryRetryStrategy(this.flipAvailability, this.retainAddressesTillSuccess, this.retryStrategy);
        }

        public static <ResolvedAddress> Builder<ResolvedAddress, ServiceDiscovererEvent<ResolvedAddress>> withDefaults(Executor executor, Duration initialDelay, Duration jitter) {
            return new Builder((BiIntFunction<Throwable, ? extends Completable>)DefaultServiceDiscoveryRetryStrategy.defaultRetryStrategy(executor, initialDelay, jitter), evt -> new DefaultServiceDiscovererEvent(evt.address(), !evt.isAvailable()));
        }

        public static <ResolvedAddress> Builder<ResolvedAddress, PartitionedServiceDiscovererEvent<ResolvedAddress>> withDefaultsForPartitions(Executor executor, Duration initialDelay, Duration jitter) {
            return new Builder((BiIntFunction<Throwable, ? extends Completable>)DefaultServiceDiscoveryRetryStrategy.defaultRetryStrategy(executor, initialDelay, jitter), evt -> new PartitionedServiceDiscovererEvent<ResolvedAddress>((PartitionedServiceDiscovererEvent)evt){
                final /* synthetic */ PartitionedServiceDiscovererEvent val$evt;
                {
                    this.val$evt = partitionedServiceDiscovererEvent;
                }

                public PartitionAttributes partitionAddress() {
                    return this.val$evt.partitionAddress();
                }

                public ResolvedAddress address() {
                    return this.val$evt.address();
                }

                public boolean isAvailable() {
                    return !this.val$evt.isAvailable();
                }
            });
        }

        public static <ResolvedAddress, E extends ServiceDiscovererEvent<ResolvedAddress>> Builder<ResolvedAddress, E> withDefaults(Executor executor, Duration initialDelay, Duration jitter, UnaryOperator<E> flipAvailability) {
            return new Builder<ResolvedAddress, E>((BiIntFunction<Throwable, ? extends Completable>)DefaultServiceDiscoveryRetryStrategy.defaultRetryStrategy(executor, initialDelay, jitter), flipAvailability);
        }
    }
}

