/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.http.api.DefaultHttpHeaders;
import io.servicetalk.http.api.HeaderUtils;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpSetCookie;
import javax.annotation.Nullable;

public final class DefaultHttpSetCookie
implements HttpSetCookie {
    private static final String ENCODED_LABEL_DOMAIN = "; domain=";
    private static final String ENCODED_LABEL_PATH = "; path=";
    private static final String ENCODED_LABEL_EXPIRES = "; expires=";
    private static final String ENCODED_LABEL_MAX_AGE = "; max-age=";
    private static final String ENCODED_LABEL_HTTP_ONLY = "; httponly";
    private static final String ENCODED_LABEL_SECURE = "; secure";
    private static final String ENCODED_LABEL_SAMESITE = "; samesite=";
    private static final HttpHeaders AV_FIELD_NAMES = new DefaultHttpHeaders(16, false, false);
    private final CharSequence name;
    private final CharSequence value;
    @Nullable
    private final CharSequence path;
    @Nullable
    private final CharSequence domain;
    @Nullable
    private final CharSequence expires;
    @Nullable
    private final Long maxAge;
    @Nullable
    private final HttpSetCookie.SameSite sameSite;
    private final boolean wrapped;
    private final boolean secure;
    private final boolean httpOnly;

    public DefaultHttpSetCookie(CharSequence name, CharSequence value) {
        this(name, value, false, false, false);
    }

    public DefaultHttpSetCookie(CharSequence name, CharSequence value, boolean wrapped, boolean secure, boolean httpOnly) {
        this(name, value, null, null, null, null, null, wrapped, secure, httpOnly);
    }

    public DefaultHttpSetCookie(CharSequence name, CharSequence value, @Nullable CharSequence path, @Nullable CharSequence domain, @Nullable CharSequence expires, @Nullable Long maxAge, @Nullable HttpSetCookie.SameSite sameSite, boolean wrapped, boolean secure, boolean httpOnly) {
        HeaderUtils.validateCookieNameAndValue(name, value);
        this.name = name;
        this.value = value;
        this.path = path;
        this.domain = domain;
        this.expires = expires;
        this.maxAge = maxAge;
        this.sameSite = sameSite;
        this.wrapped = wrapped;
        this.secure = secure;
        this.httpOnly = httpOnly;
    }

    static HttpSetCookie parseSetCookie(CharSequence setCookieString, boolean validateContent, @Nullable CharSequence name, int i) {
        int begin;
        ParseState parseState;
        CharSequence value = null;
        CharSequence path = null;
        CharSequence domain = null;
        CharSequence expires = null;
        Long maxAge = null;
        HttpSetCookie.SameSite sameSite = null;
        boolean isWrapped = false;
        boolean isSecure = false;
        boolean isHttpOnly = false;
        if (name != null) {
            parseState = ParseState.ParsingValue;
            begin = i;
        } else {
            parseState = ParseState.Unknown;
            begin = 0;
        }
        block22: while (i < setCookieString.length()) {
            char c = setCookieString.charAt(i);
            switch (c) {
                case '=': {
                    CharSequence avName;
                    if (name == null) {
                        if (i <= begin) {
                            throw new IllegalArgumentException("cookie name cannot be null or empty");
                        }
                        name = setCookieString.subSequence(begin, i);
                        if (validateContent) {
                            HeaderUtils.validateCookieTokenAndHeaderName(name);
                        }
                        parseState = ParseState.ParsingValue;
                    } else if (parseState == ParseState.Unknown) {
                        avName = setCookieString.subSequence(begin, i);
                        CharSequence newState = AV_FIELD_NAMES.get(avName);
                        if (newState != null) {
                            parseState = ((ParseStateCharSequence)newState).state;
                        }
                    } else {
                        throw new IllegalArgumentException("unexpected = at index: " + i);
                    }
                    begin = ++i;
                    continue block22;
                }
                case '\"': {
                    if (parseState == ParseState.ParsingValue) {
                        if (isWrapped) {
                            parseState = ParseState.Unknown;
                            value = setCookieString.subSequence(begin, i);
                            i += 3;
                        } else {
                            isWrapped = true;
                        }
                        begin = ++i;
                    } else if (value == null) {
                        throw new IllegalArgumentException("unexpected quote at index: " + i);
                    }
                    ++i;
                    continue block22;
                }
                case '%': {
                    if (validateContent) {
                        DefaultHttpSetCookie.extractAndValidateCookieHexValue(setCookieString, i);
                    }
                    i += 4;
                    continue block22;
                }
                case ';': {
                    CharSequence avName;
                    if (i + 1 == setCookieString.length()) {
                        throw new IllegalArgumentException("unexpected trailing ';'");
                    }
                    switch (parseState) {
                        case ParsingValue: {
                            value = setCookieString.subSequence(begin, i);
                            break;
                        }
                        case ParsingPath: {
                            path = setCookieString.subSequence(begin, i);
                            break;
                        }
                        case ParsingDomain: {
                            domain = setCookieString.subSequence(begin, i);
                            break;
                        }
                        case ParsingExpires: {
                            expires = setCookieString.subSequence(begin, i);
                            break;
                        }
                        case ParsingMaxAge: {
                            maxAge = Long.parseLong(setCookieString.subSequence(begin, i).toString());
                            break;
                        }
                        case ParsingSameSite: {
                            sameSite = DefaultHttpSetCookie.fromSequence(setCookieString, begin, i);
                            break;
                        }
                        default: {
                            if (name == null) {
                                throw new IllegalArgumentException("cookie value not found at index " + i);
                            }
                            avName = setCookieString.subSequence(begin, i);
                            if (CharSequences.contentEqualsIgnoreCase((CharSequence)avName, (CharSequence)"secure")) {
                                isSecure = true;
                                break;
                            }
                            if (!CharSequences.contentEqualsIgnoreCase((CharSequence)avName, (CharSequence)"httponly")) break;
                            isHttpOnly = true;
                        }
                    }
                    parseState = ParseState.Unknown;
                    begin = i += 2;
                    continue block22;
                }
            }
            if (validateContent && parseState != ParseState.ParsingExpires) {
                DefaultHttpSetCookie.validateCookieOctetHexValue(c);
            }
            ++i;
        }
        if (begin < i) {
            switch (parseState) {
                case ParsingValue: {
                    value = setCookieString.subSequence(begin, i);
                    break;
                }
                case ParsingPath: {
                    path = setCookieString.subSequence(begin, i);
                    break;
                }
                case ParsingDomain: {
                    domain = setCookieString.subSequence(begin, i);
                    break;
                }
                case ParsingExpires: {
                    expires = setCookieString.subSequence(begin, i);
                    break;
                }
                case ParsingSameSite: {
                    sameSite = DefaultHttpSetCookie.fromSequence(setCookieString, begin, i);
                    break;
                }
                case ParsingMaxAge: {
                    maxAge = Long.parseLong(setCookieString.subSequence(begin, i).toString());
                    break;
                }
                default: {
                    if (name == null) {
                        throw new IllegalArgumentException("cookie value not found at index " + i);
                    }
                    CharSequence avName = setCookieString.subSequence(begin, i);
                    if (CharSequences.contentEqualsIgnoreCase((CharSequence)avName, (CharSequence)"secure")) {
                        isSecure = true;
                        break;
                    }
                    if (!CharSequences.contentEqualsIgnoreCase((CharSequence)avName, (CharSequence)"httponly")) break;
                    isHttpOnly = true;
                }
            }
        }
        assert (name != null && value != null);
        return new DefaultHttpSetCookie(name, value, path, domain, expires, maxAge, sameSite, isWrapped, isSecure, isHttpOnly);
    }

    public static HttpSetCookie parseSetCookie(CharSequence setCookieString, boolean validateContent) {
        return DefaultHttpSetCookie.parseSetCookie(setCookieString, validateContent, null, 0);
    }

    @Override
    public CharSequence name() {
        return this.name;
    }

    @Override
    public CharSequence value() {
        return this.value;
    }

    @Override
    public boolean isWrapped() {
        return this.wrapped;
    }

    @Override
    @Nullable
    public CharSequence domain() {
        return this.domain;
    }

    @Override
    @Nullable
    public CharSequence path() {
        return this.path;
    }

    @Override
    @Nullable
    public Long maxAge() {
        return this.maxAge;
    }

    @Override
    @Nullable
    public CharSequence expires() {
        return this.expires;
    }

    @Override
    @Nullable
    public HttpSetCookie.SameSite sameSite() {
        return this.sameSite;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    @Override
    public CharSequence encoded() {
        StringBuilder sb = new StringBuilder(1 + this.name.length() + this.value.length() + (this.wrapped ? 2 : 0) + (this.domain != null ? ENCODED_LABEL_DOMAIN.length() + this.domain.length() : 0) + (this.path != null ? ENCODED_LABEL_PATH.length() + this.path.length() : 0) + (this.expires != null ? ENCODED_LABEL_EXPIRES.length() + this.expires.length() : 0) + (this.maxAge != null ? ENCODED_LABEL_MAX_AGE.length() + 11 : 0) + (this.sameSite != null ? ENCODED_LABEL_SAMESITE.length() + HttpSetCookie.SameSite.Strict.toString().length() : 0) + (this.httpOnly ? ENCODED_LABEL_HTTP_ONLY.length() : 0) + (this.secure ? ENCODED_LABEL_SECURE.length() : 0));
        sb.append(this.name).append('=');
        if (this.wrapped) {
            sb.append('\"').append(this.value).append('\"');
        } else {
            sb.append(this.value);
        }
        if (this.domain != null) {
            sb.append(ENCODED_LABEL_DOMAIN);
            sb.append(this.domain);
        }
        if (this.path != null) {
            sb.append(ENCODED_LABEL_PATH);
            sb.append(this.path);
        }
        if (this.expires != null) {
            sb.append(ENCODED_LABEL_EXPIRES);
            sb.append(this.expires);
        }
        if (this.maxAge != null) {
            sb.append(ENCODED_LABEL_MAX_AGE);
            sb.append(this.maxAge);
        }
        if (this.sameSite != null) {
            sb.append(ENCODED_LABEL_SAMESITE);
            sb.append((Object)this.sameSite);
        }
        if (this.httpOnly) {
            sb.append(ENCODED_LABEL_HTTP_ONLY);
        }
        if (this.secure) {
            sb.append(ENCODED_LABEL_SECURE);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpSetCookie)) {
            return false;
        }
        HttpSetCookie rhs = (HttpSetCookie)o;
        return CharSequences.contentEquals((CharSequence)this.name, (CharSequence)rhs.name()) && CharSequences.contentEquals((CharSequence)this.value, (CharSequence)rhs.value()) && CharSequences.contentEqualsIgnoreCase((CharSequence)this.domain, (CharSequence)rhs.domain()) && CharSequences.contentEquals((CharSequence)this.path, (CharSequence)rhs.path());
    }

    public int hashCode() {
        int hash = 31 + CharSequences.caseInsensitiveHashCode((CharSequence)this.name);
        hash = 31 * hash + CharSequences.caseInsensitiveHashCode((CharSequence)this.value);
        if (this.domain != null) {
            hash = 31 * hash + CharSequences.caseInsensitiveHashCode((CharSequence)this.domain);
        }
        if (this.path != null) {
            hash = 31 * hash + CharSequences.caseInsensitiveHashCode((CharSequence)this.path);
        }
        return hash;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.name + ']';
    }

    @Nullable
    private static HttpSetCookie.SameSite fromSequence(CharSequence cs, int begin, int end) {
        switch (end - begin) {
            case 3: {
                if (!CharSequences.equalsIgnoreCaseLower((char)cs.charAt(begin), (char)'l') || !CharSequences.equalsIgnoreCaseLower((char)cs.charAt(begin + 1), (char)'a') || !CharSequences.equalsIgnoreCaseLower((char)cs.charAt(begin + 2), (char)'x')) break;
                return HttpSetCookie.SameSite.Lax;
            }
            case 4: {
                if (!CharSequences.equalsIgnoreCaseLower((char)cs.charAt(begin), (char)'n') || !CharSequences.equalsIgnoreCaseLower((char)cs.charAt(begin + 1), (char)'o') || !CharSequences.equalsIgnoreCaseLower((char)cs.charAt(begin + 2), (char)'n') || !CharSequences.equalsIgnoreCaseLower((char)cs.charAt(begin + 3), (char)'e')) break;
                return HttpSetCookie.SameSite.None;
            }
            case 6: {
                if (!CharSequences.equalsIgnoreCaseLower((char)cs.charAt(begin), (char)'s') || !CharSequences.equalsIgnoreCaseLower((char)cs.charAt(begin + 1), (char)'t') || !CharSequences.equalsIgnoreCaseLower((char)cs.charAt(begin + 2), (char)'r') || !CharSequences.equalsIgnoreCaseLower((char)cs.charAt(begin + 3), (char)'i') || !CharSequences.equalsIgnoreCaseLower((char)cs.charAt(begin + 4), (char)'c') || !CharSequences.equalsIgnoreCaseLower((char)cs.charAt(begin + 5), (char)'t')) break;
                return HttpSetCookie.SameSite.Strict;
            }
        }
        return null;
    }

    private static void extractAndValidateCookieHexValue(CharSequence cookieHeaderValue, int i) {
        if (cookieHeaderValue.length() - 3 <= i) {
            throw new IllegalArgumentException("invalid hex encoded value");
        }
        char c2 = cookieHeaderValue.charAt(i + 1);
        if (c2 != 'X' && c2 != 'x') {
            throw new IllegalArgumentException("unexpected hex indicator " + c2);
        }
        c2 = cookieHeaderValue.charAt(i + 2);
        char c3 = cookieHeaderValue.charAt(i + 3);
        int hexValue = (c2 - 48) * 16 + DefaultHttpSetCookie.hexToDecimal(c3);
        DefaultHttpSetCookie.validateCookieOctetHexValue(hexValue);
    }

    private static void validateCookieOctetHexValue(int hexValue) {
        if (!(hexValue == 33 || hexValue >= 35 && hexValue <= 43 || hexValue >= 45 && hexValue <= 58 || hexValue >= 60 && hexValue <= 91 || hexValue >= 93 && hexValue <= 126)) {
            throw new IllegalArgumentException("unexpected hex value " + hexValue);
        }
    }

    private static int hexToDecimal(char c) {
        return c >= '0' && c <= '9' ? c - 48 : (c >= 'a' && c <= 'f' ? c - 97 + 10 : (c >= 'A' && c < 'F' ? c - 65 + 10 : -1));
    }

    static {
        AV_FIELD_NAMES.add(CharSequences.newAsciiString((String)"path"), (CharSequence)new ParseStateCharSequence(ParseState.ParsingPath));
        AV_FIELD_NAMES.add(CharSequences.newAsciiString((String)"domain"), (CharSequence)new ParseStateCharSequence(ParseState.ParsingDomain));
        AV_FIELD_NAMES.add(CharSequences.newAsciiString((String)"expires"), (CharSequence)new ParseStateCharSequence(ParseState.ParsingExpires));
        AV_FIELD_NAMES.add(CharSequences.newAsciiString((String)"max-age"), (CharSequence)new ParseStateCharSequence(ParseState.ParsingMaxAge));
        AV_FIELD_NAMES.add(CharSequences.newAsciiString((String)"samesite"), (CharSequence)new ParseStateCharSequence(ParseState.ParsingSameSite));
    }

    private static final class ParseStateCharSequence
    implements CharSequence {
        final ParseState state;

        ParseStateCharSequence(ParseState state) {
            this.state = state;
        }

        @Override
        public int length() {
            throw new UnsupportedOperationException();
        }

        @Override
        public char charAt(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            throw new UnsupportedOperationException();
        }
    }

    private static enum ParseState {
        ParsingValue,
        ParsingPath,
        ParsingDomain,
        ParsingExpires,
        ParsingMaxAge,
        ParsingSameSite,
        Unknown;

    }
}

