/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Test;
import org.junit.runner.Runner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.parameterized.BlockJUnit4ClassRunnerWithParameters;
import org.junit.runners.parameterized.ParametersRunnerFactory;
import org.junit.runners.parameterized.TestWithParameters;

public final class MixinAwareParametersRunnerFactory
implements ParametersRunnerFactory {
    public Runner createRunnerForTestWithParameters(TestWithParameters testWithParameters) throws InitializationError {
        return new MixinAwareRunnerWithParameters(testWithParameters);
    }

    private static final class MixinAwareRunnerWithParameters
    extends BlockJUnit4ClassRunnerWithParameters {
        private MixinAwareRunnerWithParameters(TestWithParameters test) throws InitializationError {
            super(test);
        }

        protected List<FrameworkMethod> computeTestMethods() {
            Stream classMethods = super.computeTestMethods().stream();
            Stream<FrameworkMethod> interfaceMethods = Stream.of(this.getTestClass().getJavaClass().getInterfaces()).flatMap(c -> Stream.of(c.getMethods())).filter(m -> m.getAnnotation(Test.class) != null && m.isDefault()).map(FrameworkMethod::new);
            return Stream.concat(classMethods, interfaceMethods).collect(Collectors.toList());
        }
    }
}

