/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.http.api.BlockingStreamingHttpResponse;
import io.servicetalk.http.api.HttpCookiePair;
import io.servicetalk.http.api.HttpDeserializer;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpResponse;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.http.api.HttpSerializer;
import io.servicetalk.http.api.HttpSetCookie;
import io.servicetalk.http.api.TrailersTransformer;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public interface StreamingHttpResponse
extends HttpResponseMetaData {
    public Publisher<Buffer> payloadBody();

    default public <T> Publisher<T> payloadBody(HttpDeserializer<T> deserializer) {
        return deserializer.deserialize(this.headers(), this.payloadBody());
    }

    public Publisher<Object> payloadBodyAndTrailers();

    public StreamingHttpResponse payloadBody(Publisher<Buffer> var1);

    public <T> StreamingHttpResponse payloadBody(Publisher<T> var1, HttpSerializer<T> var2);

    public <T> StreamingHttpResponse transformPayloadBody(Function<Publisher<Buffer>, Publisher<T>> var1, HttpSerializer<T> var2);

    default public <T, R> StreamingHttpResponse transformPayloadBody(Function<Publisher<T>, Publisher<R>> transformer, HttpDeserializer<T> deserializer, HttpSerializer<R> serializer) {
        return this.transformPayloadBody(bufferPublisher -> (Publisher)transformer.apply(deserializer.deserialize(this.headers(), (Publisher<Buffer>)bufferPublisher)), serializer);
    }

    public StreamingHttpResponse transformPayloadBody(UnaryOperator<Publisher<Buffer>> var1);

    public StreamingHttpResponse transformRawPayloadBody(UnaryOperator<Publisher<?>> var1);

    public <T> StreamingHttpResponse transform(TrailersTransformer<T, Buffer> var1);

    public <T> StreamingHttpResponse transformRaw(TrailersTransformer<T, Object> var1);

    public Single<HttpResponse> toResponse();

    public BlockingStreamingHttpResponse toBlockingStreamingResponse();

    @Override
    public StreamingHttpResponse version(HttpProtocolVersion var1);

    @Override
    public StreamingHttpResponse encoding(ContentCodec var1);

    @Override
    default public StreamingHttpResponse addHeader(CharSequence name, CharSequence value) {
        HttpResponseMetaData.super.addHeader(name, value);
        return this;
    }

    @Override
    default public StreamingHttpResponse addHeaders(HttpHeaders headers) {
        HttpResponseMetaData.super.addHeaders(headers);
        return this;
    }

    @Override
    default public StreamingHttpResponse setHeader(CharSequence name, CharSequence value) {
        HttpResponseMetaData.super.setHeader(name, value);
        return this;
    }

    @Override
    default public StreamingHttpResponse setHeaders(HttpHeaders headers) {
        HttpResponseMetaData.super.setHeaders(headers);
        return this;
    }

    @Override
    default public StreamingHttpResponse addCookie(HttpCookiePair cookie) {
        HttpResponseMetaData.super.addCookie(cookie);
        return this;
    }

    @Override
    default public StreamingHttpResponse addCookie(CharSequence name, CharSequence value) {
        HttpResponseMetaData.super.addCookie(name, value);
        return this;
    }

    @Override
    default public StreamingHttpResponse addSetCookie(HttpSetCookie cookie) {
        HttpResponseMetaData.super.addSetCookie(cookie);
        return this;
    }

    @Override
    default public StreamingHttpResponse addSetCookie(CharSequence name, CharSequence value) {
        HttpResponseMetaData.super.addSetCookie(name, value);
        return this;
    }
}

