/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.client.api.AutoRetryStrategyProvider;
import io.servicetalk.client.api.ConnectionFactoryFilter;
import io.servicetalk.client.api.ServiceDiscoverer;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.http.api.BaseHttpBuilder;
import io.servicetalk.http.api.BlockingHttpClient;
import io.servicetalk.http.api.BlockingStreamingHttpClient;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpClient;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpLoadBalancerFactory;
import io.servicetalk.http.api.HttpProtocolConfig;
import io.servicetalk.http.api.ServiceDiscoveryRetryStrategy;
import io.servicetalk.http.api.StrategyInfluencerAwareConversions;
import io.servicetalk.http.api.StreamingHttpClient;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.transport.api.IoExecutor;
import java.net.SocketOption;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;

abstract class HttpClientBuilder<U, R, SDE extends ServiceDiscovererEvent<R>>
extends BaseHttpBuilder<R> {
    HttpClientBuilder() {
    }

    public abstract HttpClientBuilder<U, R, SDE> ioExecutor(IoExecutor var1);

    public abstract HttpClientBuilder<U, R, SDE> executionStrategy(HttpExecutionStrategy var1);

    public abstract HttpClientBuilder<U, R, SDE> bufferAllocator(BufferAllocator var1);

    public abstract <T> HttpClientBuilder<U, R, SDE> socketOption(SocketOption<T> var1, T var2);

    @Deprecated
    public abstract HttpClientBuilder<U, R, SDE> enableWireLogging(String var1);

    public abstract HttpClientBuilder<U, R, SDE> enableWireLogging(String var1, LogLevel var2, BooleanSupplier var3);

    public abstract HttpClientBuilder<U, R, SDE> protocols(HttpProtocolConfig ... var1);

    public abstract HttpClientBuilder<U, R, SDE> appendConnectionFilter(StreamingHttpConnectionFilterFactory var1);

    public HttpClientBuilder<U, R, SDE> appendConnectionFilter(Predicate<StreamingHttpRequest> predicate, StreamingHttpConnectionFilterFactory factory) {
        super.appendConnectionFilter(predicate, factory);
        return this;
    }

    public abstract HttpClientBuilder<U, R, SDE> appendConnectionFactoryFilter(ConnectionFactoryFilter<R, FilterableStreamingHttpConnection> var1);

    public abstract HttpClientBuilder<U, R, SDE> appendClientFilter(StreamingHttpClientFilterFactory var1);

    public HttpClientBuilder<U, R, SDE> appendClientFilter(Predicate<StreamingHttpRequest> predicate, StreamingHttpClientFilterFactory factory) {
        return this.appendClientFilter(StrategyInfluencerAwareConversions.toConditionalClientFilterFactory(predicate, factory));
    }

    public abstract HttpClientBuilder<U, R, SDE> disableHostHeaderFallback();

    public abstract HttpClientBuilder<U, R, SDE> unresolvedAddressToHost(Function<U, CharSequence> var1);

    public abstract HttpClientBuilder<U, R, SDE> autoRetryStrategy(AutoRetryStrategyProvider var1);

    public abstract HttpClientBuilder<U, R, SDE> serviceDiscoverer(ServiceDiscoverer<U, R, SDE> var1);

    public abstract HttpClientBuilder<U, R, SDE> retryServiceDiscoveryErrors(ServiceDiscoveryRetryStrategy<R, SDE> var1);

    public abstract HttpClientBuilder<U, R, SDE> loadBalancerFactory(HttpLoadBalancerFactory<R> var1);

    public abstract StreamingHttpClient buildStreaming();

    public final HttpClient build() {
        return this.buildStreaming().asClient();
    }

    public final BlockingStreamingHttpClient buildBlockingStreaming() {
        return this.buildStreaming().asBlockingStreamingClient();
    }

    public final BlockingHttpClient buildBlocking() {
        return this.buildStreaming().asBlockingClient();
    }
}

