/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.http.api.AbstractDelegatingHttpResponse;
import io.servicetalk.http.api.BlockingStreamingHttpResponse;
import io.servicetalk.http.api.DefaultPayloadInfo;
import io.servicetalk.http.api.DefaultStreamingHttpResponse;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpResponse;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.HttpSerializer;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.TrailersTransformer;
import java.util.Objects;
import javax.annotation.Nullable;

final class DefaultHttpResponse
extends AbstractDelegatingHttpResponse
implements HttpResponse,
TrailersTransformer<Object, Buffer> {
    private Buffer payloadBody;
    @Nullable
    private HttpHeaders trailers;

    DefaultHttpResponse(DefaultStreamingHttpResponse original, Buffer payloadBody, @Nullable HttpHeaders trailers) {
        super(original);
        this.payloadBody = payloadBody;
        this.trailers = trailers;
    }

    @Override
    public HttpResponse version(HttpProtocolVersion version) {
        this.original.version(version);
        return this;
    }

    @Override
    public HttpResponse encoding(ContentCodec encoding) {
        this.original.encoding(encoding);
        return this;
    }

    @Override
    public HttpResponse status(HttpResponseStatus status) {
        this.original.status(status);
        return this;
    }

    @Override
    public Buffer payloadBody() {
        return this.payloadBody;
    }

    @Override
    public HttpResponse payloadBody(Buffer payloadBody) {
        this.payloadBody = Objects.requireNonNull(payloadBody);
        this.original.payloadBody((Publisher<Buffer>)Publisher.from((Object)payloadBody));
        return this;
    }

    @Override
    public <T> HttpResponse payloadBody(T pojo, HttpSerializer<T> serializer) {
        this.payloadBody = serializer.serialize(this.headers(), pojo, this.original.payloadHolder().allocator());
        this.original.payloadBody((Publisher<Buffer>)Publisher.from((Object)this.payloadBody));
        return this;
    }

    @Override
    public StreamingHttpResponse toStreamingResponse() {
        Publisher payload = this.trailers != null ? Publisher.from((Object[])new Object[]{this.payloadBody, this.trailers}) : Publisher.from((Object)this.payloadBody);
        return new DefaultStreamingHttpResponse(this.status(), this.version(), this.headers(), this.original.payloadHolder().allocator(), payload, new DefaultPayloadInfo(this), this.original.payloadHolder().headersFactory());
    }

    @Override
    public BlockingStreamingHttpResponse toBlockingStreamingResponse() {
        return this.original.toBlockingStreamingResponse();
    }

    @Override
    public HttpHeaders trailers() {
        if (this.trailers == null) {
            this.trailers = this.original.payloadHolder().headersFactory().newTrailers();
            this.original.transform(this);
        }
        return this.trailers;
    }

    @Override
    public Object newState() {
        return null;
    }

    @Override
    public Buffer accept(Object __, Buffer buffer) {
        return buffer;
    }

    @Override
    public HttpHeaders payloadComplete(Object __, HttpHeaders extTrailers) {
        return this.trailers == null ? extTrailers : this.trailers;
    }

    @Override
    public HttpHeaders catchPayloadFailure(Object __, Throwable cause, HttpHeaders ___) throws Throwable {
        throw cause;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultHttpResponse that = (DefaultHttpResponse)o;
        if (!this.payloadBody.equals((Object)that.payloadBody)) {
            return false;
        }
        return this.trailers != null ? this.trailers.equals(that.trailers) : that.trailers == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.payloadBody.hashCode();
        result = 31 * result + (this.trailers != null ? this.trailers.hashCode() : 0);
        return result;
    }
}

