/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.http.api.CharSequences;
import io.servicetalk.http.api.HeaderUtils;
import io.servicetalk.http.api.HttpCookiePair;

public final class DefaultHttpCookiePair
implements HttpCookiePair {
    private final CharSequence name;
    private final CharSequence value;
    private final boolean isWrapped;

    public DefaultHttpCookiePair(CharSequence cookieName, CharSequence cookieValue) {
        this(cookieName, cookieValue, false);
    }

    public DefaultHttpCookiePair(CharSequence cookieName, CharSequence cookieValue, boolean isWrapped) {
        HeaderUtils.validateCookieNameAndValue(cookieName, cookieValue);
        this.name = cookieName;
        this.value = cookieValue;
        this.isWrapped = isWrapped;
    }

    static HttpCookiePair parseCookiePair(CharSequence sequence, int nameStart, int valueEnd) {
        return DefaultHttpCookiePair.parseCookiePair(sequence, nameStart, CharSequences.indexOf(sequence, '=', nameStart) - nameStart, valueEnd);
    }

    static HttpCookiePair parseCookiePair(CharSequence sequence, int nameStart, int nameLength, int valueEnd) {
        return DefaultHttpCookiePair.parseCookiePair0(sequence, nameStart, nameLength, valueEnd < 0 ? sequence.length() : valueEnd);
    }

    private static HttpCookiePair parseCookiePair0(CharSequence sequence, int nameStart, int nameLength, int valueEnd) {
        int valueStart = nameStart + nameLength + 1;
        if (valueEnd <= valueStart || valueStart < 0) {
            throw new IllegalArgumentException("value indexes are invalid. valueStart: " + valueStart + " valueEnd: " + valueEnd);
        }
        if (sequence.charAt(valueStart) == '\"' && sequence.charAt(valueEnd - 1) == '\"') {
            if (valueEnd - 2 <= valueStart) {
                throw new IllegalArgumentException("double quote exists but value empty");
            }
            return new DefaultHttpCookiePair(sequence.subSequence(nameStart, valueStart - 1), sequence.subSequence(valueStart + 1, valueEnd - 1), true);
        }
        return new DefaultHttpCookiePair(sequence.subSequence(nameStart, valueStart - 1), sequence.subSequence(valueStart, valueEnd), false);
    }

    @Override
    public CharSequence name() {
        return this.name;
    }

    @Override
    public CharSequence value() {
        return this.value;
    }

    @Override
    public boolean isWrapped() {
        return this.isWrapped;
    }

    @Override
    public CharSequence encoded() {
        StringBuilder sb = new StringBuilder(this.name.length() + this.value.length() + 1 + (this.isWrapped ? 2 : 0));
        sb.append(this.name).append('=');
        if (this.isWrapped) {
            sb.append('\"').append(this.value).append('\"');
        } else {
            sb.append(this.value);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof HttpCookiePair)) {
            return false;
        }
        HttpCookiePair rhs = (HttpCookiePair)o;
        return CharSequences.contentEqualsIgnoreCase(this.name, rhs.name()) && CharSequences.contentEqualsIgnoreCase(this.value, rhs.value());
    }

    public int hashCode() {
        int hash = 31 + CharSequences.caseInsensitiveHashCode(this.name);
        hash = 31 * hash + CharSequences.caseInsensitiveHashCode(this.value);
        return hash;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.name + "]";
    }
}

