/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.CloseableIterable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.http.api.AbstractDelegatingHttpResponse;
import io.servicetalk.http.api.BlockingStreamingHttpResponse;
import io.servicetalk.http.api.DefaultStreamingHttpResponse;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpResponse;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.HttpSerializer;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.TrailersTransformer;
import java.io.InputStream;
import java.util.function.Function;
import java.util.function.UnaryOperator;

final class DefaultBlockingStreamingHttpResponse
extends AbstractDelegatingHttpResponse
implements BlockingStreamingHttpResponse {
    DefaultBlockingStreamingHttpResponse(DefaultStreamingHttpResponse original) {
        super(original);
    }

    @Override
    public BlockingIterable<Buffer> payloadBody() {
        return this.original.payloadBody().toIterable();
    }

    @Override
    public BlockingStreamingHttpResponse payloadBody(Iterable<Buffer> payloadBody) {
        this.original.payloadBody((Publisher<Buffer>)Publisher.fromIterable(payloadBody));
        return this;
    }

    @Override
    public BlockingStreamingHttpResponse payloadBody(CloseableIterable<Buffer> payloadBody) {
        this.original.payloadBody((Publisher<Buffer>)Publisher.fromIterable(payloadBody));
        return this;
    }

    @Override
    public BlockingStreamingHttpResponse payloadBody(InputStream payloadBody) {
        this.original.payloadBody((Publisher<Buffer>)Publisher.fromInputStream((InputStream)payloadBody).map(bytes -> this.original.payloadHolder().allocator().wrap(bytes)));
        return this;
    }

    @Override
    public <T> BlockingStreamingHttpResponse payloadBody(Iterable<T> payloadBody, HttpSerializer<T> serializer) {
        this.original.payloadBody(Publisher.fromIterable(payloadBody), serializer);
        return this;
    }

    @Override
    public <T> BlockingStreamingHttpResponse payloadBody(CloseableIterable<T> payloadBody, HttpSerializer<T> serializer) {
        this.original.payloadBody(Publisher.fromIterable(payloadBody), serializer);
        return this;
    }

    @Override
    public <T> BlockingStreamingHttpResponse transformPayloadBody(Function<BlockingIterable<Buffer>, BlockingIterable<T>> transformer, HttpSerializer<T> serializer) {
        this.original.transformPayloadBody((Publisher<Buffer> bufferPublisher) -> Publisher.fromIterable((Iterable)((Iterable)transformer.apply(bufferPublisher.toIterable()))), serializer);
        return this;
    }

    @Override
    public BlockingStreamingHttpResponse transformPayloadBody(UnaryOperator<BlockingIterable<Buffer>> transformer) {
        this.original.transformPayloadBody(bufferPublisher -> Publisher.fromIterable((Iterable)((Iterable)transformer.apply(bufferPublisher.toIterable()))));
        return this;
    }

    @Override
    public BlockingStreamingHttpResponse transformRawPayloadBody(UnaryOperator<BlockingIterable<?>> transformer) {
        this.original.transformRawPayloadBody(bufferPublisher -> Publisher.fromIterable((Iterable)((Iterable)transformer.apply(bufferPublisher.toIterable()))));
        return this;
    }

    @Override
    public <T> BlockingStreamingHttpResponse transform(TrailersTransformer<T, Buffer> trailersTransformer) {
        this.original.transform(trailersTransformer);
        return this;
    }

    @Override
    public <T> BlockingStreamingHttpResponse transformRaw(TrailersTransformer<T, Object> trailersTransformer) {
        this.original.transformRaw(trailersTransformer);
        return this;
    }

    @Override
    public Single<HttpResponse> toResponse() {
        return this.toStreamingResponse().toResponse();
    }

    @Override
    public StreamingHttpResponse toStreamingResponse() {
        return this.original;
    }

    @Override
    public BlockingStreamingHttpResponse version(HttpProtocolVersion version) {
        this.original.version(version);
        return this;
    }

    @Override
    public BlockingStreamingHttpResponse encoding(ContentCodec encoding) {
        this.original.encoding(encoding);
        return this;
    }

    @Override
    public BlockingStreamingHttpResponse status(HttpResponseStatus status) {
        this.original.status(status);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultBlockingStreamingHttpResponse that = (DefaultBlockingStreamingHttpResponse)o;
        return this.original.equals(that.original);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.original.hashCode();
        return result;
    }
}

