/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.http.api.HttpCookiePair;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpMetaData;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpSetCookie;
import io.servicetalk.transport.api.HostAndPort;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public interface HttpRequestMetaData
extends HttpMetaData {
    public HttpRequestMethod method();

    public HttpRequestMetaData method(HttpRequestMethod var1);

    public String requestTarget();

    public String requestTarget(Charset var1);

    public HttpRequestMetaData requestTarget(String var1);

    public HttpRequestMetaData requestTarget(String var1, Charset var2);

    @Nullable
    public String scheme();

    @Nullable
    public String userInfo();

    @Nullable
    public String host();

    public int port();

    public String rawPath();

    public String path();

    public HttpRequestMetaData rawPath(String var1);

    public HttpRequestMetaData path(String var1);

    public HttpRequestMetaData appendPathSegments(String ... var1);

    @Nullable
    public String rawQuery();

    @Nullable
    public String query();

    public HttpRequestMetaData rawQuery(@Nullable String var1);

    public HttpRequestMetaData query(@Nullable String var1);

    @Nullable
    public String queryParameter(String var1);

    public Iterable<Map.Entry<String, String>> queryParameters();

    public Iterable<String> queryParameters(String var1);

    public Iterator<String> queryParametersIterator(String var1);

    public Set<String> queryParametersKeys();

    default public boolean hasQueryParameter(String key) {
        return this.queryParameter(key) != null;
    }

    public boolean hasQueryParameter(String var1, String var2);

    public int queryParametersSize();

    public HttpRequestMetaData addQueryParameter(String var1, String var2);

    public HttpRequestMetaData addQueryParameters(String var1, Iterable<String> var2);

    public HttpRequestMetaData addQueryParameters(String var1, String ... var2);

    public HttpRequestMetaData setQueryParameter(String var1, String var2);

    public HttpRequestMetaData setQueryParameters(String var1, Iterable<String> var2);

    public HttpRequestMetaData setQueryParameters(String var1, String ... var2);

    public boolean removeQueryParameters(String var1);

    public boolean removeQueryParameters(String var1, String var2);

    @Deprecated
    @Nullable
    default public String effectiveHost() {
        HostAndPort hostAndPort = this.effectiveHostAndPort();
        return hostAndPort == null ? null : hostAndPort.hostName();
    }

    @Deprecated
    default public int effectivePort() {
        HostAndPort hostAndPort = this.effectiveHostAndPort();
        return hostAndPort == null ? -1 : hostAndPort.port();
    }

    @Nullable
    public HostAndPort effectiveHostAndPort();

    @Override
    public HttpRequestMetaData version(HttpProtocolVersion var1);

    @Override
    default public HttpRequestMetaData addHeader(CharSequence name, CharSequence value) {
        HttpMetaData.super.addHeader(name, value);
        return this;
    }

    @Override
    default public HttpRequestMetaData addHeaders(HttpHeaders headers) {
        HttpMetaData.super.addHeaders(headers);
        return this;
    }

    @Override
    default public HttpRequestMetaData setHeader(CharSequence name, CharSequence value) {
        HttpMetaData.super.setHeader(name, value);
        return this;
    }

    @Override
    default public HttpRequestMetaData setHeaders(HttpHeaders headers) {
        HttpMetaData.super.setHeaders(headers);
        return this;
    }

    @Override
    default public HttpRequestMetaData addCookie(HttpCookiePair cookie) {
        HttpMetaData.super.addCookie(cookie);
        return this;
    }

    @Override
    default public HttpRequestMetaData addCookie(CharSequence name, CharSequence value) {
        HttpMetaData.super.addCookie(name, value);
        return this;
    }

    @Override
    default public HttpRequestMetaData addSetCookie(HttpSetCookie cookie) {
        HttpMetaData.super.addSetCookie(cookie);
        return this;
    }

    @Override
    default public HttpRequestMetaData addSetCookie(CharSequence name, CharSequence value) {
        HttpMetaData.super.addSetCookie(name, value);
        return this;
    }
}

