/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;

final class HttpUri {
    private static final String SPACE = " ";
    static final String HTTP_SCHEME = "http";
    static final String HTTPS_SCHEME = "https";
    static final int HTTP_DEFAULT_PORT = 80;
    static final int HTTPS_DEFAULT_PORT = 443;
    private final String uri;
    @Nullable
    private final String hostHeader;
    private final String relativeReference;
    private final boolean ssl;
    @Nullable
    private final String scheme;
    @Nullable
    private String userInfo;
    @Nullable
    private final String host;
    private final int port;
    private final boolean explicitPort;
    @Nullable
    private String rawPath;
    @Nullable
    private String path;
    @Nullable
    private String rawQuery;

    HttpUri(String uri) throws IllegalArgumentException {
        this(uri, () -> null);
    }

    HttpUri(String uri, Supplier<String> defaultHostHeader) throws IllegalArgumentException {
        int begin = 0;
        int lastColon = -1;
        int ipliteral = -1;
        String parsedHost = null;
        String parsedHostHeader = null;
        int parsedPort = -1;
        int parsedScheme = -1;
        int relativeReferenceStart = -1;
        boolean authorityFound = false;
        int i = 0;
        while (i < uri.length()) {
            char c = uri.charAt(i);
            if (c == '/') {
                if (i - 1 > 0 && i + 1 < uri.length() && uri.charAt(i - 1) == ':' && uri.charAt(i + 1) == '/') {
                    if (parsedScheme != -1) {
                        throw new IllegalArgumentException("duplicate scheme");
                    }
                    if (i == 5 && uri.regionMatches(true, 0, HTTP_SCHEME, 0, 4)) {
                        parsedScheme = 0;
                    } else if (i == 6 && uri.regionMatches(true, 0, HTTPS_SCHEME, 0, 5)) {
                        parsedScheme = 1;
                    } else {
                        throw new IllegalArgumentException("unsupported scheme");
                    }
                    begin = i += 2;
                    lastColon = -1;
                    continue;
                }
                if (begin != 0) {
                    relativeReferenceStart = i;
                    break;
                }
                if (uri.length() <= 1 || uri.charAt(0) != '/' || uri.charAt(1) != '/') break;
                begin = 2;
                i = 3;
                continue;
            }
            if (c == '?' || c == '#') {
                relativeReferenceStart = begin == 0 ? 0 : i;
                break;
            }
            if (c == '@') {
                if (begin == 0 || parsedScheme < 0 && uri.charAt(begin - 1) == '/') {
                    HttpUri.invalidAuthority();
                }
                this.userInfo = uri.substring(begin, i);
                begin = ++i;
                lastColon = -1;
                continue;
            }
            if (c == '[') {
                if (ipliteral != -1) {
                    throw new IllegalArgumentException("unexpected [");
                }
                ipliteral = 0;
                ++i;
                continue;
            }
            if (c == ']') {
                if (ipliteral != 0) {
                    throw new IllegalArgumentException("unexpected ]");
                }
                ipliteral = i++;
                continue;
            }
            if (c == ':') {
                lastColon = i++;
                continue;
            }
            ++i;
        }
        if (lastColon > ipliteral) {
            parsedPort = HttpUri.parsePort(uri, lastColon + 1, i);
            parsedHost = uri.substring(begin, lastColon);
            parsedHostHeader = uri.substring(begin, i);
            authorityFound = true;
        } else if (begin != i && (begin > 1 && uri.charAt(begin - 1) == '/' && uri.charAt(begin - 2) == '/' || begin > 0 && uri.charAt(begin - 1) == '@')) {
            if (i > uri.length() || parsedScheme < 0 && uri.charAt(begin) == '@' && uri.charAt(begin - 1) == '/') {
                HttpUri.invalidAuthority();
            }
            parsedHostHeader = parsedHost = uri.substring(begin, i);
            authorityFound = true;
        } else {
            if (relativeReferenceStart < 0) {
                relativeReferenceStart = 0;
            }
            if ((parsedHostHeader = defaultHostHeader.get()) != null) {
                int x = parsedHostHeader.lastIndexOf(58);
                if (x > 0) {
                    int y = parsedHostHeader.lastIndexOf(58, x - 1);
                    if (y >= 0) {
                        int cb;
                        if (parsedHostHeader.charAt(0) != '[' || (cb = parsedHostHeader.lastIndexOf(93)) < 0) {
                            throw new IllegalArgumentException("IPv6 address should be in square brackets");
                        }
                        if (cb < x) {
                            parsedHost = parsedHostHeader.substring(0, x);
                            parsedPort = HttpUri.parsePort(parsedHostHeader, x + 1, parsedHostHeader.length());
                        } else {
                            if (cb != parsedHostHeader.length() - 1) {
                                throw new IllegalArgumentException("']' should be at the end of IPv6 address or before port number");
                            }
                            parsedHost = parsedHostHeader;
                        }
                    } else {
                        parsedHost = parsedHostHeader.substring(0, x);
                        parsedPort = HttpUri.parsePort(parsedHostHeader, x + 1, parsedHostHeader.length());
                    }
                } else if (x < 0) {
                    parsedHost = parsedHostHeader;
                } else {
                    throw new IllegalArgumentException("Illegal position of colon in the host header");
                }
            }
        }
        if (relativeReferenceStart == 0 || begin == 0 && i == uri.length()) {
            if (authorityFound || "*".equals(uri)) {
                this.relativeReference = "";
            } else {
                HttpUri.verifyFirstPathSegment(uri, 0);
                this.relativeReference = uri;
            }
        } else if (relativeReferenceStart > 0) {
            HttpUri.verifyFirstPathSegment(uri, relativeReferenceStart);
            this.relativeReference = uri.substring(relativeReferenceStart);
        } else {
            this.relativeReference = "";
        }
        this.scheme = parsedScheme == 0 ? HTTP_SCHEME : (parsedScheme == 1 ? HTTPS_SCHEME : null);
        this.host = parsedHost;
        this.hostHeader = parsedHostHeader;
        boolean bl = this.ssl = parsedScheme == 1;
        this.port = parsedPort > 0 ? parsedPort : (this.ssl ? 443 : 80);
        this.explicitPort = parsedPort > 0;
        this.uri = uri;
    }

    String uri() {
        return this.uri;
    }

    @Nullable
    String scheme() {
        return this.scheme;
    }

    @Nullable
    String userInfo() {
        return this.userInfo;
    }

    @Nullable
    String host() {
        return this.host;
    }

    int port() {
        return this.port;
    }

    int explicitPort() {
        return this.explicitPort ? this.port : -1;
    }

    String rawPath() {
        if (this.rawPath != null) {
            return this.rawPath;
        }
        if (!this.relativeReference.isEmpty()) {
            int queryStart = this.relativeReference.indexOf(63);
            if (queryStart >= 0) {
                this.rawPath = this.relativeReference.substring(0, queryStart);
                return this.rawPath;
            }
            int fragmentStart = this.relativeReference.indexOf(35);
            if (fragmentStart >= 0) {
                this.rawPath = this.relativeReference.substring(0, fragmentStart);
                return this.rawPath;
            }
        }
        this.rawPath = this.relativeReference;
        return this.rawPath;
    }

    String path() {
        if (this.path == null) {
            String raw = this.rawPath();
            this.path = HttpUri.decodeComponent(raw, 0, raw.length(), true, StandardCharsets.UTF_8);
        }
        return this.path;
    }

    String rawQuery() {
        if (this.rawQuery != null) {
            return this.rawQuery;
        }
        int rawPathLength = this.rawPath().length();
        if (rawPathLength == this.relativeReference.length()) {
            this.rawQuery = "";
            return this.rawQuery;
        }
        int fragmentStart = this.relativeReference.indexOf(35, rawPathLength);
        this.rawQuery = fragmentStart == rawPathLength ? "" : (fragmentStart < 0 ? this.relativeReference.substring(rawPathLength + 1) : this.relativeReference.substring(rawPathLength + 1, fragmentStart));
        return this.rawQuery;
    }

    String relativeReference() {
        return this.relativeReference;
    }

    @Nullable
    String hostHeader() {
        return this.hostHeader;
    }

    boolean isSsl() {
        return this.ssl;
    }

    boolean hostAndPortEqual(HttpUri rhs) {
        return this.port == rhs.port && (this.host == rhs.host || this.host != null && this.host.equals(rhs.host));
    }

    static String buildRequestTarget(String scheme, @Nullable String host, int port, @Nullable String path, @Nullable String query, @Nullable String relativeReference) {
        if (relativeReference == null) {
            assert (path != null);
            assert (query != null);
        }
        int approximateLength = (host == null ? 0 : scheme.length() + 3 + host.length() + (port >= 0 ? 0 : 4)) + (relativeReference != null ? relativeReference.length() : path.length() + 1 + query.length());
        StringBuilder uri = new StringBuilder(approximateLength);
        if (host != null) {
            uri.append(scheme).append("://").append(host);
            if (port >= 0) {
                uri.append(':').append(port);
            }
        }
        if (relativeReference != null) {
            uri.append(relativeReference);
        } else {
            uri.append(path);
            if (!query.isEmpty()) {
                uri.append('?').append(query);
            }
        }
        return uri.toString();
    }

    public boolean equals(Object o) {
        return o instanceof HttpUri && this.hostAndPortEqual((HttpUri)o);
    }

    public int hashCode() {
        return 31 * (31 + this.port + Objects.hashCode(this.host));
    }

    public String toString() {
        return this.uri;
    }

    static String decodeComponent(String s, int from, int toExcluded, boolean isPath, Charset charset) {
        int len = toExcluded - from;
        if (len <= 0) {
            return "";
        }
        int firstEscaped = -1;
        for (int i = from; i < toExcluded; ++i) {
            char c = s.charAt(i);
            if (c != '%' && (c != '+' || isPath)) continue;
            firstEscaped = i;
            break;
        }
        if (firstEscaped == -1) {
            return s.substring(from, toExcluded);
        }
        CharsetDecoder decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        int decodedCapacity = (toExcluded - firstEscaped) / 3;
        ByteBuffer byteBuf = ByteBuffer.allocate(decodedCapacity);
        CharBuffer charBuf = CharBuffer.allocate(decodedCapacity);
        StringBuilder strBuf = new StringBuilder(len);
        strBuf.append(s, from, firstEscaped);
        for (int i = firstEscaped; i < toExcluded; ++i) {
            char c = s.charAt(i);
            if (c != '%') {
                strBuf.append(c != '+' || isPath ? Character.valueOf(c) : SPACE);
                continue;
            }
            byteBuf.clear();
            do {
                if (i + 3 > toExcluded) {
                    throw new IllegalArgumentException("unterminated escape sequence at index " + i + " of: " + s);
                }
                byteBuf.put(HttpUri.decodeHexByte(s, i + 1));
            } while ((i += 3) < toExcluded && s.charAt(i) == '%');
            --i;
            byteBuf.flip();
            charBuf.clear();
            CoderResult result = decoder.reset().decode(byteBuf, charBuf, true);
            try {
                if (!result.isUnderflow()) {
                    result.throwException();
                }
                if (!(result = decoder.flush(charBuf)).isUnderflow()) {
                    result.throwException();
                }
            }
            catch (CharacterCodingException ex) {
                throw new IllegalArgumentException(ex);
            }
            strBuf.append(charBuf.flip());
        }
        return strBuf.toString();
    }

    private static int decodeHexNibble(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 55;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 87;
        }
        return -1;
    }

    private static byte decodeHexByte(CharSequence s, int pos) {
        int hi = HttpUri.decodeHexNibble(s.charAt(pos));
        int lo = HttpUri.decodeHexNibble(s.charAt(pos + 1));
        if (hi == -1 || lo == -1) {
            throw new IllegalArgumentException(String.format("invalid hex byte '%s' at index %d of '%s'", s.subSequence(pos, pos + 2), pos, s));
        }
        return (byte)((hi << 4) + lo);
    }

    private static int parsePort(String uri, int begin, int end) {
        int len = end - begin;
        if (len == 4) {
            return 1000 * HttpUri.toDecimal(uri.charAt(begin)) + 100 * HttpUri.toDecimal(uri.charAt(begin + 1)) + 10 * HttpUri.toDecimal(uri.charAt(begin + 2)) + HttpUri.toDecimal(uri.charAt(begin + 3));
        }
        if (len == 3) {
            return 100 * HttpUri.toDecimal(uri.charAt(begin)) + 10 * HttpUri.toDecimal(uri.charAt(begin + 1)) + HttpUri.toDecimal(uri.charAt(begin + 2));
        }
        if (len == 2) {
            return 10 * HttpUri.toDecimal(uri.charAt(begin)) + HttpUri.toDecimal(uri.charAt(begin + 1));
        }
        if (len == 5) {
            int port = 10000 * HttpUri.toDecimal(uri.charAt(begin)) + 1000 * HttpUri.toDecimal(uri.charAt(begin + 1)) + 100 * HttpUri.toDecimal(uri.charAt(begin + 2)) + 10 * HttpUri.toDecimal(uri.charAt(begin + 3)) + HttpUri.toDecimal(uri.charAt(begin + 4));
            if (port > 65535) {
                throw new IllegalArgumentException("port out of bounds");
            }
            return port;
        }
        if (len == 1) {
            return HttpUri.toDecimal(uri.charAt(begin));
        }
        throw new IllegalArgumentException("invalid port");
    }

    private static int toDecimal(char c) {
        if (c < '0' || c > '9') {
            throw new IllegalArgumentException("invalid port");
        }
        return c - 48;
    }

    private static void verifyFirstPathSegment(String uri, int begin) {
        for (int i = begin + 1; i < uri.length(); ++i) {
            char c = uri.charAt(i);
            if (c == ':') {
                throw new IllegalArgumentException("invalid first path segment: " + uri);
            }
            if (c != '/' && c != '?' && c != '#') continue;
            return;
        }
    }

    private static void invalidAuthority() {
        throw new IllegalArgumentException("authority component must have username and host specified for HTTP");
    }
}

