/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.client.api.DefaultServiceDiscovererEvent;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.client.api.partition.PartitionAttributes;
import io.servicetalk.client.api.partition.PartitionedServiceDiscovererEvent;
import io.servicetalk.concurrent.api.BiIntFunction;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.RetryStrategies;
import io.servicetalk.http.api.ServiceDiscoveryRetryStrategy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;

public final class DefaultServiceDiscoveryRetryStrategy<ResolvedAddress, E extends ServiceDiscovererEvent<ResolvedAddress>>
implements ServiceDiscoveryRetryStrategy<ResolvedAddress, E> {
    private final int retainTillReceivePercentage;
    private final UnaryOperator<E> flipAvailability;
    private final BiIntFunction<Throwable, ? extends Completable> retryStrategy;

    private DefaultServiceDiscoveryRetryStrategy(int retainTillReceivePercentage, UnaryOperator<E> flipAvailability, BiIntFunction<Throwable, ? extends Completable> retryStrategy) {
        this.retainTillReceivePercentage = retainTillReceivePercentage;
        this.flipAvailability = Objects.requireNonNull(flipAvailability);
        this.retryStrategy = Objects.requireNonNull(retryStrategy);
    }

    @Override
    public Publisher<E> apply(Publisher<E> sdEvents) {
        return Publisher.defer(() -> {
            EventsCache eventsCache = new EventsCache(this.retainTillReceivePercentage, this.flipAvailability);
            return sdEvents.flatMapConcatIterable(eventsCache::consume).beforeOnError(__ -> eventsCache.errorSeen()).retryWhen(this.retryStrategy);
        });
    }

    private static final class IndefiniteRetryStrategy
    implements BiIntFunction<Throwable, Completable> {
        private final BiIntFunction<Throwable, Completable> delegate;
        private final int maxRetries;

        IndefiniteRetryStrategy(Executor executor, Duration initialDelay) {
            this(executor, initialDelay, 8);
        }

        IndefiniteRetryStrategy(Executor executor, Duration initialDelay, int maxRetries) {
            this.delegate = RetryStrategies.retryWithExponentialBackoffAndJitter((int)maxRetries, __ -> true, (Duration)initialDelay, (Executor)executor);
            this.maxRetries = maxRetries;
        }

        public Completable apply(int count, Throwable cause) {
            return (Completable)this.delegate.apply(count % this.maxRetries + 1, (Object)cause);
        }
    }

    private static final class EventsCache<R, E extends ServiceDiscovererEvent<R>> {
        private static final Map NONE_RETAINED = Collections.emptyMap();
        private Map<R, E> retainedAddresses = EventsCache.noneRetained();
        private int targetSize;
        private final Map<R, E> activeAddresses = new HashMap<R, E>();
        private final int retainTillReceivePercentage;
        private final UnaryOperator<E> flipAvailability;

        EventsCache(int retainTillReceivePercentage, UnaryOperator<E> flipAvailability) {
            this.retainTillReceivePercentage = retainTillReceivePercentage;
            this.flipAvailability = flipAvailability;
        }

        void errorSeen() {
            if (this.retainedAddresses == NONE_RETAINED) {
                this.retainedAddresses = new HashMap<R, E>(this.activeAddresses);
            } else {
                this.retainedAddresses.putAll(this.activeAddresses);
            }
            this.targetSize = (int)Math.ceil((double)this.retainTillReceivePercentage / 100.0 * (double)this.activeAddresses.size());
            this.activeAddresses.clear();
        }

        Iterable<E> consume(E event) {
            Object address = event.address();
            if (this.retainedAddresses == NONE_RETAINED) {
                if (event.isAvailable()) {
                    this.activeAddresses.put(address, event);
                } else {
                    this.activeAddresses.remove(address);
                }
                return Collections.singletonList(event);
            }
            if (event.isAvailable()) {
                boolean removed;
                this.activeAddresses.put(address, event);
                boolean bl = removed = this.retainedAddresses.remove(address) != null;
                if (this.activeAddresses.size() >= this.targetSize) {
                    ArrayList<Object> allEvents = new ArrayList<Object>(this.retainedAddresses.size() + (removed ? 0 : 1));
                    if (!removed) {
                        allEvents.add(event);
                    }
                    for (ServiceDiscovererEvent removalEvent : this.retainedAddresses.values()) {
                        allEvents.add(this.flipAvailability.apply(removalEvent));
                    }
                    this.retainedAddresses = EventsCache.noneRetained();
                    this.targetSize = 0;
                    return allEvents;
                }
                return removed ? Collections.emptyList() : Collections.singletonList(event);
            }
            this.activeAddresses.remove(address);
            return Collections.singletonList(event);
        }

        private static <R, E extends ServiceDiscovererEvent<R>> Map<R, E> noneRetained() {
            return NONE_RETAINED;
        }
    }

    public static final class Builder<ResolvedAddress, E extends ServiceDiscovererEvent<ResolvedAddress>> {
        private int retainTillReceivePercentage = 75;
        private BiIntFunction<Throwable, ? extends Completable> retryStrategy;
        private final UnaryOperator<E> flipAvailability;

        private Builder(BiIntFunction<Throwable, ? extends Completable> retryStrategy, UnaryOperator<E> flipAvailability) {
            this.retryStrategy = retryStrategy;
            this.flipAvailability = Objects.requireNonNull(flipAvailability);
        }

        public Builder<ResolvedAddress, E> retainAddressesTillSuccess(int retainTillReceivePercentage) {
            if (retainTillReceivePercentage < 0) {
                throw new IllegalArgumentException("retainTillReceivePercentage: " + retainTillReceivePercentage + " (expected >= 0)");
            }
            this.retainTillReceivePercentage = retainTillReceivePercentage;
            return this;
        }

        public Builder<ResolvedAddress, E> retryStrategy(BiIntFunction<Throwable, ? extends Completable> retryStrategy) {
            this.retryStrategy = Objects.requireNonNull(retryStrategy);
            return this;
        }

        public ServiceDiscoveryRetryStrategy<ResolvedAddress, E> build() {
            return new DefaultServiceDiscoveryRetryStrategy(this.retainTillReceivePercentage, this.flipAvailability, this.retryStrategy);
        }

        public static <ResolvedAddress> Builder<ResolvedAddress, ServiceDiscovererEvent<ResolvedAddress>> withDefaults(Executor executor, Duration initialDelay) {
            return new Builder(new IndefiniteRetryStrategy(executor, initialDelay), evt -> new DefaultServiceDiscovererEvent(evt.address(), !evt.isAvailable()));
        }

        public static <ResolvedAddress> Builder<ResolvedAddress, PartitionedServiceDiscovererEvent<ResolvedAddress>> withDefaultsForPartitions(Executor executor, Duration initialDelay) {
            return new Builder(new IndefiniteRetryStrategy(executor, initialDelay), evt -> new PartitionedServiceDiscovererEvent<ResolvedAddress>((PartitionedServiceDiscovererEvent)evt){
                final /* synthetic */ PartitionedServiceDiscovererEvent val$evt;
                {
                    this.val$evt = partitionedServiceDiscovererEvent;
                }

                public PartitionAttributes partitionAddress() {
                    return this.val$evt.partitionAddress();
                }

                public ResolvedAddress address() {
                    return this.val$evt.address();
                }

                public boolean isAvailable() {
                    return !this.val$evt.isAvailable();
                }
            });
        }

        public static <ResolvedAddress, E extends ServiceDiscovererEvent<ResolvedAddress>> Builder<ResolvedAddress, E> withDefaults(Executor executor, Duration initialDelay, UnaryOperator<E> flipAvailability) {
            return new Builder<ResolvedAddress, E>(new IndefiniteRetryStrategy(executor, initialDelay), flipAvailability);
        }
    }
}

