/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.Processors;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.PublisherOperator;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.SourceAdapters;
import io.servicetalk.http.api.DefaultPayloadInfo;
import io.servicetalk.http.api.HeaderUtils;
import io.servicetalk.http.api.HttpDataSourceTransformations;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpHeadersFactory;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpSerializer;
import io.servicetalk.http.api.PayloadInfo;
import io.servicetalk.http.api.TrailersTransformer;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StreamingHttpPayloadHolder
implements PayloadInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamingHttpPayloadHolder.class);
    private final HttpHeaders headers;
    private final BufferAllocator allocator;
    private final DefaultPayloadInfo payloadInfo;
    private final HttpHeadersFactory headersFactory;
    private final HttpProtocolVersion version;
    @Nullable
    private Publisher<?> payloadBody;
    @Nullable
    private Single<HttpHeaders> trailersSingle;

    StreamingHttpPayloadHolder(HttpHeaders headers, BufferAllocator allocator, @Nullable Publisher<?> payloadBody, DefaultPayloadInfo payloadInfo, HttpHeadersFactory headersFactory, HttpProtocolVersion version) {
        this.headers = Objects.requireNonNull(headers);
        this.allocator = Objects.requireNonNull(allocator);
        this.payloadInfo = Objects.requireNonNull(payloadInfo);
        this.headersFactory = Objects.requireNonNull(headersFactory);
        this.version = Objects.requireNonNull(version);
        if (payloadInfo.mayHaveTrailers()) {
            this.payloadBody = payloadBody != null ? payloadBody : Publisher.empty();
        } else if (payloadBody != null) {
            this.payloadBody = StreamingHttpPayloadHolder.filterTrailers(payloadBody);
        }
    }

    Publisher<Buffer> payloadBody() {
        if (this.payloadBody == null) {
            return Publisher.empty();
        }
        this.splitTrailersIfRequired();
        return this.payloadInfo.onlyEmitsBuffer() ? this.bufferPayload() : this.rawPayload().liftSync(HttpDataSourceTransformations.HttpTransportBufferFilterOperator.INSTANCE);
    }

    Publisher<Object> payloadBodyAndTrailers() {
        if (this.payloadInfo.mayHaveTrailers()) {
            assert (this.payloadBody != null);
            return this.trailersSingle == null ? this.rawPayload() : this.rawPayload().concat(this.trailersSingle);
        }
        if (HeaderUtils.isTransferEncodingChunked(this.headers)) {
            return this.payloadBody == null ? Publisher.from((Object)this.headersFactory.newEmptyTrailers()) : this.rawPayload().concat(Single.succeeded((Object)this.headersFactory.newEmptyTrailers()));
        }
        return this.emptyOrRawPayload();
    }

    public void payloadBody(Publisher<Buffer> payloadBody) {
        this.updatePayloadBody(payloadBody, false);
    }

    public <T> void payloadBody(Publisher<T> payloadBody, HttpSerializer<T> serializer) {
        this.payloadBody(serializer.serialize(this.headers, payloadBody, this.allocator));
    }

    public <T> void transformPayloadBody(Function<Publisher<Buffer>, Publisher<T>> transformer, HttpSerializer<T> serializer) {
        this.updatePayloadBody(serializer.serialize(this.headers, transformer.apply(this.payloadBody()), this.allocator), true);
    }

    public void transformPayloadBody(UnaryOperator<Publisher<Buffer>> transformer) {
        this.updatePayloadBody((Publisher<Buffer>)((Publisher)transformer.apply(this.payloadBody())), true);
    }

    public void transformRawPayloadBody(UnaryOperator<Publisher<?>> transformer) {
        if (this.payloadBody != null) {
            this.splitTrailersIfRequired();
        }
        this.payloadBody = (Publisher)transformer.apply(this.emptyOrRawPayload());
    }

    public <T> void transform(TrailersTransformer<T, Buffer> trailersTransformer) {
        this.transformWithTrailersUnchecked(false, trailersTransformer);
    }

    public <T> void transformRaw(TrailersTransformer<T, Object> trailersTransformer) {
        this.transformWithTrailersUnchecked(true, trailersTransformer);
    }

    Single<HttpDataSourceTransformations.PayloadAndTrailers> aggregate() {
        this.payloadInfo.setSafeToAggregate(true);
        return HttpDataSourceTransformations.aggregatePayloadAndTrailers(this.payloadBodyAndTrailers(), this.allocator);
    }

    @Override
    public boolean isSafeToAggregate() {
        return this.payloadInfo.isSafeToAggregate();
    }

    @Override
    public boolean mayHaveTrailers() {
        return this.payloadInfo.mayHaveTrailers();
    }

    @Override
    public boolean onlyEmitsBuffer() {
        return this.payloadInfo.onlyEmitsBuffer();
    }

    BufferAllocator allocator() {
        return this.allocator;
    }

    HttpHeadersFactory headersFactory() {
        return this.headersFactory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamingHttpPayloadHolder that = (StreamingHttpPayloadHolder)o;
        if (!this.headers.equals(that.headers)) {
            return false;
        }
        if (!this.allocator.equals(that.allocator)) {
            return false;
        }
        if (!this.payloadInfo.equals(that.payloadInfo)) {
            return false;
        }
        if (!this.headersFactory.equals(that.headersFactory)) {
            return false;
        }
        if (this.payloadBody != null ? !this.payloadBody.equals(that.payloadBody) : that.payloadBody != null) {
            return false;
        }
        return this.trailersSingle != null ? this.trailersSingle.equals(that.trailersSingle) : that.trailersSingle == null;
    }

    public int hashCode() {
        int result = this.headers.hashCode();
        result = 31 * result + this.allocator.hashCode();
        result = 31 * result + this.payloadInfo.hashCode();
        result = 31 * result + this.headersFactory.hashCode();
        result = 31 * result + (this.payloadBody != null ? this.payloadBody.hashCode() : 0);
        result = 31 * result + (this.trailersSingle != null ? this.trailersSingle.hashCode() : 0);
        return result;
    }

    private void splitTrailersIfRequired() {
        assert (this.payloadBody != null);
        if (this.payloadInfo.mayHaveTrailers() && this.trailersSingle == null) {
            SingleSource.Processor trailersAsProcessor = Processors.newSingleProcessor();
            this.trailersSingle = SourceAdapters.fromSource((SingleSource)trailersAsProcessor);
            this.payloadBody = this.payloadInfo.onlyEmitsBuffer() ? this.bufferPayload().liftSync((PublisherOperator)new HttpDataSourceTransformations.HttpBufferTrailersSpliceOperator((SingleSource.Processor<HttpHeaders, HttpHeaders>)trailersAsProcessor)) : this.rawPayload().liftSync((PublisherOperator)new HttpDataSourceTransformations.HttpObjectTrailersSpliceOperator((SingleSource.Processor<HttpHeaders, HttpHeaders>)trailersAsProcessor));
        }
    }

    private void updatePayloadBody(Publisher<Buffer> newPayload, boolean isTransform) {
        this.payloadBody = this.payloadBody == null || isTransform ? Objects.requireNonNull(newPayload) : newPayload.liftSync((PublisherOperator)new HttpDataSourceTransformations.BridgeFlowControlAndDiscardOperator(this.payloadBody()));
        this.payloadInfo.setOnlyEmitsBuffer(true);
    }

    private void transformWithTrailersUnchecked(boolean raw, final TrailersTransformer trailersTransformer) {
        if (this.payloadBody == null) {
            Object state = trailersTransformer.newState();
            this.trailersSingle = Single.succeeded((Object)trailersTransformer.payloadComplete(state, this.headersFactory.newEmptyTrailers()));
            this.payloadBody = Publisher.empty();
        } else {
            this.splitTrailersIfRequired();
            if (!this.payloadInfo.mayHaveTrailers()) {
                this.trailersSingle = Single.succeeded((Object)this.headersFactory.newEmptyTrailers());
            }
            assert (this.trailersSingle != null);
            final TrailerTransformerState trailerTransformerState = new TrailerTransformerState();
            this.trailersSingle = this.trailersSingle.liftSync(subscriber -> new SingleSource.Subscriber<HttpHeaders>(){

                public void onSubscribe(Cancellable cancellable) {
                    subscriber.onSubscribe(cancellable);
                }

                public void onSuccess(@Nullable HttpHeaders result) {
                    assert (trailerTransformerState.isStateSet());
                    assert (result != null);
                    HttpHeaders trailersForError = trailerTransformerState.trailersForError();
                    if (trailersForError != null) {
                        for (Map.Entry<CharSequence, CharSequence> trailer : trailersForError) {
                            result.add(trailer.getKey(), trailer.getValue());
                        }
                    } else {
                        try {
                            result = trailersTransformer.payloadComplete(trailerTransformerState.state(), result);
                        }
                        catch (Throwable t) {
                            subscriber.onError(t);
                            return;
                        }
                    }
                    subscriber.onSuccess((Object)result);
                }

                public void onError(Throwable t) {
                    HttpHeaders trailersForError;
                    assert (trailerTransformerState.isStateSet());
                    Throwable payloadErrorCause = trailerTransformerState.payloadErrorCause();
                    if (payloadErrorCause != null) {
                        trailersForError = trailerTransformerState.trailersForError();
                        assert (trailersForError != null);
                        if (payloadErrorCause != t) {
                            LOGGER.info("Trailers source emitted error different than payload, Ignoring.", t);
                        }
                    } else {
                        try {
                            trailersForError = trailersTransformer.catchPayloadFailure(trailerTransformerState.state(), t, StreamingHttpPayloadHolder.this.headersFactory.newEmptyTrailers());
                        }
                        catch (Throwable throwable) {
                            subscriber.onError(throwable);
                            return;
                        }
                    }
                    subscriber.onSuccess((Object)trailersForError);
                }
            });
            this.payloadBody = (raw ? this.rawPayload() : this.payloadBody()).liftSync(subscriber -> {
                final Object state = trailersTransformer.newState();
                trailerTransformerState.reference(state);
                return new PublisherSource.Subscriber<Object>(){

                    public void onSubscribe(PublisherSource.Subscription subscription) {
                        subscriber.onSubscribe(subscription);
                    }

                    public void onNext(@Nullable Object object) {
                        assert (object != null);
                        subscriber.onNext(trailersTransformer.accept(state, object));
                    }

                    public void onError(Throwable t) {
                        HttpHeaders trailersForError;
                        try {
                            trailersForError = trailersTransformer.catchPayloadFailure(state, t, StreamingHttpPayloadHolder.this.headersFactory.newEmptyTrailers());
                        }
                        catch (Throwable throwable) {
                            subscriber.onError(t);
                            return;
                        }
                        trailerTransformerState.trailersForError(t, trailersForError);
                        subscriber.onComplete();
                    }

                    public void onComplete() {
                        subscriber.onComplete();
                    }
                };
            });
        }
        this.payloadInfo.setOnlyEmitsBuffer(!raw);
        if (!HttpProtocolVersion.HTTP_1_0.equals(this.version)) {
            this.payloadInfo.setMayHaveTrailers(true);
            HeaderUtils.addChunkedEncoding(this.headers);
        }
    }

    private Publisher<Buffer> bufferPayload() {
        assert (this.payloadBody != null);
        return this.payloadBody;
    }

    private Publisher<Object> rawPayload() {
        assert (this.payloadBody != null);
        return this.payloadBody;
    }

    private Publisher<Object> emptyOrRawPayload() {
        return this.payloadBody == null ? Publisher.empty() : this.rawPayload();
    }

    private static Publisher filterTrailers(Publisher payloadBody) {
        return payloadBody.filter(o -> !(o instanceof HttpHeaders));
    }

    private static final class TrailerTransformerState {
        private static final Object NULL_STATE = new Object();
        @Nullable
        private Object state;
        @Nullable
        private Throwable payloadErrorCause;
        @Nullable
        private HttpHeaders trailersForError;

        private TrailerTransformerState() {
        }

        @Nullable
        Object state() {
            return this.state == NULL_STATE ? null : this.state;
        }

        void reference(@Nullable Object state) {
            this.state = state == null ? NULL_STATE : state;
        }

        @Nullable
        HttpHeaders trailersForError() {
            return this.trailersForError;
        }

        void trailersForError(Throwable cause, HttpHeaders trailersForError) {
            this.payloadErrorCause = Objects.requireNonNull(cause);
            this.trailersForError = Objects.requireNonNull(trailersForError);
        }

        @Nullable
        Throwable payloadErrorCause() {
            return this.payloadErrorCause;
        }

        boolean isStateSet() {
            return this.state != null;
        }
    }
}

