/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.BlockingIterator;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.http.api.DelegatingToBufferHttpPayloadWriter;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaderValues;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpPayloadWriter;
import io.servicetalk.http.api.HttpSerializer;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import javax.annotation.Nullable;

final class FormUrlEncodedHttpSerializer
implements HttpSerializer<Map<String, List<String>>> {
    static final FormUrlEncodedHttpSerializer UTF8 = new FormUrlEncodedHttpSerializer(StandardCharsets.UTF_8, headers -> headers.set(HttpHeaderNames.CONTENT_TYPE, HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED_UTF_8));
    private final Charset charset;
    private final Consumer<HttpHeaders> addContentType;

    FormUrlEncodedHttpSerializer(Charset charset, Consumer<HttpHeaders> addContentType) {
        this.charset = charset;
        this.addContentType = addContentType;
    }

    @Override
    public Buffer serialize(HttpHeaders headers, Map<String, List<String>> parameters, BufferAllocator allocator) {
        this.addContentType.accept(headers);
        return this.serialize(parameters, allocator);
    }

    @Override
    public BlockingIterable<Buffer> serialize(HttpHeaders headers, BlockingIterable<Map<String, List<String>>> parameters, final BufferAllocator allocator) {
        this.addContentType.accept(headers);
        return () -> {
            final BlockingIterator iterator = parameters.iterator();
            return new BlockingIterator<Buffer>(){

                public boolean hasNext(long timeout, TimeUnit unit) throws TimeoutException {
                    return iterator.hasNext(timeout, unit);
                }

                public Buffer next(long timeout, TimeUnit unit) throws TimeoutException {
                    return FormUrlEncodedHttpSerializer.this.serialize((Map)iterator.next(timeout, unit), allocator);
                }

                public void close() throws Exception {
                    iterator.close();
                }

                public boolean hasNext() {
                    return iterator.hasNext();
                }

                public Buffer next() {
                    return FormUrlEncodedHttpSerializer.this.serialize((Map)iterator.next(), allocator);
                }
            };
        };
    }

    @Override
    public Publisher<Buffer> serialize(HttpHeaders headers, Publisher<Map<String, List<String>>> parameters, BufferAllocator allocator) {
        this.addContentType.accept(headers);
        return parameters.map(values -> this.serialize((Map<String, List<String>>)values, allocator));
    }

    @Override
    public HttpPayloadWriter<Map<String, List<String>>> serialize(HttpHeaders headers, HttpPayloadWriter<Buffer> payloadWriter, BufferAllocator allocator) {
        this.addContentType.accept(headers);
        return new DelegatingToBufferHttpPayloadWriter<Map<String, List<String>>>(payloadWriter, allocator){

            public void write(Map<String, List<String>> object) throws IOException {
                this.delegate.write(FormUrlEncodedHttpSerializer.this.serialize(object, this.allocator));
            }
        };
    }

    @Nullable
    private Buffer serialize(@Nullable Map<String, List<String>> parameters, BufferAllocator allocator) {
        if (parameters == null) {
            return null;
        }
        Buffer buffer = allocator.newBuffer();
        parameters.forEach((key, values) -> values.forEach(value -> {
            if (buffer.writerIndex() != 0) {
                buffer.writeBytes("&".getBytes(this.charset));
            }
            buffer.writeBytes(this.urlEncode((String)key).getBytes(this.charset));
            buffer.writeBytes("=".getBytes(this.charset));
            buffer.writeBytes(this.urlEncode((String)value).getBytes(this.charset));
        }));
        return buffer;
    }

    private String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, this.charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

