/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.http.api.HttpUri;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class QueryStringDecoder {
    private static final int DEFAULT_MAX_PARAMS = 1024;

    private QueryStringDecoder() {
    }

    static Map<String, List<String>> decodeParams(String rawQuery) {
        return QueryStringDecoder.decodeParams(rawQuery, StandardCharsets.UTF_8);
    }

    static Map<String, List<String>> decodeParams(String rawQuery, Charset charset) {
        return QueryStringDecoder.decodeParams(rawQuery, charset, 1024);
    }

    /*
     * Enabled aggressive block sorting
     */
    static Map<String, List<String>> decodeParams(String rawQuery, Charset charset, int maxParams) {
        int i;
        if (maxParams <= 0) {
            throw new IllegalArgumentException("maxParams: " + maxParams + " (expected: > 0)");
        }
        if (rawQuery.isEmpty()) {
            return new LinkedHashMap<String, List<String>>(2);
        }
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        int paramCountDown = maxParams;
        int from = rawQuery.charAt(0) == '?' ? 1 : 0;
        int len = rawQuery.length();
        int nameStart = from;
        int valueStart = -1;
        block5: for (i = from; i < len; ++i) {
            switch (rawQuery.charAt(i)) {
                case '=': {
                    if (nameStart == i) {
                        nameStart = i + 1;
                        break;
                    }
                    if (valueStart >= nameStart) break;
                    valueStart = i + 1;
                    break;
                }
                case '&': 
                case ';': {
                    if (QueryStringDecoder.addParam(rawQuery, nameStart, valueStart, i, charset, params) && --paramCountDown == 0) {
                        return params;
                    }
                    nameStart = i + 1;
                    break;
                }
                case '#': {
                    break block5;
                }
            }
        }
        QueryStringDecoder.addParam(rawQuery, nameStart, valueStart, i, charset, params);
        return params;
    }

    private static boolean addParam(String s, int nameStart, int valueStart, int valueEnd, Charset charset, Map<String, List<String>> params) {
        if (nameStart >= valueEnd) {
            return false;
        }
        if (valueStart <= nameStart) {
            valueStart = valueEnd + 1;
        }
        String name = HttpUri.decodeComponent(s, nameStart, valueStart - 1, false, charset);
        String value = HttpUri.decodeComponent(s, valueStart, valueEnd, false, charset);
        List values = params.computeIfAbsent(name, k -> new ArrayList(1));
        values.add(value);
        return true;
    }
}

