/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.http.api.BlockingStreamingHttpClient;
import io.servicetalk.http.api.BlockingStreamingHttpRequest;
import io.servicetalk.http.api.BlockingStreamingHttpRequestResponseFactory;
import io.servicetalk.http.api.BlockingStreamingHttpResponse;
import io.servicetalk.http.api.BlockingStreamingHttpResponseFactory;
import io.servicetalk.http.api.BlockingUtils;
import io.servicetalk.http.api.DelegatingHttpExecutionContext;
import io.servicetalk.http.api.HttpEventKey;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.RequestResponseFactories;
import io.servicetalk.http.api.ReservedBlockingStreamingHttpConnection;
import io.servicetalk.http.api.ReservedStreamingHttpConnection;
import io.servicetalk.http.api.StreamingHttpClient;
import io.servicetalk.http.api.StreamingHttpConnectionToBlockingStreamingHttpConnection;
import io.servicetalk.transport.api.ConnectionContext;
import io.servicetalk.transport.api.DelegatingConnectionContext;
import io.servicetalk.transport.api.ExecutionContext;
import java.util.Objects;

final class StreamingHttpClientToBlockingStreamingHttpClient
implements BlockingStreamingHttpClient {
    private final StreamingHttpClient client;
    private final HttpExecutionStrategy strategy;
    private final HttpExecutionContext context;
    private final BlockingStreamingHttpRequestResponseFactory reqRespFactory;

    StreamingHttpClientToBlockingStreamingHttpClient(StreamingHttpClient client, HttpExecutionStrategyInfluencer influencer) {
        this.strategy = influencer.influenceStrategy(StreamingHttpConnectionToBlockingStreamingHttpConnection.DEFAULT_BLOCKING_STREAMING_CONNECTION_STRATEGY);
        this.client = client;
        this.context = new DelegatingHttpExecutionContext(client.executionContext()){

            @Override
            public HttpExecutionStrategy executionStrategy() {
                return StreamingHttpClientToBlockingStreamingHttpClient.this.strategy;
            }
        };
        this.reqRespFactory = RequestResponseFactories.toBlockingStreaming(client);
    }

    @Override
    public BlockingStreamingHttpResponse request(BlockingStreamingHttpRequest request) throws Exception {
        return this.request(this.strategy, request);
    }

    @Override
    public ReservedBlockingStreamingHttpConnection reserveConnection(HttpRequestMetaData metaData) throws Exception {
        return this.reserveConnection(this.strategy, metaData);
    }

    @Override
    public ReservedBlockingStreamingHttpConnection reserveConnection(HttpExecutionStrategy strategy, HttpRequestMetaData metaData) throws Exception {
        return new ReservedStreamingHttpConnectionToBlockingStreaming(BlockingUtils.blockingInvocation(this.client.reserveConnection(strategy, metaData)), this.strategy, this.reqRespFactory);
    }

    @Override
    public StreamingHttpClient asStreamingClient() {
        return this.client;
    }

    @Override
    public BlockingStreamingHttpResponse request(HttpExecutionStrategy strategy, BlockingStreamingHttpRequest request) throws Exception {
        return BlockingUtils.blockingInvocation(this.client.request(strategy, request.toStreamingRequest())).toBlockingStreamingResponse();
    }

    @Override
    public HttpExecutionContext executionContext() {
        return this.context;
    }

    @Override
    public BlockingStreamingHttpResponseFactory httpResponseFactory() {
        return this.reqRespFactory;
    }

    @Override
    public void close() throws Exception {
        this.client.close();
    }

    public void closeGracefully() throws Exception {
        this.client.closeGracefully();
    }

    @Override
    public BlockingStreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
        return this.reqRespFactory.newRequest(method, requestTarget);
    }

    static final class ReservedStreamingHttpConnectionToBlockingStreaming
    implements ReservedBlockingStreamingHttpConnection {
        private final ReservedStreamingHttpConnection connection;
        private final HttpExecutionStrategy strategy;
        private final ConnectionContext context;
        private final HttpExecutionContext executionContext;
        private final BlockingStreamingHttpRequestResponseFactory reqRespFactory;

        ReservedStreamingHttpConnectionToBlockingStreaming(ReservedStreamingHttpConnection connection, HttpExecutionStrategyInfluencer influencer) {
            this(connection, influencer.influenceStrategy(StreamingHttpConnectionToBlockingStreamingHttpConnection.DEFAULT_BLOCKING_STREAMING_CONNECTION_STRATEGY), RequestResponseFactories.toBlockingStreaming(connection));
        }

        ReservedStreamingHttpConnectionToBlockingStreaming(ReservedStreamingHttpConnection connection, final HttpExecutionStrategy strategy, BlockingStreamingHttpRequestResponseFactory reqRespFactory) {
            this.connection = Objects.requireNonNull(connection);
            this.strategy = strategy;
            ConnectionContext originalCtx = connection.connectionContext();
            this.executionContext = new DelegatingHttpExecutionContext(connection.executionContext()){

                @Override
                public HttpExecutionStrategy executionStrategy() {
                    return strategy;
                }
            };
            this.context = new DelegatingConnectionContext(originalCtx){

                public ExecutionContext executionContext() {
                    return executionContext;
                }
            };
            this.reqRespFactory = reqRespFactory;
        }

        @Override
        public void release() throws Exception {
            BlockingUtils.blockingInvocation(this.connection.releaseAsync());
        }

        @Override
        public ReservedStreamingHttpConnection asStreamingConnection() {
            return this.connection;
        }

        @Override
        public BlockingStreamingHttpResponse request(BlockingStreamingHttpRequest request) throws Exception {
            return this.request(this.strategy, request);
        }

        @Override
        public ConnectionContext connectionContext() {
            return this.context;
        }

        @Override
        public <T> BlockingIterable<? extends T> transportEventIterable(HttpEventKey<T> eventKey) {
            return this.connection.transportEventStream(eventKey).toIterable();
        }

        @Override
        public BlockingStreamingHttpResponse request(HttpExecutionStrategy strategy, BlockingStreamingHttpRequest request) throws Exception {
            return BlockingUtils.blockingInvocation(this.connection.request(strategy, request.toStreamingRequest())).toBlockingStreamingResponse();
        }

        @Override
        public HttpExecutionContext executionContext() {
            return this.executionContext;
        }

        @Override
        public BlockingStreamingHttpResponseFactory httpResponseFactory() {
            return this.reqRespFactory;
        }

        @Override
        public void close() throws Exception {
            this.connection.close();
        }

        public void closeGracefully() throws Exception {
            this.connection.closeGracefully();
        }

        @Override
        public BlockingStreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
            return this.reqRespFactory.newRequest(method, requestTarget);
        }
    }
}

