/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Objects;

final class QueryStringEncoder {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final StringBuilder uriBuilder;
    private boolean hasParams;

    QueryStringEncoder(String uri) {
        this.uriBuilder = new StringBuilder(uri);
    }

    public void addParam(String name, String value) {
        Objects.requireNonNull(name, "name");
        if (this.hasParams) {
            this.uriBuilder.append('&');
        } else {
            this.uriBuilder.append('?');
            this.hasParams = true;
        }
        QueryStringEncoder.appendComponent(name, this.uriBuilder);
        if (value != null) {
            this.uriBuilder.append('=');
            QueryStringEncoder.appendComponent(value, this.uriBuilder);
        }
    }

    public URI toUri() throws URISyntaxException {
        return new URI(this.toString());
    }

    public String toString() {
        return this.uriBuilder.toString();
    }

    private static void appendComponent(String s, StringBuilder sb) {
        try {
            s = URLEncoder.encode(s, DEFAULT_CHARSET.name());
        }
        catch (UnsupportedEncodingException ignored) {
            throw new UnsupportedCharsetException(DEFAULT_CHARSET.name());
        }
        int idx = s.indexOf(43);
        if (idx == -1) {
            sb.append(s);
            return;
        }
        sb.append(s, 0, idx).append("%20");
        int size = s.length();
        ++idx;
        while (idx < size) {
            char c = s.charAt(idx);
            if (c != '+') {
                sb.append(c);
            } else {
                sb.append("%20");
            }
            ++idx;
        }
    }
}

