/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Executors;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.ClientInvoker;
import io.servicetalk.http.api.ExecutionContextOverridingServiceContext;
import io.servicetalk.http.api.FunctionToSingle;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpService;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;

final class NoOffloadsHttpExecutionStrategy
implements HttpExecutionStrategy {
    static final HttpExecutionStrategy NO_OFFLOADS_NO_EXECUTOR = new NoOffloadsHttpExecutionStrategy();
    @Nullable
    private final Executor executor;

    private NoOffloadsHttpExecutionStrategy() {
        this.executor = null;
    }

    NoOffloadsHttpExecutionStrategy(Executor executor) {
        this.executor = Objects.requireNonNull(executor);
    }

    @Override
    public <FS> Single<StreamingHttpResponse> invokeClient(Executor fallback, Publisher<Object> flattenedRequest, FS flushStrategy, ClientInvoker<FS> client) {
        Publisher flatReq = flattenedRequest.subscribeOnOverride(Executors.immediate());
        return client.invokeClient((Publisher<Object>)flatReq, flushStrategy).map(response -> response.transformRawPayloadBody(p -> p.publishOnOverride(Executors.immediate()))).publishOnOverride(Executors.immediate());
    }

    @Override
    public Publisher<Object> invokeService(Executor fallback, StreamingHttpRequest request, Function<StreamingHttpRequest, Publisher<Object>> service, BiFunction<Throwable, Executor, Publisher<Object>> errorHandler) {
        return service.apply(request.transformRawPayloadBody(payload -> payload.publishOnOverride(Executors.immediate()))).subscribeOnOverride(Executors.immediate());
    }

    @Override
    public StreamingHttpService offloadService(Executor fallback, StreamingHttpService handler) {
        return (ctx, request, responseFactory) -> {
            ExecutionContextOverridingServiceContext wrappedCtx = new ExecutionContextOverridingServiceContext(ctx, this, fallback);
            request = request.transformRawPayloadBody(p -> p.publishOnOverride(Executors.immediate()));
            return handler.handle(wrappedCtx, request, responseFactory).map(r -> r.transformRawPayloadBody(p -> p.subscribeOnOverride(Executors.immediate()))).subscribeOnOverride(Executors.immediate());
        };
    }

    @Override
    public boolean isMetadataReceiveOffloaded() {
        return false;
    }

    @Override
    public boolean isDataReceiveOffloaded() {
        return false;
    }

    @Override
    public boolean isSendOffloaded() {
        return false;
    }

    @Override
    public HttpExecutionStrategy merge(HttpExecutionStrategy other) {
        return this;
    }

    @Override
    public <T> Single<T> invokeService(Executor fallback, Function<Executor, T> service) {
        return new FunctionToSingle<Executor, T>(service, Executors.immediate());
    }

    public <T> Single<T> offloadSend(Executor fallback, Single<T> original) {
        return original.subscribeOnOverride(Executors.immediate());
    }

    public <T> Single<T> offloadReceive(Executor fallback, Single<T> original) {
        return original.publishOnOverride(Executors.immediate());
    }

    public <T> Publisher<T> offloadSend(Executor fallback, Publisher<T> original) {
        return original.subscribeOnOverride(Executors.immediate());
    }

    public <T> Publisher<T> offloadReceive(Executor fallback, Publisher<T> original) {
        return original.publishOnOverride(Executors.immediate());
    }

    public Executor executor() {
        return this.executor;
    }
}

