/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.http.api.DefaultHttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.NoOffloadsHttpExecutionStrategy;
import java.util.Objects;
import javax.annotation.Nullable;

public final class HttpExecutionStrategies {
    static final HttpExecutionStrategy OFFLOAD_NONE_STRATEGY = HttpExecutionStrategies.customStrategyBuilder().mergeStrategy(Builder.MergeStrategy.Merge).build();
    static final HttpExecutionStrategy OFFLOAD_RECEIVE_META_STRATEGY = HttpExecutionStrategies.customStrategyBuilder().offloadReceiveMetadata().mergeStrategy(Builder.MergeStrategy.Merge).build();
    static final HttpExecutionStrategy OFFLOAD_RECEIVE_DATA_STRATEGY = HttpExecutionStrategies.customStrategyBuilder().offloadReceiveData().mergeStrategy(Builder.MergeStrategy.Merge).build();
    static final HttpExecutionStrategy OFFLOAD_RECEIVE_DATA_AND_SEND_STRATEGY = HttpExecutionStrategies.customStrategyBuilder().offloadReceiveData().offloadSend().mergeStrategy(Builder.MergeStrategy.Merge).build();
    static final HttpExecutionStrategy OFFLOAD_ALL_STRATEGY = HttpExecutionStrategies.customStrategyBuilder().offloadAll().mergeStrategy(Builder.MergeStrategy.Merge).build();
    static final HttpExecutionStrategy OFFLOAD_SEND_STRATEGY = HttpExecutionStrategies.customStrategyBuilder().offloadSend().mergeStrategy(Builder.MergeStrategy.Merge).build();

    private HttpExecutionStrategies() {
    }

    public static HttpExecutionStrategy defaultStrategy() {
        return Builder.DEFAULT;
    }

    public static HttpExecutionStrategy defaultStrategy(Executor executor) {
        return HttpExecutionStrategies.customStrategyBuilder().offloadAll().executor(executor).mergeStrategy(Builder.MergeStrategy.ReturnOther).build();
    }

    public static HttpExecutionStrategy noOffloadsStrategy() {
        return NoOffloadsHttpExecutionStrategy.NO_OFFLOADS_NO_EXECUTOR;
    }

    public static Builder customStrategyBuilder() {
        return new Builder();
    }

    @Nullable
    public static HttpExecutionStrategy difference(Executor fallback, HttpExecutionStrategy left, HttpExecutionStrategy right) {
        if (left.equals(right) || right == HttpExecutionStrategies.noOffloadsStrategy()) {
            return null;
        }
        if (left == HttpExecutionStrategies.noOffloadsStrategy()) {
            return right;
        }
        if (right.executor() != null && right.executor() != left.executor() && right.executor() != fallback) {
            return right;
        }
        byte effectiveOffloads = 0;
        if (right.isSendOffloaded() && !left.isSendOffloaded()) {
            effectiveOffloads = (byte)(effectiveOffloads | 4);
        }
        if (right.isMetadataReceiveOffloaded() && !left.isMetadataReceiveOffloaded()) {
            effectiveOffloads = (byte)(effectiveOffloads | 1);
        }
        if (right.isDataReceiveOffloaded() && !left.isDataReceiveOffloaded()) {
            effectiveOffloads = (byte)(effectiveOffloads | 2);
        }
        if (effectiveOffloads != 0) {
            return new DefaultHttpExecutionStrategy(effectiveOffloads, right);
        }
        return null;
    }

    public static final class Builder {
        static final HttpExecutionStrategy DEFAULT = new Builder().offloadAll().mergeStrategy(MergeStrategy.ReturnOther).build();
        @Nullable
        private Executor executor;
        private byte offloads;
        private boolean threadAffinity;
        @Nullable
        private MergeStrategy mergeStrategy;

        private Builder() {
        }

        public Builder offloadReceiveMetadata() {
            return this.addOffload((byte)1);
        }

        public Builder offloadReceiveData() {
            return this.addOffload((byte)2);
        }

        public Builder offloadSend() {
            return this.addOffload((byte)4);
        }

        public Builder offloadAll() {
            return this.offloadReceiveMetadata().offloadReceiveData().offloadSend();
        }

        public Builder offloadNone() {
            this.offloads = 0;
            return this;
        }

        public Builder executor(Executor executor) {
            this.executor = Objects.requireNonNull(executor);
            return this;
        }

        public Builder offloadWithThreadAffinity() {
            this.threadAffinity = true;
            return this;
        }

        Builder mergeStrategy(MergeStrategy mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
            return this;
        }

        public HttpExecutionStrategy build() {
            if (this.offloads == 0 && this.mergeStrategy == null) {
                return this.executor == null ? NoOffloadsHttpExecutionStrategy.NO_OFFLOADS_NO_EXECUTOR : Builder.noOffloadsStrategyWithExecutor(this.executor);
            }
            if (this.mergeStrategy == null) {
                this.mergeStrategy = MergeStrategy.ReturnSelf;
            }
            return new DefaultHttpExecutionStrategy(this.executor, this.offloads, this.threadAffinity, this.mergeStrategy);
        }

        private static HttpExecutionStrategy noOffloadsStrategyWithExecutor(Executor executor) {
            return new NoOffloadsHttpExecutionStrategy(executor);
        }

        private Builder addOffload(byte flag) {
            this.offloads = (byte)(this.offloads | flag);
            return this;
        }

        static enum MergeStrategy {
            ReturnSelf,
            ReturnOther,
            Merge;

        }
    }
}

